// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestRebindContext
{
    static void test(ORB orb, NamingContext root)
	throws UserException
    {
	TestObject test = new TestObject_impl();
	NameComponent[] name1, name2;
	NamingContext context;

	context = root.new_context();

	//
	// Test exceptions
	//

	try
	{
	    //
	    // Try to rebind a context when an intermediate context
	    // doesn't exist
	    //
	    name1 = new NameComponent[2];
	    name1[0] = new NameComponent("bad", "node");
	    name1[1] = new NameComponent("my", "node");
	    root.rebind_context(name1, context);

	    // rebind_context should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.missing_node)
		throw new RuntimeException();
	}

	name1 = new NameComponent[1];
	name1[0] = new NameComponent("object", "");
	root.bind(name1, test);

	try
	{
	    //
	    // Try to rebind a context when an object is in the path
	    //
	    name2 = new NameComponent[2];
	    name2[0] = new NameComponent("object", "");
	    name2[1] = new NameComponent("my", "node");
	    root.rebind_context(name2, context);

	    // rebind_context should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.not_context)
		throw new RuntimeException();
	}

/* XXX Does the spec allow an object binding to be rebound to a context?
   XXX If it doesn't say, should we allow it?
	try
	{
	    //
	    // Try to rebind a context using the name of an existing object
	    //
	    root.rebind_context(name1, context);

	    // rebind_context should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.not_context)
		throw new RuntimeException();
	}
*/

	root.unbind(name1);

	NamingContext ctx = root.new_context();;

	//
	// Test rebind
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("context", "");
	root.bind_context(name1, context);
	root.rebind_context(name1, ctx);
	root.unbind(name1);
	root.rebind_context(name1, ctx);

	root.unbind(name1);

	try
	{
	    //
	    // Try to rebind a context with an invalid name
	    //
	    name1 = new NameComponent[0];
	    root.rebind_context(name1, context);

	    // rebind_context should not have succeeded
	    throw new RuntimeException();
	}
	catch(InvalidName ex)
	{
	    // expected
	}

	try
	{
	    //
	    // Try to rebind a context with an invalid name
	    //
	    name1 = new NameComponent[1];
	    name1[0] = new NameComponent("", "");
	    root.rebind_context(name1, context);

	    // rebind_context should not have succeeded
	    throw new RuntimeException();
	}
	catch(InvalidName ex)
	{
	    // expected
	}

	//
	// Bind an intermediate context for use in more tests
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("ctx", "");
	root.bind_context(name1, context);

	try
	{
	    //
	    // Try to rebind a context when an intermediate context
	    // doesn't exist
	    //
	    name1 = new NameComponent[3];
	    name1[0] = new NameComponent("ctx", "");
	    name1[1] = new NameComponent("bad", "node");
	    name1[2] = new NameComponent("my", "node");
	    root.rebind_context(name1, context);

	    // rebind_context should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.missing_node)
		throw new RuntimeException();
	}

	name1 = new NameComponent[1];
	name1[0] = new NameComponent("object", "");
	context.bind(name1, test);

	try
	{
	    //
	    // Try to bind a context when an object is in the path
	    //
	    name2 = new NameComponent[3];
	    name2[0] = new NameComponent("ctx", "");
	    name2[1] = new NameComponent("object", "");
	    name2[2] = new NameComponent("my", "node");
	    root.rebind_context(name2, ctx);

	    // rebind_context should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.not_context)
		throw new RuntimeException();
	}

	context.unbind(name1);

	//
	// Clean up context
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("ctx", "");
	root.unbind(name1);

	//
	// Test name equality to make sure kind is included in comparisons
	//
	org.omg.CORBA.Object o;
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("context", "kind1");
	name2 = new NameComponent[1];
	name2[0] = new NameComponent("context", "kind2");
	root.bind_context(name1, context);
	o = root.resolve(name1);
	if(o == null)
	    throw new RuntimeException();
	try
	{
	    o = root.resolve(name2);

	    // resolve should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    // expected
	}

	root.unbind(name1);

	ctx.destroy();

	context.destroy();
    }
}
