// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestRename
{
    static void test(ORB orb, NamingContext root)
	throws UserException
    {
	com.ooc.CosNaming.OBNamingContext ext =
	    com.ooc.CosNaming.OBNamingContextHelper.narrow(root);
	if(ext == null)
	    throw new RuntimeException();

	TestObject test = new TestObject_impl();
	NameComponent[] name1, name2;
	com.ooc.CosNaming.OBNamingContextPackage.ExtendedBinding[] list;

	//
	// Test exceptions
	//
 
	try
	{
	    //
	    // Try to rename using an invalid old name
	    //
	    name1 = new NameComponent[0];
	    name2 = new NameComponent[1];
	    name2[0] = new NameComponent("new_name", "");
	    ext.rename(name1, name2);

	    // rename should not have succeeded
	    throw new RuntimeException();
	}
	catch(InvalidName ex)
	{
	    // expected
	}

	try
	{
	    //
	    // Try to rename a non-existent binding
	    //
	    name1 = new NameComponent[1];
	    name1[0] = new NameComponent("bad_name", "");
	    name2 = new NameComponent[1];
	    name2[0] = new NameComponent("new_name", "");
	    ext.rename(name1, name2);

	    // rename should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.missing_node)
		throw new RuntimeException();
	}

	name1 = new NameComponent[1];
	name1[0] = new NameComponent("old_name", "");
	ext.bind(name1, test);

	try
	{
	    //
	    // Try to rename using an invalid new name
	    //
	    name2 = new NameComponent[0];
	    ext.rename(name1, name2);

	    // rename should not have succeeded
	    throw new RuntimeException();
	}
	catch(InvalidName ex)
	{
	    // expected
	}
 
	//
	// Verify rename works
	//
	name2 = new NameComponent[1];
	name2[0] = new NameComponent("new_name", "new_kind");
	ext.rename(name1, name2);
	list = ext.list_extended();
	if(list.length != 1)
	    throw new RuntimeException();
	if(!list[0].binding_name[0].id.equals("new_name"))
	    throw new RuntimeException();
	if(!list[0].binding_name[0].kind.equals("new_kind"))
	    throw new RuntimeException();

	//
	// Test exceptions
	//
 
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("old_name", "");
	ext.bind(name1, test);

	try
	{
	    //
	    // Try to rename old_name to new_name,new_kind -
	    // which already exists
	    //
	    name2 = new NameComponent[1];
	    name2[0] = new NameComponent("new_name", "new_kind");
	    ext.rename(name1, name2);

	    // rename should not have succeeded
	    throw new RuntimeException();
	}
	catch(AlreadyBound ex)
	{
	    // expected
	}

	//
	// Clean up
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("old_name", "");
	ext.unbind(name1);
	name1[0] = new NameComponent("new_name", "new_kind");
	ext.unbind(name1);
/*
	try
	{
	    //
	    // Try to rename an object when an intermediate context
	    // doesn't exist
	    //
	    name1 = new NameComponent[2];
	    name1[0] = new NameComponent("bad", "node");
	    name1[1] = new NameComponent("my", "node");
	    name2 = new NameComponent[2];
	    name2[0] = new NameComponent("bad", "node");
	    name2[1] = new NameComponent("new", "node");
//        ext.rename(name1, name2);
	    // rename should not have succeeded
//	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.missing_node)
		throw new RuntimeException();
	}

	name1 = new NameComponent[1];
	name1[0] = new NameComponent("object", "");
	ext.bind(name1, test);

	try
	{
	    //
	    // Try to rename an object when an object is in the path
	    //
	    name1 = new NameComponent[2];
	    name1[0] = new NameComponent("object", "");
	    name1[1] = new NameComponent("object1", "");
	    name2 = new NameComponent[2];
	    name2[0] = new NameComponent("object", "");
	    name2[0] = new NameComponent("object2", "");
//        ext.rename(name1, name2);
	    // rename should not have succeeded
//	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.not_context)
		throw new RuntimeException();
	}

	name1 = new NameComponent[1];
	name1[0] = new NameComponent("object", "");
	ext.unbind(name1);
*/

	//
	// Create a context, then bind an object in that context.
	// We're going to test how rename() handles two names of
	// different depths.
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("ctx", "");
	NamingContext context;
	context = ext.bind_new_context(name1);
	name1[0].id = "object";
	context.bind(name1, test);

	try
	{
	    //
	    // Try to rename a binding to a new name that has a different
	    // depth than the old name
	    //
	    name1 = new NameComponent[2];
	    name1[0] = new NameComponent("ctx", "");
	    name1[1] = new NameComponent("object", "");
	    name2 = new NameComponent[1];
	    name2[0] = new NameComponent("new_object", "");
	    ext.rename(name1, name2);

	    // rename should not have succeeded
	    throw new RuntimeException();
	}
	catch(InvalidName ex)
	{
	    // expected
	}

	name1 = new NameComponent[1];
	name1[0] = new NameComponent("object", "");
	context.unbind(name1);
	name1[0].id = "ctx";
	ext.unbind(name1);
	context.destroy();
    }
}
