// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestResolve
{
    static void test(ORB orb, NamingContext root)
	throws UserException
    {
	org.omg.CORBA.Object obj;
	TestObject test = new TestObject_impl();
	NameComponent[] name1, name2;
	NamingContext context;

	//
	// Test exceptions
	//

	try
	{
	    //
	    // Try to resolve a binding that doesn't exist
	    //
	    name1 = new NameComponent[1];
	    name1[0] = new NameComponent("bad", "node");
	    obj = root.resolve(name1);

	    // resolve should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.missing_node)
		throw new RuntimeException();
	    if(!ex.rest_of_name[0].id.equals("bad") ||
	       !ex.rest_of_name[0].kind.equals("node"))
		throw new RuntimeException();
	}

	name1 = new NameComponent[1];
	name1[0] = new NameComponent("object", "");
	root.bind(name1, test);

	try
	{
	    //
	    // Try to resolve a binding when an object is in the path
	    //
	    name2 = new NameComponent[2];
	    name2[0] = new NameComponent("object", "");
	    name2[1] = new NameComponent("my", "node");
	    obj = root.resolve(name2);

	    // resolve should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.not_context)
		throw new RuntimeException();
	}

        //
	// Test resolve
	//
	obj = root.resolve(name1);
	if(!obj._is_equivalent(test))
	    throw new RuntimeException();
	root.rebind(name1, null);
	obj = root.resolve(name1);
	if(obj != null)
	    throw new RuntimeException();
	root.unbind(name1);

	try
	{
	    //
	    // Try to resolve a binding with an invalid name
	    //
	    name1 = new NameComponent[0];
	    root.resolve(name1);

	    // resolve should not have succeeded
	    throw new RuntimeException();
	}
	catch(InvalidName ex)
	{
	    // expected
	}

/*
	try
	{
	    //
	    // Try to resolve a binding with an invalid name
	    //
	    name1 = new NameComponent[1];
	    name1[0] = new NameComponent("", "");
	    root.resolve(name1);

	    // resolve should not have succeeded
	    throw new RuntimeException();
	}
	catch(InvalidName ex)
	{
	    // expected
	}
*/

	//
	// Bind an intermediate context for use in more tests
	//
	context = root.new_context();
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("ctx", "");
	root.bind_context(name1, context);

	try
	{
	    //
	    // Try to resolve a binding when an intermediate context
	    // doesn't exist
	    //
	    name1 = new NameComponent[3];
	    name1[0] = new NameComponent("ctx", "");
	    name1[1] = new NameComponent("bad", "node");
	    name1[2] = new NameComponent("my", "node");
	    root.resolve(name1);

	    // resolve should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.missing_node)
		throw new RuntimeException();
	}

	name1 = new NameComponent[1];
	name1[0] = new NameComponent("object", "");
	context.bind(name1, test);

	try
	{
	    //
	    // Try to resolve a binding when an object is in the path
	    //
	    name2 = new NameComponent[3];
	    name2[0] = new NameComponent("ctx", "");
	    name2[1] = new NameComponent("object", "");
	    name2[2] = new NameComponent("my", "node");
	    root.resolve(name2);

	    // bind should not have succeeded
	    throw new RuntimeException();
	}
	catch(NotFound ex)
	{
	    if(ex.why != NotFoundReason.not_context)
		throw new RuntimeException();
	}

	//
	// Test resolve
	//
	name2 = new NameComponent[2];
	name2[0] = new NameComponent("ctx", "");
	name2[1] = new NameComponent("object", "");
	obj = root.resolve(name2);
	if(!obj._is_equivalent(test))
	    throw new RuntimeException();
 
	context.unbind(name1);

	//
	// Clean up context
	//
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("ctx", "");
	root.unbind(name1);
	context.destroy();

	//
	// Test name equality to make sure kind is included in comparisons
	//
	org.omg.CORBA.Object o;
	name1 = new NameComponent[1];
	name1[0] = new NameComponent("object", "kind1");
	name2 = new NameComponent[1];
	name2[0] = new NameComponent("object", "kind2");
	root.bind(name1, test);
	root.bind(name2, null);
	o = root.resolve(name1);
	if(o == null)
	    throw new RuntimeException();
	o = root.resolve(name2);
	if(o != null)
	    throw new RuntimeException();
	root.unbind(name1);
	root.unbind(name2);
    }
}
