// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestToName
{
    static void test(ORB orb, NamingContextExt root)
	throws UserException
    {
	NameComponent[] name;
	String str;

	//
	// Test name components with both ID and Kind field
	//
	str = "first.node/second.node";
	name = root.to_name(str);
	if(name.length != 2)
	    throw new RuntimeException();
	if(!(name[0].id.equals("first") &&
	     name[0].kind.equals("node")))
	    throw new RuntimeException();
	if(!(name[1].id.equals("second") &&
	     name[1].kind.equals("node")))
	    throw new RuntimeException();

	//
	// Test name components with missing ID field
	//
	str = "first.node/.node";
	name = root.to_name(str);
	if(name.length != 2)
	    throw new RuntimeException();
	if(!(name[0].id.equals("first") &&
	     name[0].kind.equals("node")))
	    throw new RuntimeException();
	if(!(name[1].id.equals("") &&
	     name[1].kind.equals("node")))
	    throw new RuntimeException();

	//
	// Test node with empty ID and Kind field
	//
	str = "first.node//third.node";
	name = root.to_name(str);
	if(name.length != 3)
	    throw new RuntimeException();
	if(!(name[0].id.equals("first") &&
	     name[0].kind.equals("node")))
	    throw new RuntimeException();
	if(!(name[1].id.equals("") &&
	     name[1].kind.equals("")))
	    throw new RuntimeException();
	if(!(name[2].id.equals("third") &&
	     name[2].kind.equals("node")))
	    throw new RuntimeException();

	//
	// Test nodes with characters that are escaped
	//
	str = "first.node\\.bla/second\\/bla.node/third.\\\\node";
	name = root.to_name(str);
	if(name.length != 3)
	    throw new RuntimeException();
	if(!(name[0].id.equals("first") &&
	     name[0].kind.equals("node.bla")))
	    throw new RuntimeException();
	if(!(name[1].id.equals("second/bla") &&
	     name[1].kind.equals("node")))
	    throw new RuntimeException();
	if(!(name[2].id.equals("third") &&
	     name[2].kind.equals("\\node")))
	    throw new RuntimeException();

	//
	// Test empty name
	//
	try
	{
	    str = "";
	    name = root.to_name(str);

            // to_name should not have succeeded
            throw new RuntimeException();
	}
	catch(InvalidName ex)
	{
	    // Expected
	}
    }
}
