// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestToString
{
    static void test(ORB orb, NamingContextExt root)
	throws UserException
    {
	NameComponent[] name;
	String str;

	//
	// Test name components with both ID and Kind field
	//
	name = new NameComponent[2];
	name[0] = new NameComponent("first", "node");
	name[1] = new NameComponent("second", "node");
	str = root.to_string(name);
	if(!str.equals("first.node/second.node"))
	    throw new RuntimeException();

	//
	// Test name components with missing Kind field
	//
	name = new NameComponent[2];
	name[0] = new NameComponent("first", "node");
	name[1] = new NameComponent("second", "");
	str = root.to_string(name);
	if(!str.equals("first.node/second"))
	    throw new RuntimeException();

	//
	// Test name components with missing ID field
	//
	name = new NameComponent[2];
	name[0] = new NameComponent("first", "node");
	name[1] = new NameComponent("", "kind");
	str = root.to_string(name);
	if(!str.equals("first.node/.kind"))
	    throw new RuntimeException();

	//
	// Test node with empty ID and Kind field
	//
	name = new NameComponent[3];
	name[0] = new NameComponent("first", "node");
	name[1] = new NameComponent("", "");
	name[2] = new NameComponent("third", "node");
	str = root.to_string(name);
	if(!str.equals("first.node//third.node"))
	    throw new RuntimeException();

	//
	// Test nodes with characters that have to be escaped
	//
	name = new NameComponent[3];
	name[0] = new NameComponent("first", "node.bla");
	name[1] = new NameComponent("second/bla", "node");
	name[2] = new NameComponent("third", "\\node");
	str = root.to_string(name);
	if(!str.equals("first.node\\.bla/second\\/bla.node/third.\\\\node"))
	    throw new RuntimeException();

	//
	// Test empty name
	//
	name = new NameComponent[0];
	str = root.to_string(name);
	if(str.length() != 0)
	    throw new RuntimeException();
    }
}
