// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package test;

import org.omg.CORBA.*;
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;

class TestToURL
{
    static void test(ORB orb, NamingContextExt root)
	throws UserException
    {
	String addr;
	String name;
	String str;

	//
	// Test stringified names without URL escapes
	//
	addr = "myhost.xyz.com";
	name = "first.node";
	str = root.to_url(addr, name);
	if(!str.equals("iiopname://myhost.xyz.com/first.node"))
	    throw new RuntimeException();

        addr = "myhost.555.xyz.com,my_backup_host.555xyz.com:900";
	name ="first.node";
	str = root.to_url(addr, name);
	if(!str.equals("iiopname://myhost.555.xyz.com," +
	    "my_backup_host.555xyz.com:900/first.node"))
	    throw new RuntimeException();

	//
	// Test stringified names with URL escapes
	//
	addr = "";
	name = "<a>.b/c.d";
	str = root.to_url(addr, name);
	if(!str.equals("iiopname:///%3Ca%3E.b/c.d"))
	    throw new RuntimeException();

	addr = "";
	name = "a.b/  c.d";
	str = root.to_url(addr, name);
	if(!str.equals("iiopname:///a.b/%20%20c.d"))
	    throw new RuntimeException();

	addr = "";
	name = "a%b/c%d";
	str = root.to_url(addr, name);
	if(!str.equals("iiopname:///a%25b/c%25d"))
	    throw new RuntimeException();
    }
}
