// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package chat;

import org.omg.CORBA.*;
import java.applet.*;
import java.io.*;
import java.util.*;

public class Client extends Applet
{
    //
    // Standalone program initialization
    //
    public static
    void main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

        try
        {
            //
            // Create ORB and BOA
            //
            ORB orb = ORB.init(args, props);
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	    //
	    // Get host and port
	    //
	    String host = null;
	    Integer port = null;
	    try
	    {
		BufferedReader dataIn =
		    new BufferedReader(new InputStreamReader(System.in));
		System.out.print("Host name? ");
		host = dataIn.readLine();
		System.out.print("Port number? ");
		String p = dataIn.readLine();
		port = new Integer(p);
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't read from `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }

	    System.out.println("Using object `Chat-Server' from host `" +
			       host + "' on port " + port.intValue() + "...");

	    //
	    // Get "server" object
	    //
	    String url =
		"iiop://" + host + ":" + port.intValue() + "/Chat-Server";
	    org.omg.CORBA.Object obj = orb.string_to_object(url);
	    if(obj == null)
		throw new RuntimeException();

	    Broadcaster server = BroadcasterHelper.narrow(obj);

	    //
	    // Initialize the servers so that incoming requests are
	    // handled from this point on
	    //
	    ((com.ooc.CORBA.BOA)boa).init_servers();

	    //
	    // Create new client window
	    //
	    new ClientWindow(server, boa);

            //
            // Run implementation
            //
            boa.impl_is_ready(null);
	}
        catch(SystemException ex)
        {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }

	System.exit(0);
    }

    //
    // Applet start
    //
    public void
    start()
    {
	ClientWindow window = null;

        try
        {
            //
            // Create ORB and BOA
            //
            com.ooc.CORBA.ORB orb =
		(com.ooc.CORBA.ORB)ORB.init(this, new java.util.Properties());
            BOA boa = orb.BOA_init(this, new java.util.Properties());

	    //
	    // Get "server" object
	    //
	    String url = getParameter("ior");
	    org.omg.CORBA.Object obj = orb.string_to_object(url);
	    if(obj == null)
		throw new RuntimeException();

	    Broadcaster server = BroadcasterHelper.narrow(obj);

	    //
	    // Initialize the servers so that incoming requests are
	    // handled from this point on
	    //
	    ((com.ooc.CORBA.BOA)boa).init_servers();

	    //
	    // Create new client window
	    //
	    window = new ClientWindow(server, boa);

            //
            // Run implementation
            //
            boa.impl_is_ready(null);
	}
        catch(SystemException ex)
        {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
	}

	if(window != null)
	    window.dispose();
    }
}
