// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package chat;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import org.omg.CORBA.*;

final class ClientWindow extends Frame
{
    //
    // The receiver
    //
    private Receiver_impl receiver_;

    //
    // The "Widgets"
    //
    private TextField inputArea_;
    private TextArea outputArea_;
    private MenuItem quit_;
    private MenuItem info_;
    private MenuItem cmds_;

    //
    // Constructor
    //
    ClientWindow(Broadcaster server, BOA boa)
    {
	//
	// Create client window
	//
        MenuBar menubar = new MenuBar();

        Menu menuFile = new Menu("File", true);
        menubar.add(menuFile);
	quit_ = new MenuItem("Quit");
	menuFile.add(quit_);
	quit_.addActionListener(new ActionListener()
	{
	    public void
	    actionPerformed(ActionEvent e)
	    {
		receiver_.cmdQuit();
	    }
	});

	Menu menuHelp = new Menu("Help");
	menubar.add(menuHelp);

	info_ = new MenuItem("About Java-Chat...");
	menuHelp.add(info_);
	info_.addActionListener(new ActionListener()
	{
	    public void
	    actionPerformed(ActionEvent e)
	    {
		receiver_.cmdAbout();
	    }
	});

	cmds_ = new MenuItem("Commands...");
	menuHelp.add(cmds_);
	cmds_.addActionListener(new ActionListener()
	{
	    public void
	    actionPerformed(ActionEvent e)
	    {
		receiver_.cmdHelp();
	    }
	});

        menubar.setHelpMenu(menuHelp);

        setMenuBar(menubar);

	setFont(new Font("Courier", Font.PLAIN, 12));

        GridBagLayout l = new GridBagLayout();
	setLayout(l);

	GridBagConstraints c1 = new GridBagConstraints();
	outputArea_ = new TextArea(24, 80);
	outputArea_.setEditable(false);
	c1.fill = GridBagConstraints.BOTH;
	c1.gridx = 0;
	c1.gridy = 0;
	c1.gridwidth = 1;
	c1.gridheight = 1;
	c1.weightx = 1.0;
	c1.weighty = 1.0;
	add(outputArea_);
	l.setConstraints(outputArea_, c1);

	GridBagConstraints c2 = new GridBagConstraints();
	inputArea_ = new TextField(80);
	inputArea_.setEditable(true);
	inputArea_.addActionListener(new ActionListener()
	{
	    public void
	    actionPerformed(ActionEvent e)
	    {
		String input = inputArea_.getText();
	    
		if(input.length() > 0)
		    receiver_.parse(input);
	    
		inputArea_.setText("");
	    }
	});

	c2.fill = GridBagConstraints.BOTH;
	c2.gridx = 0;
	c2.gridy = 1;
	c2.gridwidth = 1;
	c2.gridheight = 1;
	c2.weightx = 1.0;
	c2.weighty = 0.0;
	add(inputArea_);
	l.setConstraints(inputArea_, c2);

	addWindowListener(new WindowAdapter()
        {
            public void
            windowClosing(WindowEvent e)
            {
		receiver_.cmdQuit();
            }
        });

	pack();
        show();

	//
	// Create client object
	//
	receiver_ = new Receiver_impl(this, server, boa);
    }

    //
    // Print message
    //
    public void
    print(String text)
    {
	outputArea_.append(text);
	outputArea_.append("\n");
    }
}
