// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package chat;

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

final public class Server
{
    public static void
    main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

        try
        {
            //
            // Create ORB and BOA
            //
            ORB orb = ORB.init(args, props);
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

            //
            // Create implementation object
            //
            Broadcaster_impl p = new Broadcaster_impl();
	    ((com.ooc.CORBA.ORB)orb).connect(p, "Chat-Server");

	    //
	    // Save reference as html
	    //
	    try
	    {
		String ref = orb.object_to_string(p);
 		String refFile = "Chat.html";
		FileOutputStream file = new FileOutputStream(refFile);
		PrintWriter out = new PrintWriter(file);
		out.println("<applet codebase=\"classes\" " +
			    "code=\"chat/Client.class\" " +
			    "width=500 height=300>");
		out.println("<param name=ior value=\"" + ref + "\">");
		out.println("<param name=org.omg.CORBA.ORBClass " +
			    "value=com.ooc.CORBA.ORB>");
		out.println("<param name=org.omg.CORBA.ORBSingletonClass " +
			    "value=com.ooc.CORBA.ORBSingleton>");
		out.println("</applet>");
		out.flush();
		file.close();
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't write to `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }

	    //
	    // Print "server started" message
	    //
	    Date date = new Date();
	    String d = date.toString();
	    System.out.println("*** Server started at " + d);;

            //
	    // Print host and port
	    //
	    com.ooc.OCI.AccRegistry registry =
		((com.ooc.CORBA.BOA)boa).get_acc_registry();
	    com.ooc.OCI.Acceptor[] acceptors = registry.get_acceptors();

	    for(int i = 0 ; i < acceptors.length ; i++)
	    {
		com.ooc.OCI.AcceptorInfo info = acceptors[i].get_info();
		com.ooc.OCI.IIOP.AcceptorInfo iiopInfo =
		    com.ooc.OCI.IIOP.AcceptorInfoHelper.narrow(info);

		if(iiopInfo != null)
		{
		    String host = iiopInfo.host();
		    short portShort = iiopInfo.port();
		    int port;
		    if(portShort < 0)
			port = 0xffff + (int)portShort + 1;
		    else
			port = (int)portShort;

		    System.out.println("*** Running on host `" + host +
				       "', port number " + port);
		}
	    }

            //
            // Run implementation
            //
            boa.impl_is_ready(null);
         }
        catch(SystemException ex)
        {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
 
	System.exit(0);
   }
}
