// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package hello;

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

public class Client extends java.applet.Applet implements ActionListener
{
    //
    // Standalone program initialization
    //
    public static void main(String args[])
    {
	//
	// For debugging purposes
	//
	Runtime.runFinalizersOnExit(true);

	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
            //
            // Create ORB
            //
            ORB orb = ORB.init(args, props);

	    //
	    // Get "hello" object
	    //
	    String ref = null;
	    try
	    {
		String refFile = "Hello.ref";
		FileInputStream file = new FileInputStream(refFile);
		BufferedReader in =
		    new BufferedReader(new InputStreamReader(file));
		ref = in.readLine();
		file.close();
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't read from `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }

	    org.omg.CORBA.Object obj = orb.string_to_object(ref);
	    if(obj == null)
		throw new RuntimeException();

	    Hello hello = HelloHelper.narrow(obj);
	    if(hello == null)
		throw new RuntimeException();
	    
	    //
	    // Main loop
	    //
	    System.out.println("Enter 'h' for hello or 'x' for exit:");

	    int c;

	    try
	    {
		String input;
		do
		{
		    System.out.print("> ");
		    java.io.DataInputStream dataIn =
			new java.io.DataInputStream(System.in);
		    BufferedReader in =
			new BufferedReader(new InputStreamReader(dataIn));
		    input = in.readLine();

		    if(input.equals("h"))
			hello.hello();
		}
		while(!input.equals("x"));
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't read from `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }
	}
	catch(COMM_FAILURE ex)
	{
	    System.err.println(ex.getMessage());
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }

    //
    // Members only needed for applet
    //
    private Hello hello_;
    private Button button_;

    //
    // Applet initialization
    //
    public void init()
    {
	String ior = getParameter("ior");

	//
	// Create ORB
	//
	ORB orb = ORB.init(this, null);

	//
	// Create client object
	//
	org.omg.CORBA.Object obj = orb.string_to_object(ior);
	if(obj == null)
	    throw new RuntimeException();

	hello_ = HelloHelper.narrow(obj);

	//
	// Add hello button
	//
	button_ = new Button("Hello");
	button_.addActionListener(this);
	this.add(button_);
    }

    //
    // Handle events
    //
    public void
    actionPerformed(ActionEvent event)
    {
	hello_.hello();
    }
}
