// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package hello;

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

public class Server_tie
{
    public static void main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
            //
            // Create ORB and BOA
            //
            ORB orb = ORB.init(args, props);
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	    //
	    // Create delegate object
	    //
	    Hello_impl_tie d = new Hello_impl_tie();

	    //
	    // Create tie object
	    //
	    _HelloImplBase_tie p = new _HelloImplBase_tie(d);

	    //
	    // Save reference
	    //
	    try
	    {
		String ref = orb.object_to_string(p);
 		String refFile = "Hello.ref";
		FileOutputStream file = new FileOutputStream(refFile);
		PrintWriter out = new PrintWriter(file);
		out.println(ref);
		out.flush();
		file.close();
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't write to `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }

	    //
	    // Save reference as html
	    //
	    try
	    {
		String ref = orb.object_to_string(p);
 		String refFile = "Hello.html";
		FileOutputStream file = new FileOutputStream(refFile);
		PrintWriter out = new PrintWriter(file);
		out.println("<applet codebase=\"classes\" " +
			    "code=\"hello/Client.class\" " +
			    "width=500 height=300>");
		out.println("<param name=ior value=\"" + ref + "\">");
		out.println("<param name=org.omg.CORBA.ORBClass " +
			    "value=com.ooc.CORBA.ORB>");
		out.println("<param name=org.omg.CORBA.ORBSingletonClass " +
			    "value=com.ooc.CORBA.ORBSingleton>");
		out.println("</applet>");
		out.flush();
		file.close();
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't write to `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }

	    //
	    // Run implementation
	    //
	    boa.impl_is_ready(null);
	}
	catch(SystemException ex)
	{
	    System.err.println(ex.getMessage());
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }
}
