// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package nested;

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

public class Peer1
{
    public static void main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
            //
            // Create ORB and BOA
            //
            ORB orb = ORB.init(args, props);
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	    //
	    // Set the concurrency model
	    //
	    com.ooc.CORBA.ORB.conc_model(
		com.ooc.CORBA.ORB.ConcModel.ConcModelThreaded);

	    if(com.ooc.CORBA.BOA.conc_model() !=
	       com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPool)
	    {
		com.ooc.CORBA.BOA.conc_model(
		    com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPerRequest);
	    }

	    //
	    // Create implementation object
	    //
	    Peer_impl p1 = new Peer_impl();

	    //
	    // Save reference
	    //
	    try
	    {
		String ref = orb.object_to_string(p1);
 		String refFile = "Peer.ref";
		FileOutputStream file = new FileOutputStream(refFile);
		PrintWriter out = new PrintWriter(file);
		out.println(ref);
		out.flush();
		file.close();
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't write to `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }

	    //
	    // Run implementation
	    //
	    boa.impl_is_ready(null);
	}
	catch(SystemException ex)
	{
	    System.err.println(ex.getMessage());
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }
}
