// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package nested;

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

public class Peer2
{
    public static void main(String args[])
    {
	//
	// For debugging purposes
	//
	Runtime.runFinalizersOnExit(true);

	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
            //
            // Create ORB and BOA
            //
            ORB orb = ORB.init(args, props);
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	    //
	    // Set the concurrency model
	    //
	    com.ooc.CORBA.ORB.conc_model(
		com.ooc.CORBA.ORB.ConcModel.ConcModelThreaded);

	    if(com.ooc.CORBA.BOA.conc_model() !=
	       com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPool)
	    {
		com.ooc.CORBA.BOA.conc_model(
		    com.ooc.CORBA.BOA.ConcModel.ConcModelThreadPerRequest);
	    }

	    //
	    // Create implementation object
	    //
	    Peer_impl p2 = new Peer_impl();

	    //
	    // Get other object
	    //
	    String ref = null;
	    try
	    {
		String refFile = "Peer.ref";
		FileInputStream file = new FileInputStream(refFile);
		BufferedReader in =
		    new BufferedReader(new InputStreamReader(file));
		ref = in.readLine();
		file.close();
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't read from `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }

	    org.omg.CORBA.Object obj = orb.string_to_object(ref);
	    if(obj == null)
		throw new RuntimeException();
	    
	    Peer p1 = PeerHelper.narrow(obj);

	    //
	    // Initialize the servers so that incoming requests are
	    // handled from this point on
	    //
	    ((com.ooc.CORBA.BOA)boa).init_servers();

	    //
	    // Start recursive decrement
	    //
	    while(true)
	    {
		try
		{
		    System.out.print("Enter a number (0 to exit): ");
		    java.io.DataInputStream dataIn =
			new java.io.DataInputStream(System.in);
		    BufferedReader in =
			new BufferedReader(new InputStreamReader(dataIn));
		    String number = in.readLine();
		    Integer integer = new Integer(number);

		    if(integer.intValue() <= 0)
			break;
		    
		    //
		    // Run demo
		    //
		    long t = System.currentTimeMillis();
		    p1.decrement(new IntHolder(integer.intValue()), p2);
		    t = System.currentTimeMillis() - t;
		    double td = (double)t / 1000.0;
		    System.out.println("Time needed: " + td);
		}
		catch(IOException ex)
		{
		    System.err.println("Can't read from `" +
				       ex.getMessage() + "'");
		    System.exit(1);
		}
	    }
	}
	catch(SystemException ex)
	{
	    System.err.println(ex.getMessage());
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }
}
