// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package hello;

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

public class Client extends java.applet.Applet implements ActionListener
{
    //
    // The close callback class
    //
    static class CloseCB_impl extends com.ooc.CORBA.LocalObject
	implements com.ooc.OCI.CloseCB
    {
	public void close_cb(com.ooc.OCI.TransportInfo transport_info)
	{
	    com.ooc.OCI.IIOP.TransportInfo iiopInfo =
		com.ooc.OCI.IIOP.TransportInfoHelper.narrow(transport_info);

	    if(iiopInfo != null)
	    {
		int[] remoteAddr = Converter.addr(iiopInfo.remote_addr());
		int remotePort = Converter.port(iiopInfo.remote_port());

		System.out.println("Close connection to: " +
				   remoteAddr[0] + "." +
				   remoteAddr[1] + "." +
				   remoteAddr[2] + "." +
				   remoteAddr[3] + ":" + remotePort);
	    }
	}
    };

    //
    // The connect callback class
    //
    static class ConnectCB_impl extends com.ooc.CORBA.LocalObject
	implements com.ooc.OCI.ConnectCB
    {
	public void connect_cb(com.ooc.OCI.TransportInfo transport_info)
	{
	    com.ooc.OCI.IIOP.TransportInfo iiopInfo =
		com.ooc.OCI.IIOP.TransportInfoHelper.narrow(transport_info);
	    
	    if(iiopInfo != null)
	    {
		int[] remoteAddr = Converter.addr(iiopInfo.remote_addr());
		int remotePort = Converter.port(iiopInfo.remote_port());
		
		System.out.println("Connection to: " +
				   remoteAddr[0] + "." +
				   remoteAddr[1] + "." +
				   remoteAddr[2] + "." +
				   remoteAddr[3] + ":" + remotePort);
		
		String input = null;
		do
		{
		    System.out.print("Refuse connection (y/n)? ");
		    java.io.DataInputStream dataIn =
			new java.io.DataInputStream(System.in);
		    BufferedReader in =
			new BufferedReader(new InputStreamReader(dataIn));
		    try
		    {
			input = in.readLine();
		    }
		    catch(IOException ex)
		    {
		    }
		}
		while(!input.equals("y") && !input.equals("n"));

		if(input.equals("y"))
		    throw new org.omg.CORBA.NO_PERMISSION();

		//
		// Add the close callback object
		//
		com.ooc.OCI.CloseCB closeCB = new CloseCB_impl();
		iiopInfo.add_close_cb(closeCB);
	    }
	}
    };

    //
    // Standalone program initialization
    //
    public static void main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
            //
            // Create ORB
            //
            ORB orb = ORB.init(args, props);

            //
            // Add the connect callback object to the ConFactory for the
            // IIOP OCI Plug-In.
            //
            com.ooc.OCI.ConFactoryRegistry registry =
                ((com.ooc.CORBA.ORB)orb).get_con_factory_registry();
            com.ooc.OCI.ConFactory[] factories = registry.get_factories();

            for(int i = 0; i < factories.length; ++i)
            {
		com.ooc.OCI.ConFactoryInfo info = factories[i].get_info();
		com.ooc.OCI.IIOP.ConFactoryInfo iiopInfo =
		    com.ooc.OCI.IIOP.ConFactoryInfoHelper.narrow(info);
		
		if(iiopInfo != null)
                {
                    //
                    // Add the connect callback object
                    //
                    com.ooc.OCI.ConnectCB connectorCB = new ConnectCB_impl();
                    info.add_connect_cb(connectorCB);
                }
            }

	    //
	    // Get "hello" object
	    //
	    String ref = null;
	    try
	    {
		String refFile = "Hello.ref";
		FileInputStream file = new FileInputStream(refFile);
		BufferedReader in =
		    new BufferedReader(new InputStreamReader(file));
		ref = in.readLine();
		file.close();
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't read from `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }

	    org.omg.CORBA.Object obj = orb.string_to_object(ref);
	    if(obj == null)
		throw new RuntimeException();

            //
            // Display information on the host and port number to which
            // we'll attempt to connect.
            //
            org.omg.CORBA.portable.ObjectImpl objImpl =
                (org.omg.CORBA.portable.ObjectImpl)obj;
            com.ooc.CORBA.Delegate objDelegate =
                (com.ooc.CORBA.Delegate)objImpl._get_delegate();

            com.ooc.OCI.ConnectorInfo info =
                objDelegate.get_oci_connector_info();
	    com.ooc.OCI.IIOP.ConnectorInfo iiopInfo =
		com.ooc.OCI.IIOP.ConnectorInfoHelper.narrow(info);

            if(iiopInfo != null)
            {
                int[] remoteAddr = Converter.addr(iiopInfo.remote_addr());
                int remotePort = Converter.port(iiopInfo.remote_port());

                System.out.println("Will connect to: " +
                                   remoteAddr[0] + "." +
                                   remoteAddr[1] + "." +
                                   remoteAddr[2] + "." +
                                   remoteAddr[3] + ":" + remotePort);
            }
            
	    //
	    // Narrow to hello
	    //
	    Hello hello = HelloHelper.narrow(obj);
	    if(hello == null)
		throw new RuntimeException();
	    
	    //
	    // Main loop
	    //
	    System.out.println("Enter 'h' for hello or 'x' for exit:");

	    int c;

	    try
	    {
		String input;
		do
		{
		    System.out.print("> ");
		    java.io.DataInputStream dataIn =
			new java.io.DataInputStream(System.in);
		    BufferedReader in =
			new BufferedReader(new InputStreamReader(dataIn));
		    input = in.readLine();

		    if(input.equals("h"))
		    {
			try
			{
			    hello.hello();
			}
			catch(org.omg.CORBA.NO_PERMISSION ex)
			{
			    System.out.println("Connection was refused");
			}
		    }
		}
		while(!input.equals("x"));
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't read from `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }
	}
	catch(COMM_FAILURE ex)
	{
	    System.err.println(ex.getMessage());
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }

    //
    // Members only needed for applet
    //
    private Hello hello_;
    private Button button_;

    //
    // Applet initialization
    //
    public void init()
    {
	String ior = getParameter("ior");

	//
	// Create ORB
	//
	ORB orb = ORB.init(this, null);

	//
	// Create client object
	//
	org.omg.CORBA.Object obj = orb.string_to_object(ior);
	if(obj == null)
	    throw new RuntimeException();

	hello_ = HelloHelper.narrow(obj);

	//
	// Add hello button
	//
	button_ = new Button("Hello");
	button_.addActionListener(this);
	this.add(button_);
    }

    //
    // Handle events
    //
    public void
    actionPerformed(ActionEvent event)
    {
	hello_.hello();
    }
}
