// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package hello;

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

public class Server
{
    //
    // The close callback class
    //
    static class CloseCB_impl extends com.ooc.CORBA.LocalObject
	implements com.ooc.OCI.CloseCB
    {
	public void close_cb(com.ooc.OCI.TransportInfo transport_info)
	{
	    com.ooc.OCI.IIOP.TransportInfo iiopInfo =
		com.ooc.OCI.IIOP.TransportInfoHelper.narrow(transport_info);

	    if(iiopInfo != null)
	    {
		int[] remoteAddr = Converter.addr(iiopInfo.remote_addr());
		int remotePort = Converter.port(iiopInfo.remote_port());

		System.out.println("Close connection from: " +
				   remoteAddr[0] + "." +
				   remoteAddr[1] + "." +
				   remoteAddr[2] + "." +
				   remoteAddr[3] + ":" + remotePort);
	    }
	}
    };

    //
    // The accept callback class
    //
    static class AcceptCB_impl extends com.ooc.CORBA.LocalObject
	implements com.ooc.OCI.AcceptCB
    {
	public void accept_cb(com.ooc.OCI.TransportInfo transport_info)
	{
	    com.ooc.OCI.IIOP.TransportInfo iiopInfo =
		com.ooc.OCI.IIOP.TransportInfoHelper.narrow(transport_info);
	    
	    if(iiopInfo != null)
	    {
		int[] remoteAddr = Converter.addr(iiopInfo.remote_addr());
		int remotePort = Converter.port(iiopInfo.remote_port());
		
		System.out.println("Connection from: " +
				   remoteAddr[0] + "." +
				   remoteAddr[1] + "." +
				   remoteAddr[2] + "." +
				   remoteAddr[3] + ":" + remotePort);
		
		String input = null;
		do
		{
		    System.out.print("Refuse connection (y/n)? ");
		    java.io.DataInputStream dataIn =
			new java.io.DataInputStream(System.in);
		    BufferedReader in =
			new BufferedReader(new InputStreamReader(dataIn));
		    try
		    {
			input = in.readLine();
		    }
		    catch(IOException ex)
		    {
		    }
		}
		while(!input.equals("y") && !input.equals("n"));

		if(input.equals("y"))
		    throw new org.omg.CORBA.NO_PERMISSION();

		//
		// Add the close callback object
		//
		com.ooc.OCI.CloseCB closeCB = new CloseCB_impl();
		iiopInfo.add_close_cb(closeCB);
	    }
	}
    };

    public static void main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
            //
            // Create ORB and BOA
            //
            ORB orb = ORB.init(args, props);
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	    //
            // Get the OCI Current object
            //
            com.ooc.OCI.Current current = null;
            try
            {
                current = com.ooc.OCI.CurrentHelper.narrow(
                              orb.resolve_initial_references("OCICurrent"));
            }
            catch(org.omg.CORBA.ORBPackage.InvalidName e)
            {
                System.out.println("No OCI Currrent object");
                System.exit(1);
            }

            //
	    // Create implementation object
	    //
	    Hello_impl p = new Hello_impl(current);

	    //
	    // Save reference
	    //
	    try
	    {
		String ref = orb.object_to_string(p);
 		String refFile = "Hello.ref";
		FileOutputStream file = new FileOutputStream(refFile);
		PrintWriter out = new PrintWriter(file);
		out.println(ref);
		out.flush();
		file.close();
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't write to `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }

	    //
	    // Save reference as html
	    //
	    try
	    {
		String ref = orb.object_to_string(p);
 		String refFile = "Hello.html";
		FileOutputStream file = new FileOutputStream(refFile);
		PrintWriter out = new PrintWriter(file);
		out.println("<applet codebase=\"classes\" " +
			    "code=\"hello/Client.class\" " +
			    "width=500 height=300>");
		out.println("<param name=ior value=\"" + ref + "\">");
		out.println("<param name=org.omg.CORBA.ORBClass " +
			    "value=com.ooc.CORBA.ORB>");
		out.println("<param name=org.omg.CORBA.ORBSingletonClass " +
			    "value=com.ooc.CORBA.ORBSingleton>");
		out.println("</applet>");
		out.flush();
		file.close();
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't write to `" +
				   ex.getMessage() + "'");
		System.exit(1);
	    }

            //
	    // Print host and port
	    //
	    com.ooc.OCI.AccRegistry registry =
		((com.ooc.CORBA.BOA)boa).get_acc_registry();
	    com.ooc.OCI.Acceptor[] acceptors = registry.get_acceptors();

	    for(int i = 0 ; i < acceptors.length ; i++)
	    {
		com.ooc.OCI.AcceptorInfo info = acceptors[i].get_info();
		com.ooc.OCI.IIOP.AcceptorInfo iiopInfo =
		    com.ooc.OCI.IIOP.AcceptorInfoHelper.narrow(info);

		if(iiopInfo != null)
		{
		    String host = iiopInfo.host();
		    int port = Converter.port(iiopInfo.port());

		    System.out.println("*** Running on host `" + host +
				       "', port number " + port);

		    //
		    // Add the accept callback object
		    //
                    com.ooc.OCI.AcceptCB acceptorCB = new AcceptCB_impl();
                    iiopInfo.add_accept_cb(acceptorCB);
		}
	    }

	    //
	    // Run implementation
	    //
	    boa.impl_is_ready(null);
	}
	catch(SystemException ex)
	{
	    System.err.println(ex.getMessage());
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }
}
