// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
package repository;

import repository.Module.*;
import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

public class Client
{
    public static void main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
	    //
	    // Create ORB
	    //
            ORB orb = ORB.init(args, props);

	    //
	    // Get "interface" object
	    //
	    String ref = null;
            try
            {
                ref = "Interface.ref";
                FileInputStream file = new FileInputStream(ref);
		BufferedReader in =
		    new BufferedReader(new InputStreamReader(file));
                ref = in.readLine();
                file.close();
            }
            catch(IOException ex)
            {
                System.err.println("Can't open `" + ref +
				   "': " + ex.getMessage());
                System.exit(1);
            }

	    org.omg.CORBA.Object obj = orb.string_to_object(ref);
	    if(obj == null)
		throw new RuntimeException();

	    Interface interf = InterfaceHelper.narrow(obj);
	    if(interf == null)
		throw new RuntimeException();

	    //
	    // Print interface repository contents
	    // Changed temporarily to be compatible with Sun ORB
	    //
//	    InterfaceDef idef = interf._get_interface();
	    InterfaceDef idef = (InterfaceDef)(interf._get_interface_def());
	    if(idef == null)
	    {
		System.err.println("No Interface Repository " +
				   "available");
		System.exit(1);
	    }
	    else
	    {
		org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription
		    desc = idef.describe_interface();

		int i;

		System.out.println("name = " + desc.name);
		System.out.println("id = " + desc.id);
		System.out.println("defined_in = " + desc.defined_in);
		System.out.println("version = " + desc.version);
		System.out.println("operations:");
		for(i = 0 ; i < desc.operations.length ; i++)
		{
		    System.out.println(i + ": " + desc.operations[i].name);
		}
		System.out.println("attributes:");
		for(i = 0 ; i < desc.attributes.length ; i++)
		{
		    System.out.println(i + ": " + desc.attributes[i].name);
		}
		System.out.println("base_interfaces:");
		for(i = 0 ; i < desc.base_interfaces.length ; i++)
		{
		    System.out.println(i + ": " + desc.base_interfaces[i]);
		}
	    }
	}
	catch(SystemException ex)
	{
            System.err.println(ex.getMessage());
            ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }
}
