// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
package repository;

import repository.Module.*;
import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

public class Server
{
    public static void main(String args[])
    {
	Properties props = System.getProperties();
	props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
	props.put("org.omg.CORBA.ORBSingletonClass",
		  "com.ooc.CORBA.ORBSingleton");
	System.setProperties(props);

	try
	{
	    //
	    // Create ORB and BOA
	    //
            ORB orb = ORB.init(args, props);
	    BOA boa = ((com.ooc.CORBA.ORB)orb).BOA_init(args, props);

	    //
	    // Create implementation object
	    //
	    repository.Module.Interface_impl p =
		new repository.Module.Interface_impl();

	    //
	    // Save reference
	    //
	    String ref = null;
	    try
	    {
		ref = orb.object_to_string(p);
 		String refFile = "Interface.ref";
		FileOutputStream file = new FileOutputStream(refFile);
                PrintWriter out = new PrintWriter(file);
		out.println(ref);
		out.flush();
		file.close();
	    }
	    catch(IOException ex)
	    {
		System.err.println("Can't open `" + ref +
				   "`: " + ex.getMessage());
		System.exit(1);
	    }

	    //
	    // Run implementation
	    //
	    boa.impl_is_ready(null);
	}
	catch(SystemException ex)
	{
	    System.err.println(ex.getMessage());
	    ex.printStackTrace();
	    System.exit(1);
	}

	System.exit(0);
    }
}
