# **********************************************************************
#
# Copyright (c) 1999
# Object Oriented Concepts, Inc.
# Billerica, MA, USA
#
# All Rights Reserved
#
# **********************************************************************

top_srcdir	= ..

NAME		= OB.jar

!include $(top_srcdir)\..\config\Make.rules.mak

IDLDIR		= $(top_srcdir)\idl

all:: omg ooc

omg: omg-base omg-packages omg-iiop

omg-base: $(top_srcdir)\lib generated
	$(JIDL) -I$(IDLDIR) -DOB_WITH_TYPE_EXTENSIONS \
	--auto-package --no-skeletons --output-dir generated \
	$(IDLDIR)\IntRepMember.idl \
	$(IDLDIR)\IntRep.idl \
	$(IDLDIR)\ImplRep.idl \
	$(IDLDIR)\TCKind.idl \
	$(IDLDIR)\Dynamic.idl
	$(JIDL) -I$(IDLDIR) -DOB_WITH_TYPE_EXTENSIONS \
	--auto-package --locality-constrained --output-dir generated \
	$(IDLDIR)\DynAny.idl \
	$(IDLDIR)\Current.idl \
	$(IDLDIR)\Policy.idl \
	$(IDLDIR)\PolicyManager.idl
	set CLASSPATH=.;generated;$(top_srcdir)\lib;$(CLASSPATH)
	$(JAVAC) $(JAVACFLAGS) -d $(top_srcdir)\lib \
	generated\org\omg\CORBA\*.java \
	org\omg\CORBA\*.java \
	org\omg\CORBA\portable\*.java

omg-packages: $(top_srcdir)\lib generated
	set CLASSPATH=.;generated;$(top_srcdir)\lib;$(CLASSPATH)
	$(JAVAC) $(JAVACFLAGS) -d $(top_srcdir)\lib \
	generated\org\omg\CORBA\ContainedPackage\*.java \
	generated\org\omg\CORBA\ContainerPackage\*.java \
	generated\org\omg\CORBA\InterfaceDefPackage\*.java \
	generated\org\omg\CORBA\DynAnyPackage\*.java \
	generated\org\omg\CORBA\PolicyManagerPackage\*.java \
	org\omg\CORBA\ORBPackage\*.java \
	org\omg\CORBA\TypeCodePackage\*.java

omg-iiop: $(top_srcdir)\lib generated
	$(JIDL) -I$(IDLDIR) -DOB_WITH_TYPE_EXTENSIONS \
	--auto-package --no-skeletons --output-dir generated \
	$(IDLDIR)\IOP.idl \
	$(IDLDIR)\GIOP.idl \
	$(IDLDIR)\IIOP.idl
	set CLASSPATH=.;generated;$(top_srcdir)\lib;$(CLASSPATH)
	$(JAVAC) $(JAVACFLAGS) -d $(top_srcdir)\lib \
	generated\org\omg\IOP\*.java \
	generated\org\omg\GIOP\*.java \
	generated\org\omg\IIOP\*.java

ooc: ob oci corba

ob: $(top_srcdir)\lib generated
	$(JIDL) -I$(IDLDIR) -DOB_WITH_TYPE_EXTENSIONS \
	--auto-package --locality-constrained --output-dir generated \
	$(IDLDIR)\OBPolicies.idl
	set CLASSPATH=.;generated;$(top_srcdir)\lib;$(CLASSPATH)
	$(JAVAC) $(JAVACFLAGS) -d $(top_srcdir)\lib \
	generated\com\ooc\OB\*.java \
	generated\com\ooc\SSL\*.java \
	com\ooc\OB\impl\*.java

oci: $(top_srcdir)\lib generated
	$(JIDL) -I$(IDLDIR) -DOB_WITH_TYPE_EXTENSIONS \
	--auto-package --locality-constrained --output-dir generated \
	$(IDLDIR)\OCI.idl \
	$(IDLDIR)\OCI_IIOP.idl
	set CLASSPATH=.;generated;$(top_srcdir)\lib;$(CLASSPATH)
	$(JAVAC) $(JAVACFLAGS) -d $(top_srcdir)\lib \
	generated\com\ooc\OCI\*.java \
	generated\com\ooc\OCI\IIOP\*.java \
	com\ooc\OCI\*.java \
	com\ooc\OCI\impl\*.java \
	com\ooc\OCI\IIOP\impl\*.java

corba: $(top_srcdir)\lib generated
	set CLASSPATH=.;generated;$(top_srcdir)\lib;$(CLASSPATH)
	$(JAVAC) $(JAVACFLAGS) -d $(top_srcdir)\lib \
	com\ooc\CORBA\*.java

jar:
	cd $(top_srcdir)\lib & \
	del /q $(NAME) & \
	$(JAR) $(JARFLAGS) $(NAME) org\omg com\ooc

install:: jar
	copy $(top_srcdir)\lib\$(NAME) $(libdir)

clean::
	-rmdir /s /q $(top_srcdir)\lib\org
	-rmdir /s /q $(top_srcdir)\lib\com
	-del /q $(top_srcdir)\lib\$(NAME)
