// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class Any extends org.omg.CORBA.Any
{
    private ORBSingleton orb_;
    private TypeCode type_;
    private java.lang.Object value_;

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public synchronized boolean
    equal(org.omg.CORBA.Any a)
    {
	Any any = (Any)a;

	if(any == null)
	    return false;

	if(this == a)
	    return true;

	if(!type_.equal(a.type()))
	    return false;

	if(value_ == any.value_)
	    return true;

	if(value_ == null || any.value_ == null)
	    return false;

	int kind = type_._OB_getOrigType().kind().value();
	switch(kind)
	{
	    case org.omg.CORBA.TCKind._tk_null:
	    case org.omg.CORBA.TCKind._tk_void:
		return true;

	    case org.omg.CORBA.TCKind._tk_short:
	    case org.omg.CORBA.TCKind._tk_long:
	    case org.omg.CORBA.TCKind._tk_longlong:
	    case org.omg.CORBA.TCKind._tk_ushort:
	    case org.omg.CORBA.TCKind._tk_ulong:
	    case org.omg.CORBA.TCKind._tk_ulonglong:
	    case org.omg.CORBA.TCKind._tk_float:
	    case org.omg.CORBA.TCKind._tk_double:
	    case org.omg.CORBA.TCKind._tk_boolean:
	    case org.omg.CORBA.TCKind._tk_char:
	    case org.omg.CORBA.TCKind._tk_wchar:
	    case org.omg.CORBA.TCKind._tk_octet:
	    case org.omg.CORBA.TCKind._tk_enum:
	    case org.omg.CORBA.TCKind._tk_string:
	    case org.omg.CORBA.TCKind._tk_wstring:
		return value_.equals(any.value_);

	    case org.omg.CORBA.TCKind._tk_any:
		return extract_any().equal(any.extract_any());

	    case org.omg.CORBA.TCKind._tk_TypeCode:
		return extract_TypeCode().equal(any.extract_TypeCode());

	    case org.omg.CORBA.TCKind._tk_Principal:
		return extract_Principal().equals(any.extract_Principal());

	    case org.omg.CORBA.TCKind._tk_objref:
		return extract_Object()._is_equivalent(any.extract_Object());

	    case org.omg.CORBA.TCKind._tk_struct:
	    case org.omg.CORBA.TCKind._tk_except:
	    case org.omg.CORBA.TCKind._tk_union:
	    case org.omg.CORBA.TCKind._tk_sequence:
	    case org.omg.CORBA.TCKind._tk_array:
	    {
		OutputStream os1 = (OutputStream)value_;
		OutputStream os2 = (OutputStream)any.value_;

		int cnt1 = os1._OB_count();
		int cnt2 = os2._OB_count();
		if(cnt1 != cnt2)
		    return false;

		byte[] buf1 = os1._OB_buffer();
		byte[] buf2 = os2._OB_buffer();
		for(int i = 0 ; i < cnt1 ; i++)
		    if(buf1[i] != buf2[i])
			return false;

		return true;
	    }

	    case org.omg.CORBA.TCKind._tk_alias:
	    default:
		throw new InternalError();
	}
    }

    public synchronized org.omg.CORBA.TypeCode
    type()
    {
	return type_;
    }

    public synchronized void
    type(org.omg.CORBA.TypeCode tc)
    {
	type_ = (TypeCode)tc;
	value_ = null;
    }

    public synchronized void
    read_value(org.omg.CORBA.portable.InputStream in,
	       org.omg.CORBA.TypeCode tc)
	throws org.omg.CORBA.MARSHAL
    {
	type(tc);

        TypeCode origTC = ((TypeCode)tc)._OB_getOrigType();
	int kind = origTC.kind().value();
	switch(kind)
	{
	    case org.omg.CORBA.TCKind._tk_null:
	    case org.omg.CORBA.TCKind._tk_void:
		value_ = null;
		break;

	    case org.omg.CORBA.TCKind._tk_short:
		value_ = new Integer(in.read_short());
		break;

	    case org.omg.CORBA.TCKind._tk_long:
		value_ = new Integer(in.read_long());
		break;

	    case org.omg.CORBA.TCKind._tk_longlong:
		value_ = new Long(in.read_longlong());
		break;

	    case org.omg.CORBA.TCKind._tk_ushort:
		value_ = new Integer(in.read_ushort());
		break;

	    case org.omg.CORBA.TCKind._tk_ulong:
		value_ = new Integer(in.read_ulong());
		break;

	    case org.omg.CORBA.TCKind._tk_ulonglong:
		value_ = new Long(in.read_ulonglong());
		break;

	    case org.omg.CORBA.TCKind._tk_float:
		value_ = new Float(in.read_float());
		break;

	    case org.omg.CORBA.TCKind._tk_double:
		value_ = new Double(in.read_double());
		break;

	    case org.omg.CORBA.TCKind._tk_boolean:
		value_ = new Boolean(in.read_boolean());
		break;

	    case org.omg.CORBA.TCKind._tk_char:
		value_ = new Character(in.read_char());
		break;

	    case org.omg.CORBA.TCKind._tk_wchar:
		value_ = new Character(in.read_wchar());
		break;

	    case org.omg.CORBA.TCKind._tk_octet:
		value_ = new Byte(in.read_octet());
		break;

	    case org.omg.CORBA.TCKind._tk_any:
		value_ = in.read_any();
		break;

	    case org.omg.CORBA.TCKind._tk_TypeCode:
		value_ = in.read_TypeCode();
		break;

	    case org.omg.CORBA.TCKind._tk_Principal:
		value_ = in.read_Principal();
		break;

	    case org.omg.CORBA.TCKind._tk_objref:
		value_ = in.read_Object();
		break;

	    case org.omg.CORBA.TCKind._tk_struct:
	    case org.omg.CORBA.TCKind._tk_except:
	    case org.omg.CORBA.TCKind._tk_union:
	    case org.omg.CORBA.TCKind._tk_sequence:
	    case org.omg.CORBA.TCKind._tk_array:
	    {
		OutputStream out = new OutputStream();
		out.write_InputStream(in, origTC);
		value_ = out;
		break;
	    }

	    case org.omg.CORBA.TCKind._tk_enum:
		value_ = new Integer(in.read_ulong());
		break;

	    case org.omg.CORBA.TCKind._tk_string:
	    case org.omg.CORBA.TCKind._tk_wstring:
	    {
		try
		{
		    if(kind == org.omg.CORBA.TCKind._tk_string)
			value_ = in.read_string();
		    else
			value_ = in.read_wstring();
		    int len = origTC.length();
		    if(len != 0 && ((String)value_).length() > len)
			throw new org.omg.CORBA.MARSHAL();
		}
		catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
		{
		    throw new InternalError();
		}
		break;
	    }

	    case org.omg.CORBA.TCKind._tk_alias:
	    default:
		throw new InternalError();
	}
    }

    public synchronized void
    write_value(org.omg.CORBA.portable.OutputStream out)
    {
	int kind = type_._OB_getOrigType().kind().value();
	switch(kind)
	{
	    case org.omg.CORBA.TCKind._tk_null:
	    case org.omg.CORBA.TCKind._tk_void:
		break;

	    case org.omg.CORBA.TCKind._tk_short:
		out.write_short((short)((Integer)value_).intValue());
		break;

	    case org.omg.CORBA.TCKind._tk_long:
		out.write_long(((Integer)value_).intValue());
		break;

	    case org.omg.CORBA.TCKind._tk_longlong:
		out.write_longlong(((Long)value_).longValue());
		break;

	    case org.omg.CORBA.TCKind._tk_ushort:
		out.write_ushort((short)((Integer)value_).intValue());
		break;

	    case org.omg.CORBA.TCKind._tk_ulong:
		out.write_ulong(((Integer)value_).intValue());
		break;

	    case org.omg.CORBA.TCKind._tk_ulonglong:
		out.write_ulonglong(((Long)value_).longValue());
		break;

	    case org.omg.CORBA.TCKind._tk_float:
		out.write_float(((Float)value_).floatValue());
		break;

	    case org.omg.CORBA.TCKind._tk_double:
		out.write_double(((Double)value_).doubleValue());
		break;

	    case org.omg.CORBA.TCKind._tk_boolean:
		out.write_boolean(((Boolean)value_).booleanValue());
		break;

	    case org.omg.CORBA.TCKind._tk_char:
		out.write_char(((Character)value_).charValue());
		break;

	    case org.omg.CORBA.TCKind._tk_wchar:
		out.write_wchar(((Character)value_).charValue());
		break;

	    case org.omg.CORBA.TCKind._tk_octet:
		out.write_octet(((Byte)value_).byteValue());
		break;

	    case org.omg.CORBA.TCKind._tk_any:
		out.write_any((org.omg.CORBA.Any)value_);
		break;

	    case org.omg.CORBA.TCKind._tk_TypeCode:
		out.write_TypeCode((org.omg.CORBA.TypeCode)value_);
		break;

	    case org.omg.CORBA.TCKind._tk_Principal:
		out.write_Principal((org.omg.CORBA.Principal)value_);
		break;

	    case org.omg.CORBA.TCKind._tk_objref:
		out.write_Object((org.omg.CORBA.Object)value_);
		break;

	    case org.omg.CORBA.TCKind._tk_struct:
	    case org.omg.CORBA.TCKind._tk_except:
	    case org.omg.CORBA.TCKind._tk_union:
	    case org.omg.CORBA.TCKind._tk_sequence:
	    case org.omg.CORBA.TCKind._tk_array:
	    {
		OutputStream os = (OutputStream)value_;
		org.omg.CORBA.portable.InputStream in =
		    os.create_input_stream();
		((com.ooc.CORBA.OutputStream)out).write_InputStream(in, type_);
		break;
	    }

	    case org.omg.CORBA.TCKind._tk_enum:
		out.write_ulong(((Integer)value_).intValue());
		break;

	    case org.omg.CORBA.TCKind._tk_string:
		out.write_string((String)value_);
		break;

	    case org.omg.CORBA.TCKind._tk_wstring:
		out.write_wstring((String)value_);
		break;

	    case org.omg.CORBA.TCKind._tk_alias:
	    default:
		throw new InternalError();
	}
    }

    public synchronized void
    insert_short(short val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_short));
	value_ = new Integer(val);
    }

    public synchronized void
    insert_long(int val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_long));
	value_ = new Integer(val);
    }

    public synchronized void
    insert_longlong(long val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_longlong));
	value_ = new Long(val);
    }

    public synchronized void
    insert_ushort(short val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_ushort));
	value_ = new Integer(val);
    }

    public synchronized void
    insert_ulong(int val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_ulong));
	value_ = new Integer(val);
    }

    public synchronized void
    insert_ulonglong(long val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_ulonglong));
	value_ = new Long(val);
    }

    public synchronized void
    insert_boolean(boolean val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_boolean));
	value_ = new Boolean(val);
    }

    public synchronized void
    insert_char(char val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_char));
	value_ = new Character(val);
    }

    public synchronized void
    insert_wchar(char val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_wchar));
	value_ = new Character(val);
    }

    public synchronized void
    insert_octet(byte val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_octet));
	value_ = new Byte(val);
    }

    public synchronized void
    insert_float(float val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_float));
	value_ = new Float(val);
    }

    public synchronized void
    insert_double(double val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_double));
	value_ = new Double(val);
    }

    public synchronized void
    insert_any(org.omg.CORBA.Any val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_any));
	value_ = val;
    }

    public synchronized void
    insert_TypeCode(org.omg.CORBA.TypeCode val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_TypeCode));
	value_ = val;
    }

    public synchronized void
    insert_Principal(org.omg.CORBA.Principal val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_Principal));
	value_ = val;
    }

    public synchronized void
    insert_Object(org.omg.CORBA.Object val)
    {
	insert_Object(val,
		      orb_.create_interface_tc("IDL:omg.org/CORBA/Object:1.0",
					       "Object"));
    }

    public synchronized void
    insert_Object(org.omg.CORBA.Object val, org.omg.CORBA.TypeCode tc)
    {
	type(tc);
	value_ = val;
    }

    public synchronized void
    insert_string(String val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_string));
	value_ = val;
    }

    public synchronized void
    insert_wstring(String val)
    {
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_wstring));
	value_ = val;
    }

    public synchronized void
    insert_Streamable(org.omg.CORBA.portable.Streamable val)
    {
	type(val._type());
	org.omg.CORBA.portable.OutputStream out = create_output_stream();
	val._write(out);
	read_value(out.create_input_stream(), type_);
    }

    public synchronized short
    extract_short()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_short, false);
	return (short)((Integer)value_).intValue();
    }

    public synchronized int
    extract_long()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_long, false);
	return ((Integer)value_).intValue();
    }

    public synchronized long
    extract_longlong()
 	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_longlong, false);
	return ((Long)value_).longValue();
    }

    public synchronized short
    extract_ushort()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_ushort, false);
	return (short)((Integer)value_).intValue();
    }

    public synchronized int
    extract_ulong()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_ulong, false);
	return ((Integer)value_).intValue();
    }

    public synchronized long
    extract_ulonglong()
 	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_ulonglong, false);
	return ((Long)value_).longValue();
    }

    public synchronized boolean
    extract_boolean()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_boolean, false);
	return ((Boolean)value_).booleanValue();
    }

    public synchronized char
    extract_char()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_char, false);
	return ((Character)value_).charValue();
    }

    public synchronized char
    extract_wchar()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_wchar, false);
	return ((Character)value_).charValue();
    }

    public synchronized byte
    extract_octet()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_octet, false);
	return ((Byte)value_).byteValue();
    }

    public synchronized float
    extract_float()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_float, false);
	return ((Float)value_).floatValue();
    }

    public synchronized double
    extract_double()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_double, false);
	return ((Double)value_).doubleValue();
    }

    public synchronized org.omg.CORBA.Any
    extract_any()
 	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_any, false);
	return (org.omg.CORBA.Any)value_;
    }

    public synchronized org.omg.CORBA.TypeCode
    extract_TypeCode()
 	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_TypeCode, false);
	return (org.omg.CORBA.TypeCode)value_;
    }

    public synchronized org.omg.CORBA.Principal
    extract_Principal()
 	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_Principal, false);
	return (org.omg.CORBA.Principal)value_;
    }

    public synchronized org.omg.CORBA.Object
    extract_Object()
  	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_objref, true);
	return (org.omg.CORBA.Object)value_;
    }

    public synchronized String
    extract_string()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_string, false);
	return (String)value_;
    }

    public synchronized String
    extract_wstring()
	throws org.omg.CORBA.BAD_OPERATION
    {
	checkValue(org.omg.CORBA.TCKind.tk_wstring, false);
	return (String)value_;
    }

    public synchronized org.omg.CORBA.portable.OutputStream
    create_output_stream()
    {
	return new OutputStream();
    }

    public synchronized org.omg.CORBA.portable.InputStream
    create_input_stream()
    {
	if(value_ instanceof OutputStream)
	{
	    return ((OutputStream)value_).create_input_stream();
	}
	else
	{
	    OutputStream out = new OutputStream();
	    write_value(out);
	    return out.create_input_stream();
	}
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    Any()
    {
	orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();
	type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_null));
	value_ = null;
    }

    Any(Any any)
    {
	orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();
	type_ = any.type_;
	value_ = any.value_;
    }

    void
    checkValue(org.omg.CORBA.TCKind kind, boolean allowNull)
	throws org.omg.CORBA.BAD_OPERATION
    {
	TypeCode tc = type_._OB_getOrigType();
	if(tc.kind().value() != kind.value())
	    throw new org.omg.CORBA.BAD_OPERATION();
	if(! allowNull && value_ == null)
	    throw new org.omg.CORBA.BAD_OPERATION();
    }
}
