// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

// This class must be public
public final class BOA extends org.omg.CORBA.BOA
{
    //
    // The BOA option filter
    //
    private static OptionFilter optionFilter_;

    //
    // The ORB
    //
    private ORB orb_;

    //
    // The OCI acceptor registry
    //
    private com.ooc.OCI.AccRegistry registry_ =
	new com.ooc.OCI.impl.AccRegistry();

    //
    // All servers
    //
    private java.util.Vector servers_ = new java.util.Vector();

    //
    // All connected implementations. This maps key -> object
    //
    private java.util.Hashtable impls_ = new java.util.Hashtable();
    static class ImplKey
    {
	private byte[] key_; // The object key
	private int hash_; // The hash code

	public ImplKey(byte[] key)
	{
	    key_ = key;

	    hash_ = 0;

	    int len = key_.length;
	    int offset = 0;
	    if(len < 16)
            {
		for(int i = len; i > 0; i--)
		    hash_ = (hash_ * 37) + (int)key_[offset++];
	    }
	    else
	    {
		int skip = len / 8;
		for(int i = len; i > 0; i -= skip, offset += skip)
		    hash_ = (hash_ * 37) + (int)key_[offset];
	    }
	}

	public boolean equals(Object obj)
	{
	    try
	    {
		byte[] key = ((ImplKey)obj).key_;
		int hash = ((ImplKey)obj).hash_;

		if(hash_ != hash)
		    return false;

		if(key_.length != key.length)
		    return false;

		for(int i = 0 ; i < key_.length ; i++)
		{
		    if(key_[i] != key[i])
			return false;
		}

		return true;
	    }
	    catch(ClassCastException ex)
	    {
		return false;
	    }
	}

	public int hashCode()
	{
	    return hash_;
	}
    };

    //
    // All connected objects. This maps object -> keys
    //
    java.util.Hashtable keys_ = new java.util.Hashtable();
    
    //
    // Used for generating unnamed object keys
    //
    private int num_ = 0;

    //
    // The concurrency model
    //
    public static final class ConcModel // This class must be public
    {
	private static ConcModel[] values_ = new ConcModel[5];
	private int value_;
	
	public final static int _ConcModelBlocking = 0;
	public final static ConcModel ConcModelBlocking =
	new ConcModel(_ConcModelBlocking);
	public final static int _ConcModelThreaded = 1;
	public final static ConcModel ConcModelThreaded =
	new ConcModel(_ConcModelThreaded);
	public final static int _ConcModelThreadPerClient = 2;
	public final static ConcModel ConcModelThreadPerClient =
	new ConcModel(_ConcModelThreadPerClient);
	public final static int _ConcModelThreadPerRequest = 3;
	public final static ConcModel ConcModelThreadPerRequest =
	new ConcModel(_ConcModelThreadPerRequest);
	public final static int _ConcModelThreadPool = 4;
	public final static ConcModel ConcModelThreadPool =
	new ConcModel(_ConcModelThreadPool);
	
	private
	ConcModel(int value)
	{
	    values_[value] = this;
	    value_ = value;
	}
	
	public int
	value()
	{
	    return value_;
	}
    };
    private static ConcModel concModel_ = ConcModel.ConcModelThreaded;
    private static int concModelThreadPool_ = 10;

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public org.omg.CORBA.Object
    create(byte[] ref, org.omg.CORBA.InterfaceDef interf,
	   org.omg.CORBA.ImplementationDef impl)
    {
	throw new NotImplementedError();
    }

    public void
    dispose(org.omg.CORBA.Object obj)
    {
	throw new NotImplementedError();
    }

    public byte[]
    get_id(org.omg.CORBA.Object obj)
    {
	throw new NotImplementedError();
    }

    public void
    change_implementation(org.omg.CORBA.Object obj,
			  org.omg.CORBA.ImplementationDef impl)
    {
	throw new NotImplementedError();
    }

    public org.omg.CORBA.Principal
    get_principal(org.omg.CORBA.Object obj, org.omg.CORBA.Environment env)
    {
	throw new NotImplementedError();
    }

    public void
    impl_is_ready(org.omg.CORBA.ImplementationDef impl)
    {
	synchronized(servers_)
	{
	    //
	    // Initialize servers if not already done
	    //
	    if(init_servers())
		return; // All done
	    
	    //
	    // Wait for all servers to be released
	    //
	    while(servers_.size() > 0)
	    {
		try
		{
		    servers_.wait();
		}
		catch(InterruptedException ex)
		{
		}
	    }
	}
    }

    public void
    deactivate_impl(org.omg.CORBA.ImplementationDef impl)
    {
	synchronized(servers_)
	{
	    //
	    // Destroy servers
	    //
	    destroy_servers();
	    if(servers_.size() != 0)
		throw new InternalError();

	    //
	    // Notify the thread that waits for the servers to be
	    // released.
	    //
	    servers_.notify();
	}
    }

    public void
    obj_is_ready(org.omg.CORBA.Object obj,
		 org.omg.CORBA.ImplementationDef impl)
    {
	connect(obj);
    }

    public void
    deactivate_obj(org.omg.CORBA.Object obj)
    {
	disconnect(obj);
    }

    protected void
    set_parameters(String[] args, java.util.Properties props)
    {
	MessageViewer viewer = MessageViewer.instance();

	//
	// Get the set of properties - already initialized by ORB
	//
	Properties properties = Properties.instance();

	//
	// The order of precedence (lowest to highest) for properties is:
	//
	//   Configuration file
	//   User-supplied properties
	//   System properties
	//   Command-line arguments
	//
	if(props != null)
	    properties.merge(props);

	try
	{
	    properties.merge(System.getProperties());
	}
	catch(java.lang.SecurityException ex)
	{
	    // ignore - may be thrown by applet
	}

	//
	// Process each argument. Turn each argument into an appropriate
	// property.
	//
	java.util.Enumeration e = optionFilter_.parse(viewer, args);
	while(e.hasMoreElements())
	{
	    OptionFilter.Option option = (OptionFilter.Option)e.nextElement();
	    String name = option.name;
	    String[] value = option.value;

	    if(name.equals("id"))
	    {
		properties.setProperty("ooc.boa.id", value[0]);
	    }
	    else if(name.equals("disable_iiop_acceptor"))
	    {
		properties.setProperty("ooc.boa.disable_iiop_acceptor",
				       "true");
	    }
	    else if(name.equals("numeric"))
	    {
		properties.setProperty("ooc.boa.numeric", "true");
	    }
	    else if(name.equals("host"))
	    {
		properties.setProperty("ooc.boa.host", value[0]);
	    }
	    else if(name.equals("port"))
	    {
		properties.setProperty("ooc.boa.port", value[0]);
	    }
	    else if(name.equals("blocking"))
	    {
		properties.setProperty("ooc.boa.conc_model", "blocking");
	    }
	    else if(name.equals("threaded"))
	    {
		properties.setProperty("ooc.boa.conc_model", "threaded");
	    }
	    else if(name.equals("thread_per_client"))
	    {
		properties.setProperty("ooc.boa.conc_model",
				       "thread_per_client");
	    }
	    else if(name.equals("thread_per_request"))
	    {
		properties.setProperty("ooc.boa.conc_model",
				       "thread_per_request");
	    }
	    else if(name.equals("thread_pool"))
	    {
		properties.setProperty("ooc.boa.conc_model", "thread_pool");
		properties.setProperty("ooc.boa.thread_pool", value[0]);
	    }
	}

	//
	// Process each property
	//
	String id = null;
	ConcModel concModel = conc_model();
	int concModelThreadPool = conc_model_thread_pool();
	boolean iiopAcceptorDisabled = false;
	String host = null;
	int port = 0;
	boolean numeric = false;
	boolean addIIOPAcceptor = true;
	String[] keys = properties.getKeys("ooc.boa.");
	for(int i = 0 ; i < keys.length ; i++)
	{
	    String key = keys[i];
	    String value = properties.getProperty(key);
	    if(value == null)
		throw new InternalError();

	    if(key.equals("ooc.boa.id"))
	    {
		id = value;
	    }
	    else if(key.equals("ooc.boa.disable_iiop_acceptor"))
	    {
		if(value.equalsIgnoreCase("true"))
		    iiopAcceptorDisabled = true;
		else
		    iiopAcceptorDisabled = false;
	    }
	    else if(key.equals("ooc.boa.add_iiop_acceptor"))
	    {
		if(value.equalsIgnoreCase("true"))
		    addIIOPAcceptor = true;
		else
		    addIIOPAcceptor = false;
	    }
	    else if(key.equals("ooc.boa.port"))
	    {
		int po = -1;
		try
		{
		    po = Integer.parseInt(value);
		}
		catch(NumberFormatException ex)
		{
		    // ignore
		}
		if(po < 0 || po > 65535)
		{
		    viewer.error("ORB::BOA_init: port must be between " +
				 "0 and 65535");
		    throw new org.omg.CORBA.INITIALIZE();
		}
		port = po;
	    }
	    else if(key.equals("ooc.boa.host"))
	    {
		host = value;
	    }
	    else if(key.equals("ooc.boa.numeric"))
	    {
		if(value.equalsIgnoreCase("true"))
		    numeric = true;
		else
		    numeric = false;
	    }
	    else if(key.equals("ooc.boa.conc_model"))
	    {
		if(value.equals("blocking"))
		    concModel = ConcModel.ConcModelBlocking;
		else if(value.equals("threaded"))
		    concModel = ConcModel.ConcModelThreaded;
		else if(value.equals("thread_per_client"))
		    concModel = ConcModel.ConcModelThreadPerClient;
		else if(value.equals("thread_per_request"))
		    concModel = ConcModel.ConcModelThreadPerRequest;
		else if(value.equals("thread_pool"))
		    concModel = ConcModel.ConcModelThreadPool;
		else
		{
		    viewer.warning("ORB::BOA_init: unknown value for " +
				   "ooc.boa.conc_model: " + value);
		}
	    }
	    else if(key.equals("ooc.boa.thread_pool"))
	    {
		int numThreads = -1;
		try
		{
		    numThreads = Integer.parseInt(value);
		}
		catch(NumberFormatException ex)
		{
		    // ignore
		}
		if(numThreads <= 0)
		{
		    viewer.error("ORB::BOA_init: invalid value for " +
				 "ooc.boa.thread_pool");
		    throw new org.omg.CORBA.INITIALIZE();
		}
		concModelThreadPool = numThreads;
	    }
	    else
	    {
		viewer.warning("ORB::BOA_init: unknown property `" +
			       key + "'");
	    }
	}

	//
	// Verify the BOA id
	//
	if(id != null && !id.equals("OB_BOA"))
	{
	    viewer.error("ORB::BOA_init: unknown BOA `" + id + "'");
	    throw new org.omg.CORBA.INITIALIZE();
	}

	//
	// Get the hostname
	//
	if(host == null)
	{
	    try
	    {
		if(!numeric)
		{
		    host = java.net.InetAddress.getLocalHost().getHostName();
		    
		    if(host.lastIndexOf('.') == -1)
		    {
		      /*
			viewer.warning("ORB::BOA_init: " +
			"hostname is a domainless name\n" +
			"using dotted decimal notation " +
			"instead of hostname");
			*/

			host = java.net.InetAddress.getLocalHost()
			    .getHostAddress();
		    }
		}
		else
		{
		    host = java.net.InetAddress.getLocalHost()
			.getHostAddress();
		}

		if(host.equals("127.0.0.1") || host.equals("localhost"))
		{
		    viewer.warning("ORB::BOA_init: " +
				   "hostname lookup returned " +
				   "`localhost' (127.0.0.1)\n" +
				   "Use the -OAhost option to select " +
				   "some other hostname");
		}
	    }
	    catch(java.net.UnknownHostException ex)
	    {
		viewer.warning("ORB::BOA_init: " +
			       "can't resolve hostname\n" +
			       "using `localhost' (127.0.0.1) " +
			       "instead of hostname");
		
		if(numeric)
		    host = "127.0.0.1";
		else
		    host = "localhost";
	    }
	}

	//
	// Set the concurrency model
	//
	conc_model(concModel);
	conc_model_thread_pool(concModelThreadPool);

	//
	// Add an IIOP acceptor if necessary
	//
	if(addIIOPAcceptor)
	{
	    //
	    // Add an IIOP protocol plug-in for the server
	    //
	    if(registry_ == null)
		throw new InternalError();
	    if(host == null)
		throw new InternalError();
	    com.ooc.OCI.Acceptor acceptor =
		new com.ooc.OCI.IIOP.impl.Acceptor(host, port);
	    registry_.add_acceptor(acceptor);

	    //
	    // If the acceptor is disabled then inform the BOA to disable it
	    //
	    if(iiopAcceptorDisabled)
		disable_acceptor(acceptor.tag());
	}
    }

    protected void
    set_parameters(java.applet.Applet app, java.util.Properties props)
    {
	String[] args = new String[0];

	//
	// Check for parameter list
	//
	String paramList = app.getParameter("BOAparams");
	if(paramList != null)
	{
	    java.util.StringTokenizer p =
	    new java.util.StringTokenizer(paramList);

	    args = new String[p.countTokens()];

	    int i = 0;
	    while(p.hasMoreTokens())
		args[i++] = p.nextToken();
	}

	set_parameters(args, props);
    }

    // ------------------------------------------------------------------
    // Additonal ORBacus specific functions
    // ------------------------------------------------------------------

    public com.ooc.OCI.AccRegistry
    get_acc_registry()
    {
	return registry_;
    }

    public static ConcModel
    conc_model()
    {
	return concModel_;
    }

    public static void
    conc_model(ConcModel model)
    {
	concModel_ = model;
    }

    public static int
    conc_model_thread_pool()
    {
	return concModelThreadPool_;
    }

    public static void
    conc_model_thread_pool(int num)
    {
	concModelThreadPool_ = num;
    }

    void
    create_new_servers()
    {
	synchronized(servers_)
	{
	    if(registry_ == null)
		throw new InternalError();

	    //
	    // This creates servers for any new acceptors. It is
	    // known that acceptors are only appended to the acceptors
	    // list, so we can check the current length of the servers
	    // list, and the new length of the acceptors list, and
	    // create servers for any newly appended acceptors.
	    //
	    // Another way of coding this would be to look at the tags
	    // of the known acceptors, and known servers can create new
	    // server for an unknown acceptor tag.  Of course, this assumes
	    // that the set of tags is unique (must be true anyway).
	    //
	    com.ooc.OCI.Acceptor[] acceptors = registry_.get_acceptors();
	    if(servers_.size() < acceptors.length)
	    {
		int save = servers_.size();
		servers_.setSize(acceptors.length);
		for(int i = save; i < servers_.size(); ++i)
		{
		    servers_.setElementAt(new GIOPServer(this, acceptors[i]),
					  i);
		}
	    }
	}
    }

    public boolean
    init_servers()
    {
	synchronized(servers_)
	{
	    create_new_servers();

	    boolean allDone = true;
	    for(int i = 0 ; i < servers_.size() ; i++)
	    {
		boolean done = ((Server)servers_.elementAt(i)).run();
		allDone = allDone && done;
	    }

	    return allDone;
	}
    }

    public void
    destroy_servers()
    {
	synchronized(servers_)
	{
	    //
	    // Destroy and release all servers
	    //
	    for(int i = 0 ; i < servers_.size() ; i++)
		((Server)servers_.elementAt(i))._destroy();

	    servers_.removeAllElements();
	}
    }

    void
    connect(org.omg.CORBA.Object obj)
    {
	synchronized(impls_)
	{
	    org.omg.CORBA.DynamicImplementation impl;
	    try
	    {
		impl = (org.omg.CORBA.DynamicImplementation)obj;
	    }
	    catch(ClassCastException ex)
	    {
		return;
	    }

	    //
	    // Get the delegate
	    //
	    Delegate del;
	    try
	    {
		del = (Delegate)impl._get_delegate();

		//
		// Check if implementation is already connected
		//
		if(keys_.containsKey(impl))
		    return;
	    }
	    catch(org.omg.CORBA.BAD_OPERATION ex)
	    {
		del = new Delegate(orb_);
		impl._set_delegate(del);
	    }

	    //
	    // Get current time
	    //
	    long tv = System.currentTimeMillis();
	    int tv_sec = (int)(tv / 1000);
	    int tv_usec = (int)((tv % 1000) * 1000);

	    //
	    // Makeup object key. Object key is 0 + tv_sec + tv_usec +
	    // running count. We need the tv_usec to account for a server
	    // restarting in the same second
	    //
	    OutputStream out = new OutputStream(16);
	    out.write_ulong(0);
	    out.write_ulong(tv_sec);
	    out.write_ulong(tv_usec);
	    out.write_ulong(num_++);
	    byte[] key = out.buf_;
	    
	    //
	    // Add key to the IOR
	    //
	    org.omg.IOP.IORHolder ior =
		new org.omg.IOP.IORHolder(del._OB_ior());
	    if(ior.value == null)
	    {
		ior.value = new org.omg.IOP.IOR();
		ior.value.profiles = new org.omg.IOP.TaggedProfile[0];
	    }
	    String[] ids = impl._ids();
	    if(ids.length > 0)
		ior.value.type_id = ids[0];
	    else
		ior.value.type_id = "IDL:omg.org/CORBA/Object:1.0";
	    registry_.add_profiles(key, ior);
	    del._OB_ior(ior.value);
	    
	    //
	    // Add to implementation sequence
	    //
            ImplKey implKey = new ImplKey(key);
	    Object old = impls_.put(implKey, impl);
	    if(old != null)
		throw new InternalError();

            //
            // Add to the object -> key(s) map
            //
            ImplKey[] seq = new ImplKey[1];
            seq[0] = implKey;
            keys_.put(impl, seq);
	}
    }

    void
    connect(org.omg.CORBA.Object obj, String name)
    {
	if(name.length() == 0)
	    throw new org.omg.CORBA.BAD_PARAM();

	synchronized(impls_)
	{
	    org.omg.CORBA.DynamicImplementation impl;
	    try
	    {
		impl = (org.omg.CORBA.DynamicImplementation)obj;
	    }
	    catch(ClassCastException ex)
	    {
		return;
	    }

	    //
	    // Get the delegate
	    //
	    Delegate del;
	    try
	    {
		del = (Delegate)impl._get_delegate();

		//
		// Check if implementation is already connected
		//
		if(keys_.containsKey(impl))
		    return;
	    }
	    catch(org.omg.CORBA.BAD_OPERATION ex)
	    {
		del = new Delegate(orb_);
		impl._set_delegate(del);
	    }
	    
	    //
	    // Makeup object key
	    //
	    // I don't use string marshal functions here because I
	    // don't want to have a string length encoded. That
	    // would cause byte order dependencies.
	    //
	    byte key[] = new byte[name.length() + 1];
	    for(int i = 0 ; i < name.length() ; i++)
	    {
		if(name.charAt(i) > 255)
		    throw new org.omg.CORBA.DATA_CONVERSION();
		key[i] = (byte)name.charAt(i);
	    }
	    key[name.length()] = (byte)0;
	    
	    //
	    // Check if key already exists
	    //
            ImplKey implKey = new ImplKey(key);
	    if((org.omg.CORBA.DynamicImplementation)impls_.
	       get(implKey) != null)
		throw new org.omg.CORBA.INV_IDENT();
	    
	    //
	    // Add key to the IOR
	    //
	    org.omg.IOP.IORHolder ior =
		new org.omg.IOP.IORHolder(del._OB_ior());
	    if(ior.value == null)
	    {
		ior.value = new org.omg.IOP.IOR();
		ior.value.profiles = new org.omg.IOP.TaggedProfile[0];
	    }
	    String[] ids = impl._ids();
	    if(ids.length > 0)
		ior.value.type_id = ids[0];
	    else
		ior.value.type_id = "IDL:omg.org/CORBA/Object:1.0";
	    registry_.add_profiles(key, ior);
	    del._OB_ior(ior.value);
	    
	    //
	    // Add to implementation sequence
	    //
	    Object old = impls_.put(implKey, impl);
	    if(old != null)
		throw new InternalError();

            //
            // Record the key
            //
            ImplKey[] seq = new ImplKey[3];
            seq[0] = implKey;
            
	    //
	    // Add a second key for compatibility with OB 2.0
	    // named objects
	    //
	    {
		//
		// The following code comes from OB2.0
		//
		String ob = "OB/NAME";
		byte key2[] = new byte[ob.length() + 1 + name.length() + 1];
		
		int idx = 0;
		
		for(int i = 0 ; i < ob.length() ; i++)
		{
		    if(ob.charAt(i) > 255)
			throw new org.omg.CORBA.DATA_CONVERSION();
		    key2[idx++] = (byte)ob.charAt(i);
		}
		key2[idx++] = (byte)0;
		
		for(int i = 0 ; i < name.length() ; i++)
		{
		    if(name.charAt(i) > 255)
			throw new org.omg.CORBA.DATA_CONVERSION();
		    key2[idx++] = (byte)name.charAt(i);
		}
		key2[idx++] = (byte)0;
		
		//
		// Add to implementation sequence
		//
                ImplKey implKey2 = new ImplKey(key2);
		Object old2 = impls_.put(implKey2, impl);
		if(old2 != null)
		    throw new InternalError();

		//
		// Record the key
		//
                seq[1] = implKey2;
	    }

	    //
	    // Add a third key for compatibility with the INS object
	    // URLs
	    //
	    {
		byte key3[] = new byte[name.length()];
		
		int idx = 0;
		
		for(int i = 0 ; i < name.length() ; i++)
		{
		    if(name.charAt(i) > 255)
			throw new org.omg.CORBA.DATA_CONVERSION();
		    key3[idx++] = (byte)name.charAt(i);
		}
		
		//
		// Add to implementation sequence
		//
                ImplKey implKey3 = new ImplKey(key3);
		Object old3 = impls_.put(implKey3, impl);
		if(old3 != null)
		    throw new InternalError();

		//
		// Record the key
		//
                seq[2] = implKey3;
	    }

	    //
	    // Add to the object -> key(s) map
	    //
	    keys_.put(impl, seq);
	}
    }

    void
    disconnect(org.omg.CORBA.Object obj)
    {
	synchronized(impls_)
	{
	    try
	    {
		org.omg.CORBA.DynamicImplementation impl =
		    (org.omg.CORBA.DynamicImplementation)obj;
		
                java.lang.Object o = keys_.get(obj);
                if(o != null)
                {
                    ImplKey[] seq = (ImplKey[])o;
                    keys_.remove(obj);
                    for(int i = 0; i < seq.length; i++)
                        impls_.remove(seq[i]);
                }
	    }
	    catch(ClassCastException ex)
	    {
		// If the object is not of type
		// org.omg.CORBA.DynamicImplementation
	    }
	    catch(org.omg.CORBA.BAD_OPERATION ex)
	    {
		// If the object was not connected yet
	    }
	}
    }

    public void
    disable_acceptor(long tag)
    {
	//
	// Initialize servers if not already done
	//
	synchronized(servers_)
	{
	    create_new_servers();
	    for(int i = 0; i < servers_.size(); ++i)
	    {
		Server server = (Server)servers_.elementAt(i);
		if(server.acceptor().tag() == tag)
		{
		    server.disable();
		}
	    }
	}
    }

    public org.omg.CORBA.Object[]
    get_connected_servants()
    {
	java.util.Vector servants = new java.util.Vector();
	synchronized(impls_)
	{
	    java.util.Enumeration keys = impls_.keys();
	    while(keys.hasMoreElements())
	    {
		Object key = keys.nextElement();

		org.omg.CORBA.Object obj =
		(org.omg.CORBA.Object)impls_.get(key);
		int j;
		for(j = 0; j < servants.size(); ++j)
		    if(servants.elementAt(j) == obj)
			break;
		if(j >= servants.size())
		    servants.addElement(obj);
	    }
	}
	org.omg.CORBA.Object[] rc = new org.omg.CORBA.Object[servants.size()];
	for(int i = 0; i < servants.size(); ++i)
	    rc[i] = (org.omg.CORBA.Object)servants.elementAt(i);
	return rc;
    }

    public String[]
    filter_options(String[] args)
    {
	return optionFilter_.filter(args);
    }

    static public void
    set_iiop_port_from_object(org.omg.CORBA.Object obj)
    {
	//
	// If the object is nil, do nothing.
	//
	if(obj == null)
	    return;

	//
	// Get the OCI connector info.
	//
	com.ooc.OCI.ConnectorInfo info =
	    ((com.ooc.CORBA.Delegate)
	     ((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate()).
		get_oci_connector_info();

	//
	// Narrow to the IIOP connector info.
	//
	com.ooc.OCI.IIOP.ConnectorInfo iiopInfo =
	    com.ooc.OCI.IIOP.ConnectorInfoHelper.narrow(info);

	//
	// If this is an IIOP connector info then rip out the remote port
	// number, and set the ooc.boa.port property to this port.
	//
	if(iiopInfo != null)
	{
	    short po = iiopInfo.remote_port();
	    int port = (po < 0) ? (0xffff + (int)po + 1) : (int)po;

	    String s = "" + port;

	    //
	    // Set the property
	    //
	    Properties.instance().setProperty("ooc.boa.port", s);
	}
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    BOA(ORB orb)
    {
	orb_ = orb;

	//
	// Create list with options supported by the BOA
	//
	if(optionFilter_ == null)
	{
	    optionFilter_ = new OptionFilter("BOA_init", "-OA");
	    optionFilter_.add("id", 1);
	    optionFilter_.add("disable_iiop_acceptor", 0);
	    optionFilter_.add("numeric", 0);
	    optionFilter_.add("host", 1);
	    optionFilter_.add("port", 1);
	    optionFilter_.add("blocking", 0);
	    optionFilter_.add("threaded", 0);
	    optionFilter_.add("thread_per_client", 0);
	    optionFilter_.add("thread_per_request", 0);
	    optionFilter_.add("thread_pool", 1);
	}
    }

    protected void
    finalize()
	throws Throwable
    {
	//
	// Destroy all servers
	//
	for(int i = 0 ; i < servers_.size() ; i++)
	    ((Server)servers_.elementAt(i))._destroy();

	//
	// TODO: This is a hack!
	//
	GIOPServerWorkerThreaded.ThreadPool.destroyInstance();

	super.finalize();
    }

    final ORB
    _OB_orb()
    {
	return orb_;
    }

    org.omg.CORBA.DynamicImplementation
    _OB_find(byte[] key)
    {
	synchronized(impls_)
	{
	    return (org.omg.CORBA.DynamicImplementation)impls_.
		get(new ImplKey(key));
	}
    }

    org.omg.CORBA.DynamicImplementation
    _OB_find(org.omg.IOP.IOR ior)
    {
	synchronized(impls_)
	{
	    byte[] key = registry_.is_local(ior);

	    if(key.length > 0)
		return (org.omg.CORBA.DynamicImplementation)impls_.
		    get(new ImplKey(key));
	    else
		return null;
	}
    }

    DispatchStatus
    _OB_dispatch(byte[] key, String op, InputStream in, OutputStream out)
    {
	org.omg.CORBA.DynamicImplementation impl = _OB_find(key);

	if(impl == null)
	{
	    //
	    // Accept _non_existent and _not_existent. (See the ORB
	    // Core revision task force mailing list for a discussion
	    // why.)
	    //
	    if(op.equals("_non_existent") || op.equals("_not_existent"))
	    {
		if(out != null)
		{
		    boolean r = true;
		    out.write_boolean(r);
		}
		
		return DispatchStatus.DispatchStatusOK;
	    }
	    else
	    {
		// Object does not exist
		return DispatchStatus.DispatchStatusNoObject;
	    }
	}

	ServerRequest req = new ServerRequest(op, in);

        final String[] names =
        {
            "_hash",
            "_implementation",
            "_interface",
            "_is_a",
            "_is_dynamic",
            "_is_equivalent",
            "_non_existent"
        };
        
        int index = -1;               
	if(op.startsWith("_"))
	{
	    int left = 0;   
	    int right = names.length;
	    int m;                

	    while(left < right)
	    {
		m = (left + right) / 2;
		int res = names[m].compareTo(op);
		if(res == 0) 
		{
		    index = m;    
		    break;
		}
		if(res > 0)
		    right = m;
		else
		    left = m + 1;
	    }
	}

        switch(index)
        {
        case 0: // _hash
        {
	    org.omg.CORBA.NVList params = orb_.create_list(0);
	    org.omg.CORBA.Any aa0 = orb_.create_any();
	    aa0.type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_long));
	    params.add_value("", aa0, org.omg.CORBA.ARG_IN.value);
	    req.params(params);

	    int a0 = aa0.extract_long();
            
	    int r = impl._hash(a0);
	    
	    org.omg.CORBA.Any ra = orb_.create_any();
	    ra.insert_long(r);
	    
	    req.result(ra);
            break;
        }

        case 1: // _implementation
        {
	    //
	    // I'm using com.ooc.CORBA.Delegate directly here, because
	    // the org.omg.CORBA.portable.ObjectImpl does not support
	    // _get_implementation and _get_interface.
	    //
	    Delegate del = (Delegate)impl._get_delegate();
	    org.omg.CORBA.ImplementationDef r = del.get_implementation(impl);
	    
	    org.omg.CORBA.Any ra = orb_.create_any();
	    org.omg.CORBA.ImplementationDefHelper.insert(ra, r);
	    
	    req.result(ra);
            break;
        }

        case 2: // _interface
        {
	    //
	    // I'm using com.ooc.CORBA.Delegate directly here, because
	    // the org.omg.CORBA.portable.ObjectImpl does not support
	    // _get_implementation and _get_interface.
	    //
	    Delegate del = (Delegate)impl._get_delegate();
	    org.omg.CORBA.InterfaceDef r = del.get_interface(impl);
	    
	    org.omg.CORBA.Any ra = orb_.create_any();
	    org.omg.CORBA.InterfaceDefHelper.insert(ra, r);
	    
	    req.result(ra);
            break;
        }

        case 3: // _is_a
	{
	    org.omg.CORBA.NVList params = orb_.create_list(0);
	    org.omg.CORBA.Any aa0 = orb_.create_any();
	    aa0.type(orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_string));
	    params.add_value("", aa0, org.omg.CORBA.ARG_IN.value);
	    req.params(params);
	    
	    String a0 = aa0.extract_string();
	    
	    boolean r = impl._is_a(a0);
	    
	    org.omg.CORBA.Any ra = orb_.create_any();
	    ra.insert_boolean(r);
	    
	    req.result(ra);
            break;
	}

        case 4: // _is_dynamic  OB specific
        {
            throw new NotImplementedError();
        }

        case 5: // _is_equivalent
        {
	    org.omg.CORBA.NVList params = orb_.create_list(0);
	    org.omg.CORBA.Any aa0 = orb_.create_any();
	    aa0.type(orb_.create_interface_tc("IDL:omg.org/CORBA/Object:1.0",
					      "Object"));
	    params.add_value("", aa0, org.omg.CORBA.ARG_IN.value);
	    req.params(params);

	    org.omg.CORBA.Object a0 = aa0.extract_Object();

	    boolean r = impl._is_equivalent(a0);
	    
	    org.omg.CORBA.Any ra = orb_.create_any();
	    ra.insert_boolean(r);
	    
	    req.result(ra);
            break;
        }

        case 6: // _non_existent
        {
	    boolean r = impl._non_existent();
	    
	    org.omg.CORBA.Any ra = orb_.create_any();
	    ra.insert_boolean(r);
	    
	    req.result(ra);
            break;
        }

        default:
	    impl.invoke(req);
	    break;
	}

	if(req._OB_except() != null)
	{
	    if(((TypeCode)req._OB_except().type())._OB_isSystemException())
	    {
		Util.unmarshalSystemExceptionThrow(
		    req._OB_except().create_input_stream());
	    }
	    
	    if(out != null)
		req._OB_except().write_value(out);
	    
	    return DispatchStatus.DispatchStatusExcept;
	}
	else
	{
	    if(out != null)
	    {
		if(req._OB_result() != null)
		{
		    req._OB_result().write_value(out);
		}
		
		if(req._OB_params() != null)
		{
		    try
		    {
			for(int i = 0 ; i < req._OB_params().count() ; i++)
			{
			    org.omg.CORBA.NamedValue nv =
			    req._OB_params().item(i);
			    if(nv.flags() != org.omg.CORBA.ARG_IN.value)
				nv.value().write_value(out);
			}
		    }
		    catch(org.omg.CORBA.Bounds ex)
		    {
			throw new InternalError();
		    }
		}
	    }

	    return DispatchStatus.DispatchStatusOK;
	}
    }
}
