// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

abstract class Client
{
    //
    // The ORB
    //
    private ORB orb_;

    //
    // If set to true, this client can be reused
    //
    private boolean reuseClient_ = true;

    //
    // The usage counter
    //
    private int usage_ = 0;
    
    //
    // Constructor
    //
    Client(ORB orb)
    {
	orb_ = orb;
    }

    //
    // Destructor
    //
    protected void
    finalize()
	throws Throwable
    {
	super.finalize();
    }

    //
    // Increment usage (not mutex protected)
    //
    final void incUsage()
    {
	if(usage_ < 0)
	    throw new InternalError();
	usage_++;
    }

    //
    // Decrement usage (not mutex protected)
    //
    // Returns true if after the decrement the usage counter is larger
    // than 0, and false otherwise.
    //
    final boolean decUsage()
    {
	if(usage_ <= 0)
	    throw new InternalError();
	usage_--;
	return usage_ > 0;
    }

    //
    // Get connection reuse properties
    //
    final boolean
    reuseClient()
    {
        return reuseClient_;
    }

    //
    // Set connection reuse properties
    //
    final void
    reuseClient(boolean reuse)
    {
        reuseClient_ = reuse;
    }

    //
    // Destroy the server
    //
    abstract void
    _destroy();

    //
    // Get the OCI connector
    //
    abstract com.ooc.OCI.Connector
    connector();

    //
    // Get the OCI transport
    //
    abstract com.ooc.OCI.Transport
    transport();


    //
    // Calculate offset
    //
    abstract int
    offset(Delegate p, String op);

    //
    // Send request and receive response
    // With explicit timeout (throws exception on timeout)
    // With optional retry on communication failure
    //
    abstract InputStream
    request(Delegate p, String op, OutputStream out,
	    org.omg.CORBA.BooleanHolder exc, org.omg.CORBA.BooleanHolder fwd,
	    int t, boolean retry);

    //
    // Send request oneway
    // With implicit zero timeout (does not throw exception on timeout)
    // With optional retry on communication failure
    //
    abstract void
    oneway(Delegate p, String op, OutputStream out, boolean retry);

    //
    // Send request deferred
    // With implicit zero timeout (does not throw exception on timeout)
    // With optional retry on communication failure
    //
    abstract void
    deferred(Delegate p, String op, OutputStream out,
	     org.omg.CORBA.IntHolder reqId, boolean retry);

    //
    // Get response
    // With explicit timeout (throws exception on timeout)
    //
    abstract InputStream
    response(int reqId,
	     org.omg.CORBA.BooleanHolder exc, org.omg.CORBA.BooleanHolder fwd,
	     int t);
    
    //
    // Poll response
    // With implicit zero timeout (returns zero on timeout)
    //
    abstract InputStream
    poll(int reqId,
	 org.omg.CORBA.BooleanHolder exc, org.omg.CORBA.BooleanHolder fwd);
}

