// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class Context extends org.omg.CORBA.Context
{
    private ORBSingleton orb_;
    private String name_;
    private Context parent_;
    private java.util.Vector values_;

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public String
    context_name()
    {
	return name_;
    }

    public org.omg.CORBA.Context
    parent()
    {
	return parent_;
    }

    public org.omg.CORBA.Context
    create_child(String child_ctx_name)
    {
	if(child_ctx_name == null)
	    throw new org.omg.CORBA.BAD_PARAM();

	Context ctx = new Context(child_ctx_name);
	ctx.parent_ = this;

	return ctx;
    }

    public void
    set_one_value(String propname, org.omg.CORBA.Any propvalue)
    {
	if(propname == null)
	    throw new org.omg.CORBA.BAD_PARAM();

	String s;
	try
	{
	    s = propvalue.extract_string();
	}
	catch(org.omg.CORBA.BAD_OPERATION ex)
	{
	    throw new org.omg.CORBA.BAD_TYPECODE();
	}

	//
	// Search for propname
	//
	for(int i = 0 ; i < values_.size() ; i += 2)
	{
	    if(values_.elementAt(i).equals(propname))
	    {
		values_.setElementAt(s, i + 1);
		return;
	    }
	}

	//
	// Not found, add new propname
	//
	values_.addElement(propname);
	values_.addElement(s);
    }

    public void
    set_values(org.omg.CORBA.NVList values)
    {
	//
	// Create new, empty list
	//
	values_.removeAllElements();

	//
	// Copy named values
	//
	for(int i = 0 ; i < values.count() ; i++)
	{
	    org.omg.CORBA.NamedValue nv;
	    try
	    {
		nv = values.item(i);
	    }
	    catch(org.omg.CORBA.Bounds ex)
	    {
		throw new InternalError();
	    }
 
	    String s;
	    try
	    {
		s = nv.value().extract_string();
	    }
	    catch(org.omg.CORBA.SystemException ex)
	    {
		throw new org.omg.CORBA.BAD_TYPECODE();
	    }
 
	    if(nv.flags() != 0)
		throw new org.omg.CORBA.INV_FLAG();
 
	    values_.addElement(nv.name());
	    values_.addElement(s);
	}
    }

    public void
    delete_values(String pattern)
    {
	if(pattern == null)
	    throw new org.omg.CORBA.BAD_PARAM();

	//
	// Match the pattern
	//
	char last = 0;
        if(pattern.length() > 0)
            last = pattern.charAt(pattern.length() - 1);
 
	boolean found = false;

	for(int i = 0 ; i < values_.size() ; i += 2)
        {
            boolean match = false;

	    String s = (String)(values_.elementAt(i));

	    if(last == '*')
	    {
		//
		// Wildcard match?
		//
		if(s.startsWith(pattern.substring(0, pattern.length() - 1)))
                    match = true;
	    }
            else
            {
                //
                // Regular match?
                //
                if(s.equals(pattern))
                    match = true;
            }
 
            if(match)
	    {
                values_.removeElementAt(i);
		values_.removeElementAt(i);
		i -= 2;
		found = true;
	    }
	}

	if(!found)
	    throw new org.omg.CORBA.BAD_CONTEXT();
    }

    public org.omg.CORBA.NVList
    get_values(String start_scope, int op_flags, String pattern)
    {
	if(start_scope == null)
	    throw new org.omg.CORBA.BAD_PARAM();
	
	if(pattern == null)
	    throw new org.omg.CORBA.BAD_PARAM();

	java.util.Vector seq = new java.util.Vector();
	_OB_getValues(start_scope, op_flags, pattern, seq);

	if(seq.size() == 0)
	    throw new org.omg.CORBA.BAD_CONTEXT();

	NVList values = new NVList();

	for(int i = 0 ; i < seq.size() ; i += 2)
	{
	    org.omg.CORBA.Any any = orb_.create_any();
	    any.insert_string((String)seq.elementAt(i + 1));
	    values.add_value((String)seq.elementAt(i), any, 0);
	}

	return values;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    Context(String name)
    {
	orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();
	name_ = name;
	values_ = new java.util.Vector();
    }

    Context(String name, String[] strings)
    {
	orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();
	name_ = name;
	values_ = new java.util.Vector(strings.length);
	for(int i = 0 ; i < strings.length ; i++)
	    values_.addElement(strings[i]);
    }

    void 
    _OB_getValues(String start_scope, int op_flags,
		  String pattern, java.util.Vector seq)
    {
	//
	// Do nothing in this context if start_scope doesn't match name_
	//
	if(start_scope.length() != 0 && !start_scope.equals(name_))
	{
	    if(parent_ == null)
		throw new org.omg.CORBA.BAD_CONTEXT();

	    parent_._OB_getValues(start_scope, op_flags, pattern, seq);
	    return;
	}

	//
	// If there is a parent and scope is not restricted, get values
	// from parent. Otherwise create new value list
	//
	if(op_flags != org.omg.CORBA.CTX_RESTRICT_SCOPE.value &&
	   parent_ != null)
	    parent_._OB_getValues("", op_flags, pattern, seq);

	//
	// Match the pattern
	//
	char last = 0;
        if(pattern.length() > 0)
            last = pattern.charAt(pattern.length() - 1);

	for(int i = 0 ; i < values_.size() ; i += 2)
        {
            boolean match = false;

	    String s = (String)(values_.elementAt(i));

	    if(last == '*')
	    {
		//
		// Wildcard match?
		//
		if(s.startsWith(pattern.substring(0, pattern.length() - 1)))
                    match = true;
	    }
            else
            {
                //
                // Regular match?
                //
                if(s.equals(pattern))
                    match = true;
            }
 
            if(match)
	    {
		//
		// First try to put replace value
		//
		int j;
		for(j = 0; j < seq.size(); j += 2)
		    if(seq.elementAt(j).equals(s))
		    {
			seq.setElementAt(values_.elementAt(i + 1), j + 1);
			break;
		    }

		//
		// Value not found, create new one
		//
		if(j == seq.size())
		{
		    seq.addElement(values_.elementAt(i));
		    seq.addElement(values_.elementAt(i + 1));
		}
	    }
	}
    }
}
