// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

// This class must be public
public final class Delegate extends org.omg.CORBA.portable.Delegate
{
    //
    // The ORB
    //
    private ORB orb_;

    //
    // The IOR
    //
    private org.omg.IOP.IOR ior_;

    //
    // Key cache
    //
    private byte[] key_;
  
    //
    // The client
    //
    private Client clt_;

    //
    // The timeout (in msec)
    //
    private int tout_ = -1;

    //
    // Retry flag
    //
    private boolean retry_ = false;

    //
    // The policies
    //
    private java.util.Vector policies_ = new java.util.Vector();

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public org.omg.CORBA.ImplementationDef
    get_implementation(org.omg.CORBA.Object self)
    {
	if(is_local())
	{
	    return null;
	}
	else
	{
	    org.omg.CORBA.Request req = request(self, "_implementation");
	    
	    req.set_return_type(org.omg.CORBA.ImplementationDefHelper.type());
	    
	    req.invoke();
	    
	    java.lang.Exception ex = req.env().exception();
	    if(ex != null)
		throw (org.omg.CORBA.SystemException)ex;
	    
	    org.omg.CORBA.Any ra = req.return_value();
	    org.omg.CORBA.ImplementationDefHolder rh;
	    rh = new org.omg.CORBA.ImplementationDefHolder();
	    rh._read(ra.create_input_stream());
	    return rh.value;
	}
    }

    public org.omg.CORBA.InterfaceDef
    get_interface(org.omg.CORBA.Object self)
    {
	if(is_local())
	{
	    org.omg.CORBA.Object obj;
 
	    try
	    {
		obj = orb_.resolve_initial_references("InterfaceRepository");
	    }
	    catch(org.omg.CORBA.ORBPackage.InvalidName ex)
	    {
		throw new org.omg.CORBA.INTF_REPOS();
	    }
 
	    if(obj == null)
	    {
		throw new org.omg.CORBA.INTF_REPOS();
	    }
 
	    org.omg.CORBA.Repository repository =
            org.omg.CORBA.RepositoryHelper.narrow(obj);

	    if(repository == null)
	    {
		throw new org.omg.CORBA.INTF_REPOS();
	    }
 
	    org.omg.CORBA.Contained contained =
            repository.lookup_id(ior_.type_id);
	    if(contained == null)
		return null;

	    return org.omg.CORBA.InterfaceDefHelper.narrow(contained);
	}
	else
	{
	    org.omg.CORBA.Request req = request(self, "_interface");
	    
	    req.set_return_type(org.omg.CORBA.InterfaceDefHelper.type());
	    
	    req.invoke();
	    
	    java.lang.Exception ex = req.env().exception();
	    if(ex != null)
		throw (org.omg.CORBA.SystemException)ex;
	    
	    org.omg.CORBA.Any ra = req.return_value();
	    org.omg.CORBA.InterfaceDefHolder rh;
	    rh = new org.omg.CORBA.InterfaceDefHolder();
	    rh._read(ra.create_input_stream());
	    return rh.value;
	}
    }

    public org.omg.CORBA.Object
    duplicate(org.omg.CORBA.Object self)
    {
	return self;
    }

    public void
    release(org.omg.CORBA.Object self)
    {
    }

    public boolean
    is_a(org.omg.CORBA.Object self, String repository_id)
    {
	//
	// Check IDL:omg.org/CORBA/Object:1.0
	//
	if(repository_id.equals("IDL:omg.org/CORBA/Object:1.0"))
	    return true;
	    
	//
	// Check the type_id in the IOR
	//
	if(repository_id.equals(ior_.type_id))
	{
	    return true;
	}

	//
	// Check all ids of ObjectImpl
	//
	org.omg.CORBA.portable.ObjectImpl o =
        (org.omg.CORBA.portable.ObjectImpl)self;
	
	String[] ids = o._ids();
	for(int i = 0 ; i < ids.length ; i++)
	    if(repository_id.equals(ids[i]))
		return true;

	if(is_local())
	{
	    //
	    // If this is a local object, return false now
	    //
	    return false;
	}
	else
	{
	    //
	    // TODO: Some kind of is-a chache should be consulted
	    // here
	    //

	    //
	    // Check implementation object
	    //
	    org.omg.CORBA.Request req = request(self, "_is_a");
	    org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();
	    
	    org.omg.CORBA.Any aa0 = req.add_in_arg();
	    aa0.insert_string(repository_id);
	    
	    req.set_return_type(
                                orb.get_primitive_tc(org.omg.CORBA.TCKind.tk_boolean));
	    
	    req.invoke();
	    
	    java.lang.Exception ex = req.env().exception();
	    if(ex != null)
		throw (org.omg.CORBA.SystemException)ex;
	    
	    org.omg.CORBA.Any ra = req.return_value();
	    boolean r = ra.extract_boolean();
	
	    return r;
	}
    }

    public boolean
    non_existent(org.omg.CORBA.Object self)
    {
	if(is_local())
	{
	    return false;
	}
	else
	{
	    org.omg.CORBA.Request req = request(self, "_non_existent");
	    org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();
	    
	    req.set_return_type(
                                orb.get_primitive_tc(org.omg.CORBA.TCKind.tk_boolean));
	    
	    req.invoke();
	    
	    java.lang.Exception ex = req.env().exception();
	    if(ex != null)
		throw (org.omg.CORBA.SystemException)ex;
	    
	    org.omg.CORBA.Any ra = req.return_value();
	    return ra.extract_boolean();
	}
    }

    public boolean
    is_equivalent(org.omg.CORBA.Object self, org.omg.CORBA.Object rhs)
    {
	//
	// Direct object reference comparison
	//
	if(self == rhs)
	    return true;

	//
	// Direct delegate reference comparison
	//
	Delegate p = (Delegate)
        ((org.omg.CORBA.portable.ObjectImpl)rhs)._get_delegate();
	if(p == this)
	    return true;

	//
	// Local objects are never equivalent if the reference
	// comparisons fail
	//
	if(is_local() || p.is_local())
	    return false;

	//
	// Compare the IORs
	//
	return orb_._OB_equivalent(ior_, p.ior_);
    }

    public int
    hash(org.omg.CORBA.Object self, int max)
    {
	if(is_local())
	{
	    //
	    // Calculate a local hash value
	    //
	    return self.hashCode() % (max + 1);
	}
	else
	{
	    //
	    // Get hash via the ORB
	    //
	    return orb_._OB_hash(ior_, max);
	}
    }

    public org.omg.CORBA.Request
    request(org.omg.CORBA.Object self, String operation)
    {
	return new Request(self, operation);
    }

    public org.omg.CORBA.Request
    create_request(org.omg.CORBA.Object self, org.omg.CORBA.Context ctx,
		   String operation, org.omg.CORBA.NVList arg_list,
		   org.omg.CORBA.NamedValue result)
    {
	Request request = new Request(self, operation, arg_list, result);
	request.ctx(ctx);

	return request;
    }

    public org.omg.CORBA.Request
    create_request(org.omg.CORBA.Object self, org.omg.CORBA.Context ctx,
		   String operation, org.omg.CORBA.NVList arg_list,
		   org.omg.CORBA.NamedValue result,
		   org.omg.CORBA.ExceptionList excepts,
		   org.omg.CORBA.ContextList contexts)
    {
	Request request = new Request(self, operation, arg_list, result,
				      excepts, contexts);
	request.ctx(ctx);

	return request;
    }

    // ------------------------------------------------------------------
    // Additional ORBacus specific functions
    // ------------------------------------------------------------------

    public int
    timeout()
    {
	return tout_;
    }

    public void
    timeout(int timeout)
    {
        //
        // This needs to update the set of policies for this object
        //
        int policyType = com.ooc.OB.TIMEOUT_POLICY.value;
        org.omg.CORBA.Policy policy = null;

        //
        // If timeout < 0 then remove the timeout policy, if present
        //
        if(timeout >= 0)
        {
            //
            // Create a new timeout policy
            //
            org.omg.CORBA.Any any = orb_.create_any();
            any.insert_long(timeout);
            try
            {
                policy = orb_.create_policy(policyType, any);
            }
            catch(org.omg.CORBA.PolicyError e)
            {
                throw new InternalError();
            }
        }
        else
        {
            timeout = -1;
        }
        
        //
        // Find the policy
        //
        int policiesLen = policies_.size();
        int i;
        for(i = 0; i < policiesLen; ++i)
            if(((org.omg.CORBA.Policy)policies_.elementAt(i)).policy_type() ==
               policyType)
                break;

        //
        // If timeout >= 0 then we want to either add a new timeout
        // policy, or replace the existing one
        //
        if(timeout >= 0)
        {
            if(i >= policiesLen)
                policies_.addElement(policy);
            else
                policies_.setElementAt(policy, i);
        }
        //
        // Else we want to remove any existing timeout policy
        //
        else if(i < policiesLen)
            policies_.removeElementAt(i);

        //
        // Update the set of policies and associated state variables
        //
        _OB_policies(policies_);
        
        //
        // This should have updated the timeout
        //
        if(tout_ != timeout)
            throw new InternalError();
    }

    public boolean
    retry()
    {
	return retry_;
    }

    public void
    retry(boolean r)
    {
        //
        // This needs to update the set of policies for this object
        //

        //
        // Create a new reconnect policy
        //
        org.omg.CORBA.Any any = orb_.create_any();
        any.insert_boolean(r);
        int policyType = com.ooc.OB.RECONNECT_POLICY.value;
        org.omg.CORBA.Policy policy = null;
        
        try
        {
            policy = orb_.create_policy(policyType, any);
        }
        catch(org.omg.CORBA.PolicyError e)
        {
            throw new InternalError();
        }
        
        //
        // Find the policy
        //
        int policiesLen = policies_.size();
        int i;
        for(i = 0; i < policiesLen; ++i)
            if(((org.omg.CORBA.Policy)policies_.elementAt(i)).policy_type() ==
               policyType)
                break;

        //
        // Either add a new reconnect policy, or replace the existing one
        //
        if(i >= policiesLen)
            policies_.addElement(policy);
        else
            policies_.setElementAt(policy, i);

        //
        // Update the set of policies and associated state variables
        //
        _OB_policies(policies_);

        //
        // This should have updated the retry flag
        //
        if(retry_ != r)
            throw new InternalError();
    }

    public boolean
    is_local()
    {
        //
	// Remote objects have a client, local objects don't
	//
	return clt_ == null;
    }
    
    public com.ooc.OCI.TransportInfo
    get_oci_transport_info()
    {
        if(is_local())
            throw new org.omg.CORBA.BAD_OPERATION();

        com.ooc.OCI.Transport transport = clt_.transport();
	if(transport == null)
	    return null;

	return transport.get_info();
    }

    public com.ooc.OCI.ConnectorInfo
    get_oci_connector_info()
    {
        if(is_local())
            throw new org.omg.CORBA.BAD_OPERATION();

        com.ooc.OCI.Connector connector = clt_.connector();
	if(connector == null)
	    return null;

	return connector.get_info();
    }

    public org.omg.CORBA.ORB
    orb(org.omg.CORBA.Object self)
    {
	return orb_;
    }

    public org.omg.CORBA.Policy
    get_policy(int policy_type)
    {
        return get_effective_policy_override(policy_type);
    }

    public org.omg.CORBA.Policy
    get_effective_policy_override(int policy_type)
    {
        if(is_local())
            throw new org.omg.CORBA.BAD_OPERATION();

        org.omg.CORBA.Policy policy = _OB_getPolicy(policy_type);
        if(policy == null)
            throw new org.omg.CORBA.INV_POLICY();
        return policy;
    }

    //
    // For compatibility with JDK 1.2 ORB
    //
    public org.omg.CORBA.Object
    set_policy_override(org.omg.CORBA.Policy[] np,
			org.omg.CORBA.SetOverrideType set_add)
         throws org.omg.CORBA.PolicyManagerPackage.InvalidPolicies
    {
	return set_policy_overrides(np, set_add);
    }

    public org.omg.CORBA.Object
    set_policy_overrides(org.omg.CORBA.Policy[] np,
			org.omg.CORBA.SetOverrideType set_add)
         throws org.omg.CORBA.PolicyManagerPackage.InvalidPolicies
    {
        if(is_local())
            throw new org.omg.CORBA.BAD_OPERATION();

        java.util.Vector newPolicies;
        
	//
	// Create a new delegate and copy the IOR
	//
	Delegate p = new Delegate(orb_);
	p._OB_ior(_OB_ior());
	
	//
	// Create the new policy list
	//
	if(set_add == org.omg.CORBA.SetOverrideType.SET_OVERRIDE)
	{
            newPolicies = new java.util.Vector();
            int npLen = np.length;
	    for(int i = 0 ; i < npLen ; i++)
		newPolicies.addElement(np[i]);
	}
	else
	{
            newPolicies = (java.util.Vector)policies_.clone();

            int npLen = np.length;
	    for(int i = 0 ; i < npLen ; ++i)
	    {
		int len = newPolicies.size();
		int j;

		for(j = 0 ; j < len ; ++j)
		    if(((org.omg.CORBA.Policy)newPolicies.elementAt(j)).
		       policy_type() == np[i].policy_type())
			break;
		
		if(j < len)
		    newPolicies.setElementAt(np[i], j);
		else
		    newPolicies.addElement(np[i]);
	    }
	}
        PolicyValidator.validatePolicies(newPolicies);
	p._OB_policies(newPolicies);

	//
	// Change delegate since the policies have changed
	//
	orb_._OB_changeDelegate(p, ior_);

	//
	// Create new object, set the delegate and return
	//
	StubForObject obj = new StubForObject();
	obj._set_delegate(p);
        
	return obj;
    }

    public org.omg.CORBA.Policy[]
    get_policy_overrides(int[] types)
    {
        int len = policies_.size();
        int typesLen = types.length;
        
        java.util.Vector policies = new java.util.Vector();
        
        for(int i = 0; i < typesLen; ++i)
        {
            int currType = types[i];
            for(int j = 0; j < len; ++j)
            {
                org.omg.CORBA.Policy currPolicy =
                    (org.omg.CORBA.Policy)policies_.elementAt(j);
                if(currPolicy.policy_type() == currType)
                {
                    policies.addElement(currPolicy);
                }
            }
        }
        
        len = policies.size();
        org.omg.CORBA.Policy[] rc = new org.omg.CORBA.Policy[len];
        for(int i = 0; i < len; ++i)
        {
            rc[i] = (org.omg.CORBA.Policy)policies.elementAt(i);
        }
        
        return rc;
    }

    public boolean
    validate_policies(org.omg.CORBA.Policy[] inconsistent_policies)
    {
        //
        // For now all policy combinations are valid.
        //
        return true;
    }

    public org.omg.CORBA.DomainManager[]
    get_domain_managers()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    Delegate(ORB orb)
    {
	orb_ = orb;
    }

    protected void
    finalize()
	throws Throwable
    {
	if(clt_ != null)
	    orb_._OB_decClientUsage(clt_);

	super.finalize();
    }

    ORB
    _OB_orb()
    {
	return orb_;
    }

    org.omg.IOP.IOR
    _OB_ior()
    {
	return ior_;
    }

    void
    _OB_ior(org.omg.IOP.IOR ior)
    {
	key_ = null; // Invalidate key cache
	ior_ = ior;
    }

    byte[]
    _OB_key()
    {
	return key_;
    }

    void
    _OB_key(byte[] key)
    {
	key_ = key;
    }

    Client
    _OB_client()
    {
	return clt_;
    }

    void
    _OB_client(Client clt)
    {
	key_ = null; // Invalidate key cache

	if(clt != null)
	    orb_._OB_incClientUsage(clt);

	if(clt_ != null)
	    orb_._OB_decClientUsage(clt_);

	clt_ = clt;
    }

    java.util.Vector
    _OB_policies()
    {
        return policies_;
    }

    void
    _OB_policies(java.util.Vector np)
    {
        policies_ = np;

        com.ooc.OB.TimeoutPolicy toutPolicy;
        org.omg.CORBA.Policy policy =
            _OB_getPolicy(com.ooc.OB.TIMEOUT_POLICY.value);
        if(policy != null)
            toutPolicy = com.ooc.OB.TimeoutPolicyHelper.narrow(policy);
        else
            toutPolicy = null;
        
        com.ooc.OB.ReconnectPolicy reconnectPolicy;
        policy = _OB_getPolicy(com.ooc.OB.RECONNECT_POLICY.value);
        if(policy != null)
            reconnectPolicy = com.ooc.OB.ReconnectPolicyHelper.narrow(policy);
        else
            reconnectPolicy = null;
        
        tout_ = (toutPolicy == null)
                   ? -1
                   : toutPolicy.value();
        retry_ = (reconnectPolicy == null)
                   ? false
                   : reconnectPolicy.value();
    }

    public org.omg.CORBA.Policy
    _OB_getPolicy(int policy_type)
    {
        int policiesLen = policies_.size();
	for(int i = 0 ; i < policiesLen ; i++)
	    if(((org.omg.CORBA.Policy)policies_.elementAt(i)).policy_type()
	       == policy_type)
		return (org.omg.CORBA.Policy)policies_.elementAt(i);
        return null;
    }
}

