// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

abstract class DynAny extends LocalObject
    implements org.omg.CORBA.DynAny
{
    TypeCode type_;
    TypeCode origType_;
    ORBSingleton orb_;

    DynAny(org.omg.CORBA.TypeCode type)
    {
        type_ = (TypeCode)type;
        origType_ = type_._OB_getOrigType();
        orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();
    }

    //
    // DynAny operations
    //

    final public org.omg.CORBA.TypeCode
    type()
    {
        return type_;
    }

    public abstract void
    assign(org.omg.CORBA.DynAny dyn_any)
        throws org.omg.CORBA.DynAnyPackage.Invalid;

    public abstract void
    from_any(org.omg.CORBA.Any value)
        throws org.omg.CORBA.DynAnyPackage.Invalid;

    public abstract org.omg.CORBA.Any
    to_any()
        throws org.omg.CORBA.DynAnyPackage.Invalid;

    public abstract void
    destroy();

    public abstract org.omg.CORBA.DynAny
    copy();

    final public synchronized void
    insert_boolean(boolean value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.TypeCode tc =
            orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_boolean);
        check_type(tc);
        current_any().insert_boolean(value);
        next();
    }

    final public synchronized void
    insert_octet(byte value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.TypeCode tc =
            orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
        check_type(tc);
        current_any().insert_octet(value);
        next();
    }

    final public synchronized void
    insert_char(char value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.TypeCode tc =
            orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_char);
        check_type(tc);
        current_any().insert_char(value);
        next();
    }

    final public synchronized void
    insert_short(short value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.TypeCode tc =
            orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
        check_type(tc);
        current_any().insert_short(value);
        next();
    }

    final public synchronized void
    insert_ushort(short value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.TypeCode tc =
            orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_ushort);
        check_type(tc);
        current_any().insert_ushort(value);
        next();
    }

    final public synchronized void
    insert_long(int value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.TypeCode tc =
            orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_long);
        check_type(tc);
        current_any().insert_long(value);
        next();
    }

    final public synchronized void
    insert_ulong(int value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.TypeCode tc =
            orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_ulong);
        check_type(tc);
        current_any().insert_ulong(value);
        next();
    }

    final public synchronized void
    insert_float(float value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.TypeCode tc =
            orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_float);
        check_type(tc);
        current_any().insert_float(value);
        next();
    }

    final public synchronized void
    insert_double(double value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.TypeCode tc =
            orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_double);
        check_type(tc);
        current_any().insert_double(value);
        next();
    }

    final public synchronized void
    insert_string(String value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        check_string_type();
        current_any().insert_string(value);
        next();
    }

    final public synchronized void
    insert_reference(org.omg.CORBA.Object value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.Any any = current_any();
        TypeCode tc = (TypeCode)any.type();

        if(tc._OB_getOrigType().kind() != org.omg.CORBA.TCKind.tk_objref)
            throw new org.omg.CORBA.DynAnyPackage.InvalidValue();

        any.insert_Object(value, tc);
        next();
    }

    final public synchronized void
    insert_typecode(org.omg.CORBA.TypeCode value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.TypeCode tc =
            orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_TypeCode);
        check_type(tc);
        current_any().insert_TypeCode(value);
        next();
    }

    final public synchronized void
    insert_any(org.omg.CORBA.Any value)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.TypeCode tc =
            orb_.get_primitive_tc(org.omg.CORBA.TCKind.tk_any);
        check_type(tc);
        current_any().insert_any(value);
        next();
    }

    final public synchronized boolean
    get_boolean()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_boolean();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized byte
    get_octet()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_octet();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized char
    get_char()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_char();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized short
    get_short()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_short();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized short
    get_ushort()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_ushort();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized int
    get_long()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_long();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized int
    get_ulong()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_ulong();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized float
    get_float()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_float();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized double
    get_double()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_double();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized String
    get_string()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_string();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized org.omg.CORBA.Object
    get_reference()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_Object();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized org.omg.CORBA.TypeCode
    get_typecode()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_TypeCode();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    final public synchronized org.omg.CORBA.Any
    get_any()
        throws org.omg.CORBA.DynAnyPackage.TypeMismatch
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();

        try
        {
            return any.extract_any();
        }
        catch(org.omg.CORBA.BAD_OPERATION e)
        {
            throw new org.omg.CORBA.DynAnyPackage.TypeMismatch();
        }
    }

    public abstract org.omg.CORBA.DynAny
    current_component();

    public abstract boolean
    next();

    public abstract boolean
    seek(int index);

    public abstract void
    rewind();

    //
    // For subclasses
    //

    abstract org.omg.CORBA.Any
    current_any();

    abstract org.omg.CORBA.Any
    current_any_value();

    abstract void
    read_stream(org.omg.CORBA.portable.InputStream in)
        throws org.omg.CORBA.DynAnyPackage.Invalid;

    abstract void
    write_stream(org.omg.CORBA.portable.OutputStream out)
        throws org.omg.CORBA.DynAnyPackage.Invalid;

    void
    check_type(org.omg.CORBA.TypeCode tc)
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.Any any = current_any();

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.InvalidValue();

        org.omg.CORBA.TypeCode type = any.type();

        if(!tc.equal(type))
            throw new org.omg.CORBA.DynAnyPackage.InvalidValue();
    }

    void
    check_string_type()
        throws org.omg.CORBA.DynAnyPackage.InvalidValue
    {
        org.omg.CORBA.Any any = current_any();

        //
        // Don't be as strict when checking string typecodes
        //

        if(any == null)
            throw new org.omg.CORBA.DynAnyPackage.InvalidValue();

        org.omg.CORBA.TypeCode type = any.type();

        if(type.kind() != org.omg.CORBA.TCKind.tk_string)
            throw new org.omg.CORBA.DynAnyPackage.InvalidValue();
    }
}
