// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class DynBasic extends DynAny
{
    org.omg.CORBA.Any any_;

    DynBasic(org.omg.CORBA.TypeCode type)
    {
        super(type);
        any_ = orb_.create_any();
        any_.type(type);
    }

    //
    // DynAny operations
    //

    public synchronized void
    assign(org.omg.CORBA.DynAny dyn_any)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        if(!(dyn_any instanceof DynBasic))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        org.omg.CORBA.TypeCode tc = dyn_any.type();

        if(!tc.equal(type_))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        any_ = dyn_any.to_any();
    }

    public synchronized void
    from_any(org.omg.CORBA.Any value)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        org.omg.CORBA.TypeCode tc = value.type();

        if(!tc.equal(type_))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        any_.read_value(value.create_input_stream(), tc);
    }

    public synchronized org.omg.CORBA.Any
    to_any()
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        org.omg.CORBA.Any result = orb_.create_any();
        result.read_value(current_any().create_input_stream(), type_);
        return result;
    }

    public void
    destroy()
    {
    }

    public synchronized org.omg.CORBA.DynAny
    copy()
    {
        org.omg.CORBA.DynAny result = new DynBasic(type_);

        try
        {
            result.from_any(any_);
        }
        catch(org.omg.CORBA.DynAnyPackage.Invalid e)
        {
        }

        return result;
    }

    public org.omg.CORBA.DynAny
    current_component()
    {
        return this;
    }

    public boolean
    next()
    {
        return false;
    }

    public boolean
    seek(int index)
    {
        if(index == 0)
            return true;
        return false;
    }

    public void
    rewind()
    {
        // nothing to do
    }

    //
    // For subclasses
    //

    synchronized org.omg.CORBA.Any
    current_any()
    {
        return any_;
    }

    synchronized org.omg.CORBA.Any
    current_any_value()
    {
        return any_;
    }

    synchronized void
    read_stream(org.omg.CORBA.portable.InputStream in)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        any_.read_value(in, type_);
    }

    synchronized void
    write_stream(org.omg.CORBA.portable.OutputStream out)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        any_.write_value(out);
    }
}
