// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class DynEnum extends DynAny implements org.omg.CORBA.DynEnum
{
    int value_;

    DynEnum(org.omg.CORBA.TypeCode type)
    {
        this(type, 0);
    }

    DynEnum(org.omg.CORBA.TypeCode type, int value)
    {
        super(type);
        value_ = value;
    }

    //
    // DynAny operations
    //

    public synchronized void
    assign(org.omg.CORBA.DynAny dyn_any)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        if(!(dyn_any instanceof org.omg.CORBA.DynEnum))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        DynEnum dyn_enum = (DynEnum)dyn_any;

        org.omg.CORBA.TypeCode tc = dyn_enum.type();
        if(!tc.equal(type_))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        value_ = dyn_enum.value_;
    }

    public synchronized void
    from_any(org.omg.CORBA.Any value)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        org.omg.CORBA.TypeCode tc = value.type();

        if(!tc.equal(type_))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        org.omg.CORBA.portable.InputStream in = value.create_input_stream();
        read_stream(in);
    }

    public synchronized org.omg.CORBA.Any
    to_any()
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        org.omg.CORBA.Any result = orb_.create_any();
        org.omg.CORBA.portable.OutputStream out = result.create_output_stream();
        write_stream(out);
        result.read_value(out.create_input_stream(), type_);
        return result;
    }

    public void
    destroy()
    {
    }

    public synchronized org.omg.CORBA.DynAny
    copy()
    {
        return new DynEnum(type_, value_);
    }

    public org.omg.CORBA.DynAny
    current_component()
    {
        return this;
    }

    public boolean
    next()
    {
        return false;
    }

    public boolean
    seek(int index)
    {
        if(index == 0)
            return true;
        return false;
    }

    public void
    rewind()
    {
        // nothing to do
    }

    //
    // DynEnum IDL interface
    //

    public synchronized String
    value_as_string()
    {
        String result = null;

        try
        {
            result = origType_.member_name(value_);
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
        catch(org.omg.CORBA.TypeCodePackage.Bounds e)
        {
        }

        return result;
    }

    public synchronized void
    value_as_string(String value)
    {
        try
        {
            int count = origType_.member_count();
            int i;

            for(i = 0 ; i < count ; i++)
            {
                if(value.equals(origType_.member_name(i)))
                {
                    value_ = i;
                    break;
                }
            }

            if(i == count)
                ; // not found!
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
        catch(org.omg.CORBA.TypeCodePackage.Bounds e)
        {
        }
    }

    public synchronized int
    value_as_ulong()
    {
        return value_;
    }

    public synchronized void
    value_as_ulong(int value)
    {
        try
        {
            if(value < origType_.member_count())
                value_ = value;
            else
                ; // invalid value!
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
    }

    //
    // For subclasses
    //

    org.omg.CORBA.Any
    current_any()
    {
        return null;
    }

    org.omg.CORBA.Any
    current_any_value()
    {
        return null;
    }

    synchronized void
    read_stream(org.omg.CORBA.portable.InputStream in)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        value_ = in.read_ulong();
    }

    synchronized void
    write_stream(org.omg.CORBA.portable.OutputStream out)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        out.write_ulong(value_);
    }
}
