// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class DynException extends DynStruct
{
    String id_;

    DynException(org.omg.CORBA.TypeCode type, boolean init)
    {
        super(type, init);

        try
        {
            id_ = type_.id();
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
    }

    //
    // DynAny operations
    //

    public synchronized org.omg.CORBA.DynAny
    copy()
    {
        DynException result = new DynException(type_, false);

        for(int i = 0 ; i < components_.length ; i++)
            result.components_[i] = components_[i].copy();

        return result;
    }

    //
    // For subclasses
    //

    synchronized void
    read_stream(org.omg.CORBA.portable.InputStream in)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        id_ = in.read_string();
        super.read_stream(in);
    }

    synchronized void
    write_stream(org.omg.CORBA.portable.OutputStream out)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        out.write_string(id_);
        super.write_stream(out);
    }
}
