// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class DynSequence extends DynAny implements org.omg.CORBA.DynSequence
{
    org.omg.CORBA.DynAny[] components_;
    int index_ = 0;

    DynSequence(org.omg.CORBA.TypeCode type)
    {
        super(type);
        components_ = new org.omg.CORBA.DynAny[0];
    }

    //
    // DynAny operations
    //

    public synchronized void
    assign(org.omg.CORBA.DynAny dyn_any)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        if(!(dyn_any instanceof DynSequence))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        org.omg.CORBA.TypeCode tc = dyn_any.type();

        if(!tc.equal(type_))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        DynSequence dyn_seq = (DynSequence)dyn_any;

        components_ = new org.omg.CORBA.DynAny[dyn_seq.components_.length];

        for(int i = 0 ; i < dyn_seq.components_.length ; i++)
        {
            org.omg.CORBA.DynAny component = dyn_seq.components_[i];
            if(component == null)
                components_[i] = null;
            else
                components_[i] = component.copy();
        }
    }

    public synchronized void
    from_any(org.omg.CORBA.Any value)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        org.omg.CORBA.TypeCode tc = value.type();

        if(!tc.equal(type_))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        org.omg.CORBA.portable.InputStream in = value.create_input_stream();
        read_stream(in);
    }

    public synchronized org.omg.CORBA.Any
    to_any()
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        org.omg.CORBA.Any result = orb_.create_any();
        org.omg.CORBA.portable.OutputStream out = result.create_output_stream();
        write_stream(out);
        result.read_value(out.create_input_stream(), type_);
        return result;
    }

    public synchronized void
    destroy()
    {
        for(int i = 0 ; i < components_.length ; i++)
            components_[i].destroy();
    }

    public synchronized org.omg.CORBA.DynAny
    copy()
    {
        DynSequence result = new DynSequence(type_);

        result.components_ = new org.omg.CORBA.DynAny[components_.length];

        for(int i = 0 ; i < components_.length ; i++)
            result.components_[i] = components_[i].copy();

        return result;
    }

    public synchronized org.omg.CORBA.DynAny
    current_component()
    {
        return components_[index_];
    }

    public synchronized boolean
    next()
    {
        index_++;
        if(index_ < components_.length)
            return true;
        return false;
    }

    public synchronized boolean
    seek(int index)
    {
        if(index >= 0 && index < components_.length)
        {
            index_ = index;
            return true;
        }
        return false;
    }

    public synchronized void
    rewind()
    {
        index_ = 0;
    }

    //
    // DynSequence IDL interface
    //

    public synchronized int
    length()
    {
        return components_.length;
    }

    public synchronized void
    length(int value)
    {
        initComponents(value);
    }

    public synchronized org.omg.CORBA.Any[]
    get_elements()
    {
        org.omg.CORBA.Any[] result = new org.omg.CORBA.Any[components_.length];

        try
        {
            for(int i = 0 ; i < components_.length ; i++)
                result[i] = components_[i].to_any();
        }
        catch(org.omg.CORBA.DynAnyPackage.Invalid e)
        {
        }

        return result;
    }

    public synchronized void
    set_elements(org.omg.CORBA.Any[] value)
        throws org.omg.CORBA.DynAnyPackage.InvalidSeq
    {
        if(value.length != components_.length)
            throw new org.omg.CORBA.DynAnyPackage.InvalidSeq();

        try
        {
            org.omg.CORBA.TypeCode contentType = origType_.content_type();
            for(int i = 0 ; i < value.length ; i++)
            {
                org.omg.CORBA.TypeCode valueType = value[i].type();
                if(!valueType.equal(contentType))
                    throw new org.omg.CORBA.DynAnyPackage.InvalidSeq();
            }

            for(int i = 0 ; i < value.length ; i++)
                components_[i].from_any(value[i]);
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
            throw new org.omg.CORBA.DynAnyPackage.InvalidSeq();
        }
        catch(org.omg.CORBA.DynAnyPackage.Invalid e)
        {
            throw new org.omg.CORBA.DynAnyPackage.InvalidSeq();
        }
    }

    //
    // For subclasses
    //

    synchronized org.omg.CORBA.Any
    current_any()
    {
        if(index_ < components_.length && components_[index_] != null)
        {
            DynAny component = (DynAny)components_[index_];
            return component.current_any_value();
        }
        return null;
    }

    org.omg.CORBA.Any
    current_any_value()
    {
        return null;
    }

    synchronized void
    read_stream(org.omg.CORBA.portable.InputStream in)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        int count = in.read_ulong();
        initComponents(count);

        for(int i = 0 ; i < count ; i++)
        {
            if(components_[i] == null)
                throw new org.omg.CORBA.DynAnyPackage.Invalid();

            DynAny component = (DynAny)components_[i];
            component.read_stream(in);
        }
    }

    synchronized void
    write_stream(org.omg.CORBA.portable.OutputStream out)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        out.write_ulong(components_.length);

        for(int i = 0 ; i < components_.length ; i++)
        {
            if(components_[i] == null)
                throw new org.omg.CORBA.DynAnyPackage.Invalid();

            DynAny component = (DynAny)components_[i];
            component.write_stream(out);
        }
    }

    void
    initComponents(int count)
    {
        try
        {
            org.omg.CORBA.TypeCode contentType = origType_.content_type();
            org.omg.CORBA.DynAny[] arr = new org.omg.CORBA.DynAny[count];

            //
            // Preserve existing members of components_
            //
            for(int i = 0 ; i < count ; i++)
            {
                if(i < components_.length && components_[i] != null)
                    arr[i] = components_[i];
                else
                    arr[i] = orb_._OB_createDynAny(contentType);
            }

            components_ = arr;
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
    }
}
