// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

class DynStruct extends DynAny implements org.omg.CORBA.DynStruct
{
    org.omg.CORBA.DynAny[] components_;
    int index_ = 0;

    DynStruct(org.omg.CORBA.TypeCode type, boolean init)
    {
        super(type);

        try
        {
            int count = origType_.member_count();
            components_ = new org.omg.CORBA.DynAny[count];

            if(init)
            {
                for(int i = 0 ; i < count ; i++)
                {
                    org.omg.CORBA.TypeCode tc = origType_.member_type(i);
                    components_[i] = orb_._OB_createDynAny(tc);
                }
            }
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
        catch(org.omg.CORBA.TypeCodePackage.Bounds e)
        {
        }
    }

    //
    // DynAny operations
    //

    public synchronized void
    assign(org.omg.CORBA.DynAny dyn_any)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        if(!(dyn_any instanceof DynStruct))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        org.omg.CORBA.TypeCode tc = dyn_any.type();

        if(!tc.equal(type_))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        DynStruct dyn_struct = (DynStruct)dyn_any;
        for(int i = 0 ; i < dyn_struct.components_.length ; i++)
        {
            org.omg.CORBA.DynAny component = dyn_struct.components_[i];
            if(component == null)
                components_[i] = null;
            else
                components_[i] = component.copy();
        }
    }

    public synchronized void
    from_any(org.omg.CORBA.Any value)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        org.omg.CORBA.TypeCode tc = value.type();

        if(!tc.equal(type_))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        org.omg.CORBA.portable.InputStream in = value.create_input_stream();
        read_stream(in);
    }

    public synchronized org.omg.CORBA.Any
    to_any()
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        org.omg.CORBA.Any result = orb_.create_any();
        org.omg.CORBA.portable.OutputStream out = result.create_output_stream();
        write_stream(out);
        result.read_value(out.create_input_stream(), type_);
        return result;
    }

    public synchronized void
    destroy()
    {
        for(int i = 0 ; i < components_.length ; i++)
            components_[i].destroy();
    }

    public synchronized org.omg.CORBA.DynAny
    copy()
    {
        DynStruct result = new DynStruct(type_, false);

        for(int i = 0 ; i < components_.length ; i++)
            result.components_[i] = components_[i].copy();

        return result;
    }

    public synchronized org.omg.CORBA.DynAny
    current_component()
    {
        return components_[index_];
    }

    public synchronized boolean
    next()
    {
        index_++;
        if(index_ < components_.length)
            return true;
        return false;
    }

    public synchronized boolean
    seek(int index)
    {
        if(index >= 0 && index < components_.length)
        {
            index_ = index;
            return true;
        }
        return false;
    }

    public synchronized void
    rewind()
    {
        index_ = 0;
    }

    //
    // DynStruct IDL interface
    //

    public synchronized String
    current_member_name()
    {
        String result = null;

        try
        {
            result = origType_.member_name(index_);
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
        catch(org.omg.CORBA.TypeCodePackage.Bounds e)
        {
        }

        return result;
    }

    public synchronized org.omg.CORBA.TCKind
    current_member_kind()
    {
        org.omg.CORBA.TCKind result = null;

        try
        {
            org.omg.CORBA.TypeCode memberType = origType_.member_type(index_);
            result = memberType.kind();
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
        catch(org.omg.CORBA.TypeCodePackage.Bounds e)
        {
        }

        return result;
    }

    public synchronized org.omg.CORBA.NameValuePair[]
    get_members()
    {
        org.omg.CORBA.NameValuePair[] result;

        result = new org.omg.CORBA.NameValuePair[components_.length];

        try
        {
            for(int i = 0 ; i < components_.length ; i++)
            {
                result[i] = new org.omg.CORBA.NameValuePair();
                result[i].id = origType_.member_name(i);
                result[i].value = components_[i].to_any();
            }
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
        catch(org.omg.CORBA.TypeCodePackage.Bounds e)
        {
        }
        catch(org.omg.CORBA.DynAnyPackage.Invalid e)
        {
        }

        return result;
    }

    public synchronized void
    set_members(org.omg.CORBA.NameValuePair[] value)
        throws org.omg.CORBA.DynAnyPackage.InvalidSeq
    {
        if(value.length != components_.length)
            throw new org.omg.CORBA.DynAnyPackage.InvalidSeq();

        try
        {
            for(int i = 0 ; i < components_.length ; i++)
            {
                if(!value[i].id.equals(origType_.member_name(i)))
                    throw new org.omg.CORBA.DynAnyPackage.InvalidSeq();

                org.omg.CORBA.TypeCode valueType = value[i].value.type();
                org.omg.CORBA.TypeCode memberType = origType_.member_type(i);
                if(!valueType.equal(memberType))
                    throw new org.omg.CORBA.DynAnyPackage.InvalidSeq();
            }

            for(int i = 0 ; i < components_.length ; i++)
                components_[i].from_any(value[i].value);
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
            throw new org.omg.CORBA.DynAnyPackage.InvalidSeq();
        }
        catch(org.omg.CORBA.TypeCodePackage.Bounds e)
        {
            throw new org.omg.CORBA.DynAnyPackage.InvalidSeq();
        }
        catch(org.omg.CORBA.DynAnyPackage.Invalid e)
        {
            throw new org.omg.CORBA.DynAnyPackage.InvalidSeq();
        }
    }

    //
    // For subclasses
    //

    synchronized org.omg.CORBA.Any
    current_any()
    {
        if(index_ < components_.length && components_[index_] != null)
        {
            DynAny component = (DynAny)components_[index_];
            return component.current_any_value();
        }
        return null;
    }

    org.omg.CORBA.Any
    current_any_value()
    {
        return null;
    }

    synchronized void
    read_stream(org.omg.CORBA.portable.InputStream in)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        for(int i = 0 ; i < components_.length ; i++)
        {
            if(components_[i] == null)
                throw new org.omg.CORBA.DynAnyPackage.Invalid();

            DynAny component = (DynAny)components_[i];
            component.read_stream(in);
        }
    }

    synchronized void
    write_stream(org.omg.CORBA.portable.OutputStream out)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        for(int i = 0 ; i < components_.length ; i++)
        {
            if(components_[i] == null)
                throw new org.omg.CORBA.DynAnyPackage.Invalid();

            DynAny component = (DynAny)components_[i];
            component.write_stream(out);
        }
    }
}
