// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class DynUnion extends DynAny implements org.omg.CORBA.DynUnion
{
    org.omg.CORBA.DynAny[] components_;
    int index_ = 0;
    private int[] memberLabels_;
    private org.omg.CORBA.TypeCode[] memberTypes_;
    private int defaultIndex_ = -1;
    private int currentDiscrIndex_ = -1;

    DynUnion(org.omg.CORBA.TypeCode type)
    {
        super(type);

        try
        {
            int count = origType_.member_count();
            memberLabels_ = new int[count];
            memberTypes_ = new org.omg.CORBA.TypeCode[count];

            for(int i = 0 ; i < count ; i++)
            {
                org.omg.CORBA.Any label = origType_.member_label(i);
                memberLabels_[i] = computeAny(label);
                memberTypes_[i] = origType_.member_type(i);
            }

            org.omg.CORBA.TypeCode discrType = origType_.discriminator_type();

            defaultIndex_ = origType_.default_index();

            if(defaultIndex_ != -1)
                memberLabels_[defaultIndex_] = computeDefaultValue(discrType);

            components_ = new org.omg.CORBA.DynAny[2];
            components_[0] = orb_._OB_createDynAny(discrType);
            components_[1] = null;
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
        catch(org.omg.CORBA.TypeCodePackage.Bounds e)
        {
        }
    }

    //
    // DynAny operations
    //

    public synchronized void
    assign(org.omg.CORBA.DynAny dyn_any)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        if(!(dyn_any instanceof DynUnion))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        org.omg.CORBA.TypeCode tc = dyn_any.type();

        if(!tc.equal(type_))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        DynUnion dyn_union = (DynUnion)dyn_any;

        org.omg.CORBA.DynAny component = dyn_union.components_[0];

        if(component == null)
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        components_[0] = component.copy();

        checkDiscriminatorAndSetMember();

        component = dyn_union.components_[1];

        if(component == null)
            components_[1] = null;
        else
            components_[1] = component.copy();
    }

    public synchronized void
    from_any(org.omg.CORBA.Any value)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        org.omg.CORBA.TypeCode tc = value.type();

        if(!tc.equal(type_))
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        org.omg.CORBA.portable.InputStream in = value.create_input_stream();
        read_stream(in);
    }

    public synchronized org.omg.CORBA.Any
    to_any()
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        org.omg.CORBA.Any result = orb_.create_any();
        org.omg.CORBA.portable.OutputStream out = result.create_output_stream();
        write_stream(out);
        result.read_value(out.create_input_stream(), type_);
        return result;
    }

    public synchronized void
    destroy()
    {
        for(int i = 0 ; i < components_.length ; i++)
            components_[i].destroy();
    }

    public synchronized org.omg.CORBA.DynAny
    copy()
    {
        DynUnion result = new DynUnion(type_);

        result.currentDiscrIndex_ = currentDiscrIndex_;

        for(int i = 0 ; i < components_.length ; i++)
        {
            if(components_[i] == null)
                result.components_[i] = null;
            else
                result.components_[i] = components_[i].copy();
        }

        return result;
    }

    public synchronized org.omg.CORBA.DynAny
    current_component()
    {
        return components_[index_];
    }

    public synchronized boolean
    next()
    {
        index_++;

        if(index_ < components_.length)
        {
            if(index_ == 1)
                checkDiscriminatorAndSetMember();

            return true;
        }

        return false;
    }

    public synchronized boolean
    seek(int index)
    {
        if(index >= 0 && index < components_.length)
        {
            index_ = index;
            return true;
        }
        return false;
    }

    public synchronized void
    rewind()
    {
        index_ = 0;
    }

    //
    // DynUnion IDL interface
    //

    public synchronized boolean
    set_as_default()
    {
        return (defaultIndex_ != -1) && (currentDiscrIndex_ == defaultIndex_);
    }

    public synchronized void
    set_as_default(boolean value)
    {
        if(!value)
            return;

        if(defaultIndex_ == -1)
            return;

        setDynAny(components_[0], memberLabels_[defaultIndex_]);
        checkDiscriminatorAndSetMember();
        index_ = 1;
    }

    public synchronized org.omg.CORBA.DynAny
    discriminator()
    {
        return components_[0];
    }

    public synchronized org.omg.CORBA.TCKind
    discriminator_kind()
    {
        org.omg.CORBA.TypeCode type = components_[0].type();
        return type.kind();
    }

    public synchronized org.omg.CORBA.DynAny
    member()
    {
        checkDiscriminatorAndSetMember();
        return components_[1];
    }

    public synchronized String
    member_name()
    {
        String result = null;

        if(currentDiscrIndex_ == -1)
            return "";

        try
        {
            result = origType_.member_name(currentDiscrIndex_);
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
        catch(org.omg.CORBA.TypeCodePackage.Bounds e)
        {
        }

        return result;
    }

    public synchronized void
    member_name(String value)
    {
        try
        {
            for(int i = 0 ; i < memberLabels_.length ; i++)
            {
                if(value.equals(origType_.member_name(i)))
                {
                    setDynAny(components_[0], memberLabels_[i]);
                    checkDiscriminatorAndSetMember();
                    index_ = 1;
                    return;
                }
            }

            // error?
        }
        catch(org.omg.CORBA.TypeCodePackage.BadKind e)
        {
        }
        catch(org.omg.CORBA.TypeCodePackage.Bounds e)
        {
        }
    }

    public synchronized org.omg.CORBA.TCKind
    member_kind()
    {
        if(components_[1] != null)
        {
            org.omg.CORBA.TypeCode type = components_[1].type();
            return type.kind();
        }

        // error?

        return org.omg.CORBA.TCKind.tk_null;
    }

    //
    // For subclasses
    //

    synchronized org.omg.CORBA.Any
    current_any()
    {
        if(index_ < components_.length && components_[index_] != null)
        {
            DynAny component = (DynAny)components_[index_];
            return component.current_any_value();
        }
        return null;
    }

    org.omg.CORBA.Any
    current_any_value()
    {
        return null;
    }

    synchronized void
    read_stream(org.omg.CORBA.portable.InputStream in)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        if(components_[0] == null)
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        DynAny component = (DynAny)components_[0];
        component.read_stream(in);

        checkDiscriminatorAndSetMember();

        if(components_[1] == null)
            throw new org.omg.CORBA.DynAnyPackage.Invalid();

        component = (DynAny)components_[1];
        component.read_stream(in);
    }

    synchronized void
    write_stream(org.omg.CORBA.portable.OutputStream out)
        throws org.omg.CORBA.DynAnyPackage.Invalid
    {
        for(int i = 0 ; i < components_.length ; i++)
        {
            if(components_[i] == null)
                throw new org.omg.CORBA.DynAnyPackage.Invalid();

            DynAny component = (DynAny)components_[i];
            component.write_stream(out);
        }
    }

    //
    // Helper methods
    //

    void
    checkDiscriminatorAndSetMember()
    {
        int discrIndex = defaultIndex_;

        try
        {
            org.omg.CORBA.Any anyDiscr = components_[0].to_any();

            if(anyDiscr != null)
            {
                int label = computeAny(anyDiscr);
                for(int i = 0 ; i < memberLabels_.length ; i++)
                {
                    if(memberLabels_[i] == label)
                    {
                        discrIndex = i;
                        break;
                    }
                }
            }

            if(discrIndex != currentDiscrIndex_)
            {
                currentDiscrIndex_ = discrIndex;
                if(discrIndex != -1)
                    components_[1] =
                        orb_._OB_createDynAny(memberTypes_[discrIndex]);
                else
                    components_[1] = null;
            }
        }
        catch(org.omg.CORBA.DynAnyPackage.Invalid e)
        {
        }
    }

    void
    setDynAny(org.omg.CORBA.DynAny dyn_any, int value)
    {
        try
        {
            TypeCode type = (TypeCode)dyn_any.type();
            org.omg.CORBA.TypeCode tc = type._OB_getOrigType();

            switch(tc.kind().value())
            {
                case org.omg.CORBA.TCKind._tk_short:
                    dyn_any.insert_short((short)value);
                    break;

                case org.omg.CORBA.TCKind._tk_ushort:
                    dyn_any.insert_ushort((short)value);
                    break;

                case org.omg.CORBA.TCKind._tk_long:
                    dyn_any.insert_long(value);
                    break;

                case org.omg.CORBA.TCKind._tk_ulong:
                    dyn_any.insert_ulong(value);
                    break;

                case org.omg.CORBA.TCKind._tk_char:
                    dyn_any.insert_char((char)value);
                    break;

                case org.omg.CORBA.TCKind._tk_boolean:
                    dyn_any.insert_boolean((value == 1));
                    break;

                case org.omg.CORBA.TCKind._tk_octet:
                    dyn_any.insert_octet((byte)value);
                    break;

                case org.omg.CORBA.TCKind._tk_enum:
                {
                    org.omg.CORBA.DynEnum dyn_enum =
                        (org.omg.CORBA.DynEnum)dyn_any;
                    dyn_enum.value_as_ulong(value);
                }
                break;

                default:
                    throw new RuntimeException("Invalid type kind");
            }
        }
        catch(org.omg.CORBA.DynAnyPackage.InvalidValue e)
        {
        }
    }

    int
    computeAny(org.omg.CORBA.Any any)
    {
        int result = 0;

        TypeCode type = (TypeCode)any.type();
        org.omg.CORBA.TypeCode tc = type._OB_getOrigType();

        switch(tc.kind().value())
        {
            case org.omg.CORBA.TCKind._tk_short:
                result = any.extract_short();
                break;

            case org.omg.CORBA.TCKind._tk_ushort:
                result = any.extract_ushort();
                break;

            case org.omg.CORBA.TCKind._tk_long:
                result = any.extract_long();
                break;

            case org.omg.CORBA.TCKind._tk_ulong:
                result = any.extract_ulong();
                break;

            case org.omg.CORBA.TCKind._tk_char:
                result = any.extract_char();
                break;

            case org.omg.CORBA.TCKind._tk_boolean:
                result = (any.extract_boolean() ? 1 : 0);
                break;

            case org.omg.CORBA.TCKind._tk_octet:
                result = any.extract_octet();
                break;

            case org.omg.CORBA.TCKind._tk_enum:
            {
                org.omg.CORBA.portable.InputStream in =
                    any.create_input_stream();
                result = in.read_ulong();
            }
            break;

            default:
                throw new RuntimeException("Invalid type kind");
        }

        return result;
    }

    int
    computeDefaultValue(org.omg.CORBA.TypeCode discrType)
    {
        int result = 0;
        int min, max = 0;

        TypeCode type = (TypeCode)discrType;
        org.omg.CORBA.TypeCode tc = type._OB_getOrigType();

        switch(tc.kind().value())
        {
            case org.omg.CORBA.TCKind._tk_short:
                min = Short.MIN_VALUE;
                max = Short.MAX_VALUE;
                break;

            case org.omg.CORBA.TCKind._tk_ushort:
                min = 0;
                max = 65535;
                break;

            case org.omg.CORBA.TCKind._tk_long:
                min = Integer.MIN_VALUE;
                max = Integer.MAX_VALUE;
                break;

            case org.omg.CORBA.TCKind._tk_ulong:
                min = 0;
                max = Integer.MAX_VALUE;
                break;

	    case org.omg.CORBA.TCKind._tk_enum:
		min = 0;
		try
		{
		    max = tc.member_count() - 1;
		}
		catch(org.omg.CORBA.TypeCodePackage.BadKind e)
		{
		}
		break;

             case org.omg.CORBA.TCKind._tk_char:
                min = 0;
                max = 255;
                break;

            case org.omg.CORBA.TCKind._tk_boolean:
                min = 0;
                max = 1;
                break;

            default:
                throw new RuntimeException("Invalid type kind");
        }

        boolean hasDefault = false;

        for(int i = max ; i >= min ; i--)
        {
            boolean ok = true;

            for(int j = 0 ; ok && j < memberLabels_.length ; j++)
                if(memberLabels_[j] == i)
                    ok = false;

            if(ok)
            {
                hasDefault = true;
                result = i;
                break;
            }
        }

        return result;
    }
}
