// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

abstract class GIOPClientWorker
{
    //
    // Next request ID
    // Discarded request IDs
    //
    protected static int nextRequestId_;
    protected static java.util.Vector discReqIdVec_ = new java.util.Vector();

    //
    // The client
    // The transport
    //
    protected GIOPClient client_;
    protected com.ooc.OCI.Transport transport_;
    
    //
    // The outgoing message buffers
    // The incoming message buffer
    // The incoming message header
    //
    protected java.util.Vector outVec_ = new java.util.Vector();
    protected com.ooc.OCI.Buffer buf_;
    protected org.omg.GIOP.MessageHeader hdr_;

    //
    // Buffered replies
    //
    protected static final class Reply
    {
	int reqId;
	InputStream in;
	org.omg.GIOP.ReplyStatusType status;
	
	Reply(int r, InputStream i, org.omg.GIOP.ReplyStatusType s)
	{
	    reqId = r;
	    in = i;
	    status = s;
	}
    }
    protected java.util.Vector replyVec_ = new java.util.Vector();

    //
    // Add a "message error" message
    //
    protected final void
    addMessageError()
    {
	OutputStream out = new OutputStream(12);
	org.omg.GIOP.MessageHeader hdr = new org.omg.GIOP.MessageHeader();
	hdr.magic = new char[4];
	hdr.magic[0] = 'G';
	hdr.magic[1] = 'I';
	hdr.magic[2] = 'O';
	hdr.magic[3] = 'P';
	hdr.version = new org.omg.GIOP.Version((byte)1, (byte)0);
	hdr.flag = false ? (byte)1 : (byte)0; // false is big endian
	hdr.message_type = (byte)org.omg.GIOP.MsgType._MessageError;
	hdr.message_size = 0;
	org.omg.GIOP.MessageHeaderHelper.write(out, hdr);
	com.ooc.OCI.Buffer b = new com.ooc.OCI.Buffer();
	b.data(out.buf_, out.count_);
	add(b);
    }

    //
    // Setup buf_ so that a new incoming message can be received
    //
    protected final void
    setupBuffer()
    {
	//
	// Create new buffer for incoming message
	//
	buf_ = new com.ooc.OCI.Buffer(12);
    }

    //
    // Extract the hdr_ from buf_
    //
    protected final void
    extractHeader()
    {
	byte[] data = buf_.data();
   
	if(data[0] != (byte)'G' || data[1] != (byte)'I' ||
	   data[2] != (byte)'O' || data[3] != (byte)'P')
	{
	    addMessageError();
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", MinorCommFailure._MinorNoGIOP,
		org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
	}

	InputStream in = new InputStream(data, 12, 0, false);
	hdr_ = org.omg.GIOP.MessageHeaderHelper.read(in);
	if(in.pos_ != 12)
	    throw new InternalError();
	// false is big endian
	boolean swap = ((hdr_.flag & 0x1) != 0) != false;
	in = new InputStream(data, 12, 0, swap);
	hdr_ = org.omg.GIOP.MessageHeaderHelper.read(in);
	if(in.pos_ != 12)
	    throw new InternalError();
	buf_.realloc(12 + hdr_.message_size);
    }

    //
    // Add outgoing message
    //
    protected void
    add(com.ooc.OCI.Buffer buf)
    {
	//
	// Add new message to the message buffers
	//
	outVec_.addElement(buf);
    }

    //
    // Send all remaining messages, ignoring any errors
    //
    protected final void
    sendRemainingMessages()
    {
	//
	// Try to send all unsent outgoing messages
	//
	for(int i = 0 ; i < outVec_.size() ; i++)
	{
	    com.ooc.OCI.Buffer buf = (com.ooc.OCI.Buffer)outVec_.elementAt(i);
	    
	    while(!buf.is_full())
	    {
		int oldPos = buf.pos();
		
		//
		// Send buffer, non-blocking
		//
		try
		{
		    transport_.send(buf, false);
		}
		catch(org.omg.CORBA.SystemException ex)
		{
		}
		
		//
		// Don't allow any delay if messages cannot be send
		//
		if(buf.pos() == oldPos)
		{
		    i = outVec_.size();
		    break;
		}
	    }
	}
    }

    //
    // Close the transport
    //
    protected final void
    closeTransport()
    {
	//
	// `discard' parameter must be set to TRUE, as it is not
	// necessary to reliably transmit outstanding messages.
	//
	transport_.close(true);
    }

    //
    // Execute incoming message
    //
    protected final void
    execute()
    {
	//
	// Save buffer and all relevant information from the header
	//
        // false is big endian
	boolean swap = ((hdr_.flag & 0x1) != 0) != false;
	org.omg.GIOP.MsgType type =
	    org.omg.GIOP.MsgType.from_int((int)hdr_.message_type);
 	InputStream in = new InputStream(buf_.data(), buf_.length(), 12, swap);
	buf_ = null; // Reset buf_ to allow for reading the next message
 
	//
	// Check message type
	//
	if(type.value() < 0 ||
	   type.value() > org.omg.GIOP.MsgType._MessageError)
	{
	    addMessageError();
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", MinorCommFailure._MinorUnknownMessage,
		org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
	}

	switch(type.value())
	{
	case org.omg.GIOP.MsgType._Reply:
	{
	    org.omg.GIOP.ReplyHeader repH;
	    repH = org.omg.GIOP.ReplyHeaderHelper.read(in);

	    //
	    // Check if request has been discarded
	    //
	    boolean discard = false;
	    for(int i = 0 ; i < discReqIdVec_.size() ; i++)
	    {
		if(((Integer)discReqIdVec_.elementAt(i)).intValue()
		   == repH.request_id)
		{
		    discard = true;
		    discReqIdVec_.removeElementAt(i);
		    break;
		}
	    }

	    if(!discard)
	    {
		//
		// Save the message
		//
		replyVec_.addElement(new Reply(repH.request_id, in,
					       repH.reply_status));
	    }
	}

	break;

	case org.omg.GIOP.MsgType._Request:
	case org.omg.GIOP.MsgType._LocateRequest:
	case org.omg.GIOP.MsgType._CancelRequest:
 
	    //
	    // These messages may not be sent to a client
	    //
	    addMessageError();
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", MinorCommFailure._MinorWrongMessage,
		org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);

	case org.omg.GIOP.MsgType._LocateReply:
 
	    //
	    // Since I am not sending LocatRequest messages,
	    // LocateReply may not be sent to this client
	    //
 	    addMessageError();
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", MinorCommFailure._MinorWrongMessage,
		org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
	    
	case org.omg.GIOP.MsgType._CloseConnection:
 
	    //
	    // Notify connection closing by throwing a TRANSIENT exception
	    //
	    throw new org.omg.CORBA.TRANSIENT();

	case org.omg.GIOP.MsgType._MessageError:
 
	    //
	    // How are message error messages handled? I just send an
	    // error message back.
	    //
 	    addMessageError();
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", MinorCommFailure._MinorMessageError,
		org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);

	default:
	    throw new InternalError();
	}
    }

    //
    // Find reply
    //
    protected final InputStream
    findReply(int reqId, org.omg.GIOP.ReplyStatusTypeHolder status)
    {
	//
	// Check buffered reply messages
	//
	for(int i = 0 ; i < replyVec_.size() ; i++)
	{
	    Reply reply = (Reply)replyVec_.elementAt(i);

	    if(reply.reqId == reqId)
	    {
		//
		// Reply found
		//
		status.value = reply.status;

		//
		// Remove reply from buffer
		//
		replyVec_.removeElementAt(i);

		return reply.in;
	    }
	}

	return null;
    }

    //
    // Check for reply
    //
    protected final boolean
    checkReply(int reqId)
    {
	//
	// Check buffered reply messages
	//
	for(int i = 0 ; i < replyVec_.size() ; i++)
	{
	    Reply reply = (Reply)replyVec_.elementAt(i);

	    if(reply.reqId == reqId)
		return true;
	}

	//
	// Nothing found in buffer
	//
	return false;
    }
    
    //
    // Constructor
    //
    GIOPClientWorker(GIOPClient client, com.ooc.OCI.Transport transport)
    {
	//System.out.println("GIOPClientWorker");
	client_ = client;
	transport_ = transport;
    }

    //
    // Destructor
    //
    protected void
    finalize()
	throws Throwable
    {
	//System.out.println("~GIOPClientWorker");

	super.finalize();
    }

    //
    // Destroy the worker
    //
    abstract void
    _destroy();

    //
    // Get the OCI transport
    //
    final com.ooc.OCI.Transport
    transport()
    {
        return transport_;
    }

    //
    // Get a request id
    //
    static synchronized int
    getRequestId()
    {
	return nextRequestId_++;
    }

    //
    // Discard a request
    //
    static synchronized void
    discardRequest(int reqId)
    {
	discReqIdVec_.addElement(new Integer(reqId));
    }

    //
    // Send a request and receive a reply, with timeout
    //
    abstract InputStream
    sendReceiveTimeout(int reqId, OutputStream out,
		       org.omg.GIOP.ReplyStatusTypeHolder status, int t);

    //
    // Receive a reply, with timeout
    //
    abstract InputStream
    receiveTimeout(int reqId, org.omg.GIOP.ReplyStatusTypeHolder status,
		   int t);

    //
    // Send a request, non-blocking
    //
    abstract void
    sendNonBlocking(OutputStream out);
}
