// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class GIOPClientWorkerBlocking extends GIOPClientWorker
{
    //
    // Constructor
    //
    GIOPClientWorkerBlocking(GIOPClient client,
			     com.ooc.OCI.Transport transport)
    {
	super(client, transport);
    }

    //
    // Destructor
    //
    protected void
    finalize()
	throws Throwable
    {
	super.finalize();
    }

    //
    // Destroy the worker
    //
    void
    _destroy()
    {
	//
	// Send all remaining messages, ignoring any errors
	//
	sendRemainingMessages();
	
	//
	// Close the transport
	//
	closeTransport();
    }

    //
    // Send a request and receive a reply, with timeout
    //
    synchronized InputStream
    sendReceiveTimeout(int reqId, OutputStream out,
		       org.omg.GIOP.ReplyStatusTypeHolder status, int t)
    {
	//
	// Convert output stream to OCI buffer
	// Add the OCI buffer
	//
	com.ooc.OCI.Buffer b = new com.ooc.OCI.Buffer();
	b.data(out.buf_, out.count_);
	add(b);

	//
	// Try to send all messages
	//
	try
	{
	    if(t < 0)
	    {
		for(int i = 0 ; i < outVec_.size() ; i++)
		{
		    //
		    // Send buffer, blocking
		    //
		    com.ooc.OCI.Buffer buf =
			(com.ooc.OCI.Buffer)outVec_.elementAt(i);
		    transport_.send(buf, true);
		    if(!buf.is_full())
			throw new InternalError();
		}

		//
		// Remove all messages
		//
		outVec_.removeAllElements();		    
	    }
	    else
	    {
		//
		// Get current time
		//
		long t1 = System.currentTimeMillis();
		int millis = 0;

		while(!outVec_.isEmpty())
		{
		    //
		    // Send buffer, with timeout
		    //
		    com.ooc.OCI.Buffer buf =
			(com.ooc.OCI.Buffer)(outVec_.firstElement());
		    int oldPos = buf.pos();
		    transport_.send_timeout(buf, t);
		    if(oldPos == buf.pos())
			return null; // Timeout

		    if(buf.is_full())
		    {
			//
			// Message was sent completely, remove it
			//
			outVec_.removeElementAt(0);
		    }

		    //
		    // Calculate time needed
		    //
		    millis = (int)(System.currentTimeMillis() - t1);

		    //
		    // Check if time limit has been exceeded
		    //
		    if(millis >= t)
			return null; // Timeout
		}

		//
		// Calculate new timeout
		//
		t -= millis;
		if(t <= 0)
		    return null; // Timeout
	    }
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    //
	    // Destroy the worker and rethrow
	    //
	    client_.destroyWorker(this);
	    throw ex;
	}

	//
	// From this point on, the call may not be retried, since this
	// could violate "at most once" semantics. Therefore the
	// output stream is reset.
	//
	out.count_ = 0;

	//
	// Return the reply
	//
	return receiveTimeout(reqId, status, t);
    }

    //
    // Receive a reply, with timeout
    //
    synchronized InputStream
    receiveTimeout(int reqId, org.omg.GIOP.ReplyStatusTypeHolder status, int t)
    {
	InputStream in;

	//
	// Try to receive the reply
	//
	try
	{
	    if(t < 0)
	    {
		while((in = findReply(reqId, status)) == null)
		{
		    //
		    // Setup the incoming message buffer
		    //
		    if(buf_ != null)
			throw new InternalError();
		    setupBuffer();

		    //
		    // Receive header, blocking
		    //
		    transport_.receive(buf_, true);
		    if(!buf_.is_full())
			throw new InternalError();

		    //
		    // Header is complete
		    //
		    extractHeader();

		    if(!buf_.is_full())
		    {
			//
			// Receive body, blocking
			//
			transport_.receive(buf_, true);
			if(!buf_.is_full())
			    throw new InternalError();
		    }

		    //
		    // Execute the message
		    //
		    execute();
		}
	    }
	    else
	    {
		//
		// Get current time
		//
		long t1 = System.currentTimeMillis();
		int millis = 0;

		while((in = findReply(reqId, status)) == null)
		{
		    //
		    // Setup the incoming message buffer
		    // if not already done
		    //
		    if(buf_ == null)
			setupBuffer();

		    if(buf_.pos() < 12)
		    {
			//
			// Receive header, with timeout
			//
			int oldPos = buf_.pos();
			transport_.receive_timeout(buf_, t);
			if(oldPos == buf_.pos())
			    return null; // Timeout

			//
			// Header complete?
			//
			if(buf_.is_full())
			    extractHeader();
		    }

		    if(buf_.pos() >= 12)
		    {
			if(!buf_.is_full())
			{
			    //
			    // Receive body, with timeout
			    //
			    int oldPos = buf_.pos();
			    transport_.receive_timeout(buf_, t);
			    if(oldPos == buf_.pos())
				return null; // Timeout
			}

			//
			// Execute message if buffer is full
			//
			if(buf_.is_full())
			    execute();
		    }

		    //
		    // Calculate time needed
		    //
		    millis = (int)(System.currentTimeMillis() - t1);

		    //
		    // Check if time limit has been exceeded
		    //
		    if(millis >= t)
			return null; // Timeout
		}
	    }
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    //
	    // Destroy the worker and rethrow
	    //
	    client_.destroyWorker(this);
	    throw ex;
	}

	if(in == null)
	    throw new InternalError();
	
	return in;
    }

    //
    // Send a request, non-blocking
    //
    synchronized void
    sendNonBlocking(OutputStream out)
    {
	//
	// Convert output stream to OCI buffer
	// Add the OCI buffer
	//
	com.ooc.OCI.Buffer b = new com.ooc.OCI.Buffer();
	b.data(out.buf_, out.count_);
	add(b);

	//
	// Try to send all messages
	//
	try
	{
	    while(!outVec_.isEmpty())
	    {
		//
		// Send buffer, non-blocking
		//
		com.ooc.OCI.Buffer buf =
		    (com.ooc.OCI.Buffer)(outVec_.firstElement());
		int oldPos = buf.pos();
		transport_.send(buf, false);
		if(oldPos == buf.pos())
		    break; // Nothing was sent

		if(buf.is_full())
		{
		    //
		    // Message was sent completely, remove it
		    //
		    outVec_.removeElementAt(0);
		}
	    }
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    //
	    // Destroy the worker and rethrow
	    //
	    client_.destroyWorker(this);
	    throw ex;
	}
    }
}
