// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class GIOPServer extends Server
{
    private BOA boa_; // The BOA
    private com.ooc.OCI.Acceptor acceptor_; // The acceptor
    private GIOPServerStarter starter_; // The server starter
    private boolean enabled_ = true; // Is this server enabled?

    //
    // Constructor
    //
    GIOPServer(BOA boa, com.ooc.OCI.Acceptor acceptor)
    {
	//System.out.println("GIOPServer");
	boa_ = boa;
	acceptor_ = acceptor;
    }

    //
    // Destructor
    //
    protected void
    finalize()
	throws Throwable
    {
	//System.out.println("~GIOPServer");

	//
	// If starter_ is not nil, destroy() was not called
	//
	if(starter_ != null)
	    throw new InternalError();

	super.finalize();
    }

    //
    // Destroy the server
    //
    void
    _destroy()
    {
	if(starter_ != null)
	{
	    starter_._destroy();
	    starter_ = null;
	}
    }

    //
    // Get OCI acceptor
    //
    com.ooc.OCI.Acceptor
    acceptor()
    {
	return acceptor_;
    }

    //
    // Run the server
    //
    boolean
    run()
    {
	boolean done = false;
    
	switch(BOA.conc_model().value())
	{
	case BOA.ConcModel._ConcModelBlocking:
	{
	    if(starter_ == null)
		starter_ =
		    new GIOPServerStarterBlocking(boa_, acceptor_, enabled_);
	    break;
	}

	case BOA.ConcModel._ConcModelThreaded:
	case BOA.ConcModel._ConcModelThreadPerClient:
	case BOA.ConcModel._ConcModelThreadPerRequest:
	case BOA.ConcModel._ConcModelThreadPool:
	{
	    if(starter_ == null)
		starter_ =
		    new GIOPServerStarterThreaded(boa_, acceptor_, enabled_);
	    break;
	}

	default:
	    throw new InternalError();
	}

	if(enabled_)
	    done = starter_.startWorker();

	return done;
    }

    void
    disable()
    {
        if(starter_ != null)
            throw new InternalError();

        enabled_ = false;
    }
}
