// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

abstract class GIOPServerStarter
{
    //
    // The BOA
    //
    protected BOA boa_;

    //
    // The acceptor
    //
    protected com.ooc.OCI.Acceptor acceptor_;

    //
    // The workers
    //
    protected java.util.Vector workers_ = new java.util.Vector();
    protected Object workersMutex_ = new Object();

    //
    // Destroy all workers
    //
    void
    destroyAllWorkers()
    {
	//
	// Destroy all workers. Make sure that any further
	// destructions do not block.
	//
	java.util.Vector workers;
	
	synchronized(workersMutex_)
	{
	    workers = workers_;
	    workers_ = new java.util.Vector();
	}

	//
	// Destroy all workers
	//
	if(workers != null)
	    for(int i = 0 ; i < workers.size() ; i++)
		((GIOPServerWorker)workers.elementAt(i))._destroy();
    }

    //
    // Constructor
    //
    GIOPServerStarter(BOA boa, com.ooc.OCI.Acceptor acceptor, boolean enabled)
    {
	//System.out.println("GIOPServerStarter");
	boa_ = boa;
	acceptor_ = acceptor;

	//
	// Only start the acceptor listening if enabled
	//
	if(enabled)
	    acceptor_.listen();
    }

    //
    // Destructor
    //
    protected void
    finalize()
	throws Throwable
    {
	//System.out.println("~GIOPServerStarter");

	//
	// If workers_ is not empty, destroy() was not called
	//
	if(workers_.size() == 0)
	    throw new InternalError();

	super.finalize();
    }

    //
    // Destroy the server starter
    //
    abstract void
    _destroy();

    //
    // Destroy a worker
    //
    void
    destroyWorker(GIOPServerWorker worker)
    {
	if(worker == null)
	    throw new InternalError();
	
	//
	// Destroy the worker. Make sure that any further destructions
	// do not block.
	//
	GIOPServerWorker w = null;
	
	synchronized(workersMutex_)
	{
	    for(int i = 0 ; i < workers_.size() ; i++)
		if(((GIOPServerWorker)workers_.elementAt(i)) == worker)
		{
		    w = (GIOPServerWorker)workers_.elementAt(i);
		    workers_.removeElementAt(i);
		    break;
		}
	}
	
	if(w != null)
	    w._destroy();
    }

    //
    // Start the worker
    //
    boolean
    startWorker()
    {
	return false;
    }
}
