// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class GIOPServerStarterBlocking extends GIOPServerStarter
{
    //
    // Constructor
    //
    GIOPServerStarterBlocking(BOA boa, com.ooc.OCI.Acceptor acceptor,
			      boolean enabled)
    {
	super(boa, acceptor, enabled);
    }

    //
    // Destructor
    //
    protected void
    finalize()
	throws Throwable
    {
	super.finalize();
    }

    //
    // Destroy the server starter
    //
    void
    _destroy()
    {
	//
	// Close the acceptor
	//
	acceptor_.close();
	
	//
	// Destroy all workers
	//
	destroyAllWorkers();
    }

    //
    // Start the worker
    //
    boolean
    startWorker()
    {
	try
	{
	    com.ooc.OCI.Transport transport = acceptor_.accept();
	    if(transport == null)
		throw new InternalError();
	
	    GIOPServerWorkerBlocking worker =
		new GIOPServerWorkerBlocking(boa_, this, transport);
	    workers_.addElement(worker);

	    while(true)
	    {
		if(workers_.size() == 0)
		    break;
		
		if(workers_.size() != 1)
		    throw new InternalError();
		worker.getRequest();

		if(workers_.size() == 0)
		    break;
		
		if(workers_.size() != 1)
		    throw new InternalError();
		worker.sendReply();
	    }
	}
	catch(org.omg.CORBA.NO_PERMISSION ex)
	{
	    //
	    // Ignore NO_PERMISSION exceptions
	    //
	}

	return true;
    }
}
