// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class GIOPServerStarterThreaded extends GIOPServerStarter
{
    private boolean destroy_ = false; // True if destroy() was called

    //
    // The starter thread
    //
    private final class StarterThread extends Thread
    {
        StarterThread()
        {
            super("ORBACUS:Server:StarterThread");
        }
        
	public void run()
	{
	    starterRun();
	}
    };
    Thread starterThread_;

    //
    // Constructor
    //
    GIOPServerStarterThreaded(BOA boa, com.ooc.OCI.Acceptor acceptor,
			      boolean enabled)
    {
	super(boa, acceptor, enabled);

	//
	// Create starter thread
	//
	starterThread_ = new StarterThread();

	//
	// Start the starter thread if not disabled
	//
        if(enabled)
            starterThread_.start();
    }

    //
    // Destructor
    //
    protected void
    finalize()
	throws Throwable
    {
	if(!destroy_)
	    throw new InternalError();

	super.finalize();
    }

    //
    // Destroy the server starter
    //
    void
    _destroy()
    {
	//
	// Don't destroy twice
	//
	if(destroy_)
	    return;

	//
	// Set the destroy flag
	//
	destroy_ = true;

	//
	// Unblock threads blocking in accept()
	//
	acceptor_.unblock_threads();

	//
	// Join with the starter thread
	//
	if(starterThread_.equals(Thread.currentThread()))
	    throw new InternalError();
	while(starterThread_.isAlive())
	{
	    try
	    {
		starterThread_.join();
	    }
	    catch(InterruptedException ex)
	    {
	    }
	}

	//
	// Close the acceptor
	//
	acceptor_.close();
	
	//
	// Destroy all workers
	//
	destroyAllWorkers();
    }

    //
    // Run
    //
    public void
    starterRun()
    {
	while(!destroy_)
	{
	    try
	    {
		//
		// Get new transport
		//
		com.ooc.OCI.Transport transport = acceptor_.accept();
		if(transport == null)
		    throw new InternalError();
		
		//
		// Check if thread should be stopped and destroyed
		//
		if(destroy_)
		{
		    transport.close(true);
		    break;
		}

		//
		// Create new worker
		//
		if(transport != null)
		{
		    synchronized(this)
		    {
			workers_.addElement(
			    new GIOPServerWorkerThreaded(boa_, this,
							 transport));
		    }
		}
	    }
	    catch(org.omg.CORBA.NO_PERMISSION ex)
	    {
		//
		// Ignore NO_PERMISSION exceptions
		//
	    }
	    catch(org.omg.CORBA.SystemException ex)
	    {
		//
		// Destroy the worker
		//
                // Not sure what to do here. Really destroy? Ignore?
		//destroy();

		return;
	    }
	}
    }
}
