// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

abstract class GIOPServerWorker
{
    //
    // The BOA
    //
    private BOA boa_;

    //
    // The server starter
    // The transport
    //
    protected GIOPServerStarter starter_;
    protected com.ooc.OCI.Transport transport_;
    
    //
    // The outgoing message buffers
    // The incoming message buffer
    // The incoming message header
    //
    protected java.util.Vector outVec_ = new java.util.Vector();
    protected com.ooc.OCI.Buffer buf_;
    protected org.omg.GIOP.MessageHeader hdr_;

    //
    // Display a warning when an unexpected exception is raised by a
    // servant. In addition to an error message, the operation name
    // and acceptor information is displayed, if possible.
    //
    private void
    displayWarning(String err, String op,
		   com.ooc.OCI.TransportInfo transportInfo)
    {
	String msg = err;
	msg += "\noperation name=\"";
	msg += op;
	msg += "\" acceptor=";
	com.ooc.OCI.AcceptorInfo acceptorInfo = transportInfo.acceptor_info();
	com.ooc.OCI.IIOP.AcceptorInfo iiopAcceptorInfo =
	    com.ooc.OCI.IIOP.AcceptorInfoHelper.narrow(acceptorInfo);
	if(iiopAcceptorInfo != null)
	{
	    String host = iiopAcceptorInfo.host();
	    short sPort = iiopAcceptorInfo.port();
	    int port;
	    if(sPort < 0)
		port = 0xffff + (int)sPort + 1;
	    else
		port = (int)sPort;
	    msg += host;
	    msg += ":";
	    msg += port;
	}
	else
	{
	    msg += "not iiop";
	}
	MessageViewer.instance().warning(msg);
    }

    //
    // Add a "message error" message
    //
    protected final void
    addMessageError()
    {
	OutputStream out = new OutputStream(12);
	org.omg.GIOP.MessageHeader hdr = new org.omg.GIOP.MessageHeader();
	hdr.magic = new char[4];
	hdr.magic[0] = 'G';
	hdr.magic[1] = 'I';
	hdr.magic[2] = 'O';
	hdr.magic[3] = 'P';
	hdr.version = new org.omg.GIOP.Version((byte)1, (byte)0);
	hdr.flag = false ? (byte)1 : (byte)0; // false is big endian
	hdr.message_type = (byte)org.omg.GIOP.MsgType._MessageError;
	hdr.message_size = 0;
	org.omg.GIOP.MessageHeaderHelper.write(out, hdr);
	com.ooc.OCI.Buffer b = new com.ooc.OCI.Buffer();
	b.data(out.buf_, out.count_);
	add(b);
    }

    //
    // Add a "close connection" message
    //
    protected final void
    addCloseConnection()
    {
	OutputStream out = new OutputStream(12);
	org.omg.GIOP.MessageHeader hdr = new org.omg.GIOP.MessageHeader();
	hdr.magic = new char[4];
	hdr.magic[0] = 'G';
	hdr.magic[1] = 'I';
	hdr.magic[2] = 'O';
	hdr.magic[3] = 'P';
	hdr.version = new org.omg.GIOP.Version((byte)1, (byte)0);
	hdr.flag = false ? (byte)1 : (byte)0; // false is big endian
	hdr.message_type = (byte)org.omg.GIOP.MsgType._CloseConnection;
	hdr.message_size = 0;
	org.omg.GIOP.MessageHeaderHelper.write(out, hdr);
	com.ooc.OCI.Buffer b = new com.ooc.OCI.Buffer();
	b.data(out.buf_, out.count_);
	add(b);
    }

    //
    // Setup buf_ so that a new incoming message can be received
    //
    protected final void
    setupBuffer()
    {
	//
	// Create new buffer for incoming message
	//
	buf_ = new com.ooc.OCI.Buffer(12);
    }

    //
    // Extract the hdr_ from buf_
    //
    protected final void
    extractHeader()
    {
	byte[] data = buf_.data();
   
	if(data[0] != (byte)'G' || data[1] != (byte)'I' ||
	   data[2] != (byte)'O' || data[3] != (byte)'P')
	{
	    addMessageError();
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", MinorCommFailure._MinorNoGIOP,
		org.omg.CORBA.CompletionStatus.COMPLETED_NO);
	}

	InputStream in = new InputStream(data, 12, 0, false);
	hdr_ = org.omg.GIOP.MessageHeaderHelper.read(in);
	if(in.pos_ != 12)
	    throw new InternalError();
	// false is big endian
	boolean swap = ((hdr_.flag & 0x1) != 0) != false;
	in = new InputStream(data, 12, 0, swap);
	hdr_ = org.omg.GIOP.MessageHeaderHelper.read(in);
	if(in.pos_ != 12)
	    throw new InternalError();
	buf_.realloc(12 + hdr_.message_size);
    }
    
    //
    // Add outgoing message
    //
    protected void
    add(com.ooc.OCI.Buffer buf)
    {
	//
	// Add new message to the message buffers
	//
	outVec_.addElement(buf);
    }

    //
    // Send all remaining messages, ignoring any errors
    //
    protected final void
    sendRemainingMessages()
    {
	//
	// Try to send all unsent outgoing messages
	//
	for(int i = 0 ; i < outVec_.size() ; i++)
	{
	    com.ooc.OCI.Buffer buf = (com.ooc.OCI.Buffer)outVec_.elementAt(i);
	    
	    while(!buf.is_full())
	    {
		int oldPos = buf.pos();
		
		//
		// Send buffer, non-blocking
		//
		try
		{
		    transport_.send(buf, false);
		}
		catch(org.omg.CORBA.SystemException ex)
		{
		}
		
		//
		// Don't allow any delay if messages cannot be send
		//
		if(buf.pos() == oldPos)
		{
		    i = outVec_.size();
		    break;
		}
	    }
	}
    }

    //
    // Close the transport
    //
    protected final void
    closeTransport()
    {
	//
	// `discard' parameter must be set to FALSE, as buffered
	// messages, such as CloseConnection messages, must be
	// reliably transmitted.
	//
	transport_.close(false);
    }

    //
    // Execute incoming message
    //
    protected final void
    execute()
    {
	//
	// Save buffer and all relevant information from the header
	//
        // false is big endian
	boolean swap = ((hdr_.flag & 0x1) != 0) != false;
	org.omg.GIOP.MsgType type =
        org.omg.GIOP.MsgType.from_int((int)hdr_.message_type);
 	InputStream in = new InputStream(buf_.data(), buf_.length(), 12, swap);
	buf_ = null; // Reset buf_ to allow for reading the next message

	//
	// Check message type
	//
	if(type.value() < 0 ||
	   type.value() > org.omg.GIOP.MsgType._MessageError)
	{
	    addMessageError();
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", MinorCommFailure._MinorUnknownMessage,
		org.omg.CORBA.CompletionStatus.COMPLETED_NO);
	}

	switch(type.value())
	{
	case org.omg.GIOP.MsgType._Request:

	    dispatchRequest(in);
	    
	    break;

	case org.omg.GIOP.MsgType._CancelRequest:

	    //
	    // Do nothing here (doing nothing is GIOP compliant)
	    //
	    break;

	case org.omg.GIOP.MsgType._LocateRequest:
            {
                //
                // Get the locate request header
                //
                org.omg.GIOP.LocateRequestHeader locReqH;
                locReqH = org.omg.GIOP.LocateRequestHeaderHelper.read(in);
	    
                //
                // Start creating LocateReply message
                //
                org.omg.GIOP.LocateReplyHeader locRepH =
		new org.omg.GIOP.LocateReplyHeader();
                locRepH.request_id = locReqH.request_id;
                locRepH.locate_status =
		org.omg.GIOP.LocateStatusType.OBJECT_HERE;
                OutputStream out = new OutputStream(1024);
                out.count_ = 12;
                org.omg.GIOP.LocateReplyHeaderHelper.write(out, locRepH);
	    
                //
                // Execute request, using the BOA
                //
                org.omg.CORBA.DynamicImplementation obj =
		boa_._OB_find(locReqH.object_key);
	    
                if(obj == null)
                {
                    /* No body to marshal here ... */
                    locRepH.locate_status =
		    org.omg.GIOP.LocateStatusType.UNKNOWN_OBJECT;
                }
	    
                //
                // Create locate reply message
                //
                org.omg.GIOP.MessageHeader hdr =
		    new org.omg.GIOP.MessageHeader();
                hdr.magic = new char[4];
                hdr.magic[0] = 'G';
                hdr.magic[1] = 'I';
                hdr.magic[2] = 'O';
                hdr.magic[3] = 'P';
                hdr.version = new org.omg.GIOP.Version((byte)1, (byte)0);
                hdr.flag = false ? (byte)1 : (byte)0; // false is big endian
                hdr.message_type = (byte)org.omg.GIOP.MsgType._LocateReply;
                hdr.message_size = out.count_ - 12;
                int old = out.count_;
                out.count_ = 0;
                org.omg.GIOP.MessageHeaderHelper.write(out, hdr);
                org.omg.GIOP.LocateReplyHeaderHelper.write(out, locRepH);
                out.count_ = old;
	    
                //
                // Convert output stream to OCI buffer
                // Add the OCI buffer
                //
                com.ooc.OCI.Buffer b = new com.ooc.OCI.Buffer();
                b.data(out.buf_, out.count_);
                add(b);
	    
                break;
            }

	case org.omg.GIOP.MsgType._Reply:
	case org.omg.GIOP.MsgType._LocateReply:
	case org.omg.GIOP.MsgType._CloseConnection:
 
	    //
	    // These messages may not be sent to a server
	    //
	    addMessageError();
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", MinorCommFailure._MinorWrongMessage,
		org.omg.CORBA.CompletionStatus.COMPLETED_NO);

	case org.omg.GIOP.MsgType._MessageError:
 
	    //
	    // How are message error messages handled? I just send an
	    // error message back.
	    //
 	    addMessageError();
	    throw new org.omg.CORBA.COMM_FAILURE(
		"", MinorCommFailure._MinorMessageError,
		org.omg.CORBA.CompletionStatus.COMPLETED_NO);

	default:
	    throw new InternalError();
	}
    }

    //
    // Dispatch a request
    //
    protected void
    dispatchRequest(InputStream in)
    {
	//
	// Get the request header
	//
	org.omg.GIOP.RequestHeader reqH;
	reqH = org.omg.GIOP.RequestHeaderHelper.read(in);

        //
        // Set the name of the current thread to be this request-id.
        //
        java.lang.Thread currentThread = java.lang.Thread.currentThread();
        String saveName = currentThread.getName();
        currentThread.setName("ORBACUS:Request-"+reqH.request_id);

	com.ooc.OCI.TransportInfo transportInfo = transport_.get_info();

        try
        {
            if(reqH.response_expected)
            {
                //
                // Start creating reply message
                //
                org.omg.GIOP.ReplyHeader repH = new org.omg.GIOP.ReplyHeader();
                repH.service_context = new org.omg.IOP.ServiceContext[0];
                repH.request_id = reqH.request_id;
                repH.reply_status = org.omg.GIOP.ReplyStatusType.NO_EXCEPTION;
                OutputStream out = new OutputStream(1024);
                out.count_ = 12;
                org.omg.GIOP.ReplyHeaderHelper.write(out, repH);
	
                //
                // Execute request, using the BOA
                //
                try
                {
                    //
                    // We set the current OCI transport. We need to save
                    // the transport so that we can restore the current
                    // transport after the call.
                    //
                    com.ooc.OCI.impl.Current current =
		    com.ooc.OCI.impl.Current._OB_impl();
                    com.ooc.OCI.TransportInfo save =
		    current._OB_setOCITransportInfo(transportInfo);

                    DispatchStatus status;
                    try
                    {
                        in.fullORB_ = boa_._OB_orb();
                        out.fullORB_ = boa_._OB_orb();
                        status = boa_._OB_dispatch(reqH.object_key,
                                                   reqH.operation, in, out);
                    }
                    finally
                    {
                        current._OB_setOCITransportInfo(save);
                    }

                    switch(status.value())
                    {
                    case DispatchStatus._DispatchStatusOK:
                        break;
			
                    case DispatchStatus._DispatchStatusExcept:
                        repH.reply_status =
			    org.omg.GIOP.ReplyStatusType.USER_EXCEPTION;
                        break;
		    
                    case DispatchStatus._DispatchStatusNoObject:
		    {
			org.omg.CORBA.OBJECT_NOT_EXIST ex =
                            new org.omg.CORBA.OBJECT_NOT_EXIST();
			
			org.omg.CORBA.OBJECT_NOT_EXISTHelper.write(out,ex);
			repH.reply_status =
                            org.omg.GIOP.ReplyStatusType.SYSTEM_EXCEPTION;
			
			break;
		    }
		    
                    case DispatchStatus._DispatchStatusNoOperation:
		    {
			org.omg.CORBA.BAD_OPERATION ex =
                            new org.omg.CORBA.BAD_OPERATION();
			
			org.omg.CORBA.BAD_OPERATIONHelper.write(out, ex);
			repH.reply_status =
                            org.omg.GIOP.ReplyStatusType.SYSTEM_EXCEPTION;
			
			break;
		    }

                    default:
                        throw new InternalError();
                    }
                }
                catch(org.omg.CORBA.SystemException ex)
                {
                    Util.marshalSystemException(out, ex);
		
                    repH.reply_status =
			org.omg.GIOP.ReplyStatusType.SYSTEM_EXCEPTION;
                }
/*
                catch(org.omg.CORBA.UserException ex)
                {
                    //
                    // Print the exception's stack trace
                    //
                    ex.printStackTrace();

                    //
                    // Print a warning message
                    //
		    displayWarning(
			"Servant method raised an undeclared CORBA " +
			"user exception\n" +
                        "Client receives this exception as CORBA::UNKNOWN",
			reqH.operation, transportInfo);

                    //
                    // Replace non-CORBA exceptions with
                    // CORBA::UNKNOWN
                    //
                    Util.marshalSystemException(out,
                                                new org.omg.CORBA.UNKNOWN());
		    
                    repH.reply_status =
		    org.omg.GIOP.ReplyStatusType.SYSTEM_EXCEPTION;
                }
*/
		catch(Throwable ex)
                {
                    //
                    // Print the exception's stack trace
                    //
                    ex.printStackTrace();

                    //
                    // Print a warning message
                    //
		    displayWarning(
                        "Servant method raised a non-CORBA exception\n" +
                        "Client receives this exception as CORBA::UNKNOWN",
			reqH.operation, transportInfo);

                    //
                    // Replace non-CORBA exceptions with
                    // CORBA::UNKNOWN
                    //
                    Util.marshalSystemException(out,
                                                new org.omg.CORBA.UNKNOWN());
		
                    repH.reply_status =
		    org.omg.GIOP.ReplyStatusType.SYSTEM_EXCEPTION;
                }
                
                //
                // Create reply message
                //
                org.omg.GIOP.MessageHeader hdr =
                   new org.omg.GIOP.MessageHeader();
                hdr.magic = new char[4];
                hdr.magic[0] = 'G';
                hdr.magic[1] = 'I';
                hdr.magic[2] = 'O';
                hdr.magic[3] = 'P';
                hdr.version = new org.omg.GIOP.Version((byte)1, (byte)0);
                hdr.flag = false ? (byte)1 : (byte)0; // false is big endian
                hdr.message_type = (byte)org.omg.GIOP.MsgType._Reply;
                hdr.message_size = out.count_ - 12;
                int old = out.count_;
                out.count_ = 0;
                org.omg.GIOP.MessageHeaderHelper.write(out, hdr);
                org.omg.GIOP.ReplyHeaderHelper.write(out, repH);
                out.count_ = old;
	    
                //
                // Convert output stream to OCI buffer
                // Add the OCI buffer
                //
                com.ooc.OCI.Buffer b = new com.ooc.OCI.Buffer();
                b.data(out.buf_, out.count_);
                add(b);
            }
            else
            {
                //
                // Execute request, using the BOA
                //
                try
                {
                    //
                    // We set the current OCI transport. We need to save
                    // the transport so that we can restore the current
                    // transport after the call.
                    //
                    com.ooc.OCI.impl.Current current =
		    com.ooc.OCI.impl.Current._OB_impl();
                    com.ooc.OCI.TransportInfo save =
			current._OB_setOCITransportInfo(transportInfo);
		    
                    try
                    {
                        //
                        // Since I don't send a response, I'm not interested
                        // in the status
                        //
                        in.fullORB_ = boa_._OB_orb();
                        boa_._OB_dispatch(reqH.object_key, reqH.operation,
                                          in, null);
                    }
                    finally
                    {
                        current._OB_setOCITransportInfo(save);
                    }
                }
                catch(org.omg.CORBA.SystemException ex)
                {
                    //
                    // Since I don't send a response, I'm not
                    // interested in exceptions either
                    //
                }
/*                catch(org.omg.CORBA.UserException ex)
                {
                    //
                    // Print the exception's stack trace
                    //
                    ex.printStackTrace();

                    //
                    // Print a warning message
                    //
                    MessageViewer viewer = MessageViewer.instance();
                    viewer.warning(
			"Servant method raised an undeclared CORBA " +
			"user exception");

                    //
                    // Since I don't send a response, I'm not
                    // interested in exceptions either
                    //
                }
*/                catch(Throwable ex)
                {
                    //
                    // Print the exception's stack trace
                    //
                    ex.printStackTrace();

                    //
                    // Print a warning message
                    //
		    displayWarning(
                        "Servant method raised a non-CORBA exception",
			reqH.operation, transportInfo);

                    //
                    // Since I don't send a response, I'm not
                    // interested in exceptions either
                    //
                }
            }
        }
        finally
        {
            currentThread.setName(saveName);
        }
    }
    
    //
    // Constructor
    //
    GIOPServerWorker(BOA boa, GIOPServerStarter starter,
		     com.ooc.OCI.Transport transport)
    {
	//System.out.println("GIOPServerWorker");
	boa_ = boa;
	starter_ = starter;
	transport_ = transport;
    }

    //
    // Destructor
    //
    protected void
    finalize()
         throws Throwable
    {
	//System.out.println("~GIOPServerWorker");

	super.finalize();
    }

    //
    // Destroy the worker
    //
    abstract void
    _destroy();
}
