// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class GIOPServerWorkerBlocking extends GIOPServerWorker
{
    //
    // Constructor
    //
    GIOPServerWorkerBlocking(BOA boa, GIOPServerStarterBlocking starter,
			     com.ooc.OCI.Transport transport)
    {
	super(boa, starter, transport);
    }

    //
    // Destructor
    //
    protected void
    finalize()
	throws Throwable
    {
	super.finalize();
    }

    //
    // Destroy the worker
    //
    void
    _destroy()
    {
	//
	// Add a CloseConnection message
	//
	addCloseConnection();
	
	//
	// Send all remaining messages, ignoring any errors
	//
	sendRemainingMessages();
	
	//
	// Close the transport
	//
	closeTransport();
    }

    //
    // Get a request
    //
    void
    getRequest()
    {
	try
	{
	    //
	    // Setup the incoming message buffer
	    //
	    if(buf_ != null)
		throw new InternalError();
	    setupBuffer();

	    //
	    // Receive header, blocking, detect connection loss
	    //
	    if(!transport_.receive_detect(buf_, true))
	    {
		starter_.destroyWorker(this);
		return; // Orderly shutdown
	    }
	    if(!buf_.is_full())
		throw new InternalError();

	    //
	    // Header is complete
	    //
	    extractHeader();

	    if(!buf_.is_full())
	    {
		//
		// Receive body, blocking, detect connection loss
		//
		if(!transport_.receive_detect(buf_, true))
		{
		    starter_.destroyWorker(this);
		    return; // Orderly shutdown
		}
		if(!buf_.is_full())
		    throw new InternalError();
	    }

	    //
	    // Execute the message
	    //
	    execute();
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    //
	    // Destroy the worker and rethrow
	    //
	    starter_.destroyWorker(this);
	    throw ex; // In blocking mode, I want exceptions to be propagated
	}
    }

    //
    // Send a reply
    //
    void
    sendReply()
    {
	try
	{
	    //
	    // Try to send all messages
	    //
	    if(outVec_.size() > 1)
		throw new InternalError();
	    for(int i = 0 ; i < outVec_.size() ; i++)
	    {
		//
		// Send buffer, blocking, detect connection loss
		//
		com.ooc.OCI.Buffer buf =
		    (com.ooc.OCI.Buffer)outVec_.elementAt(i);
		if(!transport_.send_detect(buf, true))
		{
		    starter_.destroyWorker(this);
		    return; // Orderly shutdown
		}
		if(!buf.is_full())
		    throw new InternalError();
	    }

	    //
	    // Remove all messages
	    //
	    outVec_.removeAllElements();		    
	}
	catch(org.omg.CORBA.SystemException ex)
	{
	    //
	    // Destroy the worker and rethrow
	    //
	    starter_.destroyWorker(this);
	    throw ex; // In blocking mode, I want exceptions to be propagated
	}
    }
}
