// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class GIOPServerWorkerThreaded extends GIOPServerWorker
{
    private boolean destroy_; // True if destroy() was called

    //
    // The sender thread
    //
    private final class SenderThread extends Thread
    {
        SenderThread()
        {
            super("ORBACUS:Server:SenderThread");
        }
        
	public void run()
	{
	    senderRun();

	    synchronized(GIOPServerWorkerThreaded.this)
	    {
		senderThread_ = null;
		GIOPServerWorkerThreaded.this.notifyAll();
	    }
	}
    };
    Thread senderThread_;

    //
    // The receiver thread
    //
    private final class ReceiverThread extends Thread
    {
        ReceiverThread()
        {
            super("ORBACUS:Server:ReceiverThread");
        }
        
	public void run()
	{
	    receiverRun();

	    synchronized(GIOPServerWorkerThreaded.this)
	    {
		receiverThread_ = null;
		GIOPServerWorkerThreaded.this.notifyAll();
	    }
	}
    };
    Thread receiverThread_;

    //
    // Monitor for "single threaded" thread model, which allows
    // only one thread for request execution.
    //
    private static Object singleThreadedMutex_ = new Object();

    //
    // Helper class for dispatching a request in case of a "thread per
    // request" concurrency model
    //
    private final class Dispatcher extends Thread
    {
	private InputStream in_;

	Dispatcher(InputStream in)
	{
            super("ORBACUS:ThreadPerRequest:Dispatcher");
	    in_ = in;
	}

	public void run()
	{
	    dispatchRequestSuper(in_);
	}
    };

    //
    // Helper class for dispatching a request in case of a "thread
    // pool" concurrency model
    //
    /*private*/ final static class ThreadPool
    {
	static private ThreadPool instance_ = null; // Thread pool singleton
	boolean destroy_; // True if destroy() was called
	int num_; // The number of threads in the pool
	Thread[] handles_; // Handles for the threads in the pool

	private final static class Request
	{
	    GIOPServerWorkerThreaded worker;
	    InputStream in;
	};
	private java.util.Vector reqVec_ = new java.util.Vector();

	synchronized Request
	get()
	{
	    while(!destroy_ && reqVec_.size() == 0)
	    {
		try
		{
		    wait();
		}
		catch(InterruptedException ex)
		{
		}
	    }

	    if(destroy_)
		return null;

	    Request req = (Request)reqVec_.firstElement();
	    reqVec_.removeElementAt(0);
	    return req;
	}

	private final class Dispatcher extends Thread
	{
            Dispatcher()
            {
                super("ORBACUS:ThreadPool:Dispatcher");
            }
            
	    public void
	    run()
	    {
		Request req = null;

		do
		{
		    req = get();

		    if(req != null)
		    {
			req.worker.dispatchRequestSuper(req.in);
		    }
		}
		while(req != null);
	    }
	};

	private
	ThreadPool()
	{
	    num_ = BOA.conc_model_thread_pool();
	    handles_ = new Thread[num_];
	    for(int i = 0 ; i < num_ ; i++)
	    {
		handles_[i] = new Dispatcher();
		handles_[i].start();
	    }
	}

	protected void
	finalize()
	    throws Throwable
	{
	    if(!destroy_)
		throw new InternalError();
	    
	    super.finalize();
	}

	static synchronized ThreadPool
	instance()
	{
	    if(instance_ == null)
		instance_ = new ThreadPool();

	    return instance_;
	}

	static synchronized void
	destroyInstance()
	{
	    if(instance_ != null)
	    {
		instance_._destroy();
		instance_ = null;
	    }
	}

	void
	_destroy()
	{
	    synchronized(this)
	    {
		destroy_ = true;
		notifyAll();
	    }

	    for(int i = 0 ; i < num_ ; i++)
	    {
		while(handles_[i].isAlive())
		{
		    try
		    {
			handles_[i].join();
		    }
		    catch(InterruptedException ex)
		    {
		    }
		}
	    }
	}

	synchronized void
	add(GIOPServerWorkerThreaded w, InputStream i)
	{
	    Request req = new Request();
	    req.worker = w;
	    req.in = i;
	    reqVec_.addElement(req);

	    notify();
	}
    };

    //
    // Dispatch request helper
    //
    protected void
    dispatchRequestSuper(InputStream in)
    {
	super.dispatchRequest(in);
    }
    
    //
    // Add outgoing message
    //
    protected synchronized void
    add(com.ooc.OCI.Buffer buf)
    {
	if(!destroy_) // Don't add if already destroyed
	{
	    super.add(buf);
	    
	    //
	    // Notify the sender thread. This is only necessary if
	    // this is the first outgoing message, since if there is
	    // more then one message in the buffers, threads are
	    // already notified.
	    //
	    if(outVec_.size() == 1)
		notifyAll();
	}
    }

    //
    // Remove outgoing message
    //
    protected synchronized com.ooc.OCI.Buffer
    remove()
    {
	//
	// Wait for a message
	//
	while(!destroy_ && outVec_.size() == 0)
	{
	    try
	    {
		wait();
	    }
	    catch(InterruptedException ex)
	    {
	    }
	}
	
	//
	// Return nil buffer if destroy_ was set
	//
	if(destroy_)
	    return null;

	//
	// Remove and return first message from message buffers
	//
	if(outVec_.size() == 0)
	    throw new InternalError();

	com.ooc.OCI.Buffer buf =
	    (com.ooc.OCI.Buffer)outVec_.firstElement();

	outVec_.removeElementAt(0);

	return buf;
    }

    //
    // Dispatch a request
    //
    protected void
    dispatchRequest(InputStream in)
    {
	switch(BOA.conc_model().value())
	{
	case BOA.ConcModel._ConcModelBlocking:

	    throw new InternalError();
	    
	case BOA.ConcModel._ConcModelThreaded:

	    synchronized(singleThreadedMutex_)
	    {
		super.dispatchRequest(in);
	    }
	    break;
	
	case BOA.ConcModel._ConcModelThreadPerClient:
	    super.dispatchRequest(in);
	    break;
	    
	case BOA.ConcModel._ConcModelThreadPerRequest:
	{
	    new Dispatcher(in).start();
	    break;
	}
	 
	case BOA.ConcModel._ConcModelThreadPool:
	{
	    ThreadPool pool = ThreadPool.instance();
	    pool.add(this, in);
	    break;
	}
	 
	default:
	    throw new InternalError();
	}
    }

    //
    // Constructor
    //
    GIOPServerWorkerThreaded(BOA boa, GIOPServerStarterThreaded starter,
			     com.ooc.OCI.Transport transport)
    {
	super(boa, starter, transport);

	//
	// Start sender and receiver thread
	//
	senderThread_ = new SenderThread();
	senderThread_.start();
	receiverThread_ = new ReceiverThread();
	receiverThread_.start();
    }

    //
    // Destructor
    //
    protected void
    finalize()
	throws Throwable
    {
	if(!destroy_)
	    throw new InternalError();

	super.finalize();
    }

    //
    // Destroy the worker
    //
    synchronized void
    _destroy()
    {
	//
	// Don't destroy twice
	//
	if(destroy_)
	    return;
	
	//
	// Add a CloseConnection message (must be done before destroy_
	// is set to true)
	//
	addCloseConnection();
	
	//
	// Set the destroy flag
	//
	destroy_ = true;
	
	//
	// Notify the sender and the receiver thread
	//
	notifyAll();
	
	//
	// Wait for the sender thread to terminate
	//
	if(senderThread_ != null &&
	   !senderThread_.equals(Thread.currentThread()))
	{
	    while(senderThread_ != null)
	    {
		try
		{
		    wait();
		}
		catch(InterruptedException ex)
		{
		}
	    }
	}
	
	//
	// Unblock threads blocking in the send() and recv()
	// operations
	//
	transport_.unblock_threads(false);
	
	//
	// Wait for the receiver thread to terminate
	//
	if(receiverThread_ != null &&
	   !receiverThread_.equals(Thread.currentThread()))
	{
	    while(receiverThread_ != null)
	    {
		try
		{
		    wait();
		}
		catch(InterruptedException ex)
		{
		}
	    }
	}
	
	//
	// Close the transport
	//
	closeTransport();
    }

    //
    // Run method for sender thread
    //
    public void
    senderRun()
    {
	while(!destroy_)
	{
	    try
	    {
		//
		// Remove outgoing message from the outgoing message buffers
		//
		com.ooc.OCI.Buffer buf = remove();
		
		//
		// Check if thread should be stopped and destroyed
		//
		if(buf == null)
		    break;
		
		//
		// Send buffer, blocking, detect connection loss
		//
		if(!transport_.send_detect(buf, true))
		{
		    //
		    // Destroy the worker
		    //
		    starter_.destroyWorker(this);

		    return; // Orderly shutdown
		}
		if(!buf.is_full())
		    throw new InternalError();
	    }
	    catch(org.omg.CORBA.SystemException ex)
	    {
		//
		// Destroy the worker
		//
		starter_.destroyWorker(this);

		return;
	    }
	}

	//
	// Send all remaining messages, ignoring any errors
	//
	sendRemainingMessages();
    }

    //
    // Run method for receiver thread
    //
    public void
    receiverRun()
    {
	while(!destroy_)
	{
	    try
	    {
		//
		// Setup the incoming message buffer
		//
		if(buf_ != null)
		    throw new InternalError();
		setupBuffer();
		
		//
		// Receive header, blocking, detect connection loss
		//
		if(!transport_.receive_detect(buf_, true))
		{
		    //
		    // Destroy the worker
		    //
		    starter_.destroyWorker(this);		
    
		    return; // Orderly shutdown
		}
		if(!buf_.is_full())
		    throw new InternalError();
		
		//
		// Check if thread should be stopped and destroyed
		//
		if(destroy_)
		    break;

		//
		// Header is complete
		//
		extractHeader();
		
		if(!buf_.is_full())
		{
		    //
		    // Receive body, blocking, detect connection loss
		    //
		    if(!transport_.receive_detect(buf_, true))
		    {
			//
			// Destroy the worker
			//
			starter_.destroyWorker(this);

			return; // Orderly shutdown
		    }
		    if(!buf_.is_full())
			throw new InternalError();
		}

		//
		// Execute the message
		//
		if(!destroy_)
		    execute();
	    }
	    catch(org.omg.CORBA.SystemException ex)
	    {
		//
		// Destroy the worker
		//
		starter_.destroyWorker(this);

		return;
	    }
	}
    }
}
