// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

//
// This class parses the fields of an IIOPNAME stringified name. Pass
// as string or octet sequence to the constructor. The isValid()
// method determines if the path is a valid stringified name. The
// getContents() method returns a string sequence of {id, kind} pairs.
//
public class IIOPNameParser
{
    byte[] path_;
    int curr_ = 0;
    byte terminator_ = 0;

    String[] contents_;
    boolean valid_ = true;

    private String next()
    {
	String field = new String();
	while(curr_ < path_.length && valid_)
	{
	    byte ch = path_[curr_];
	    if(ch == '.' || ch == '/')
	    {
		++curr_;
		terminator_ = ch;
		return field;
	    }
	    
	    //
	    // Escape character? '.', '/' and '\' are
	    // permitted to follow.
	    //
	    if(ch == '\\')
	    {
		++curr_;
		if(curr_ >= path_.length)
		{
		    valid_ = false;
		    continue;
		}

		ch = path_[curr_];
		if(ch != '.' && ch != '/' && ch != '\\')
		{
		    valid_ = false;
		    continue;
		}
	    }
	    field += (char)ch;
	    ++curr_;
	}

	terminator_ = 0;
	return field;
    }

    private boolean atEnd()
    {
	return curr_ >= path_.length;
    }

    private byte terminator()
    {
	return terminator_;
    }

    private void parse()
    {
	java.util.Vector vec = new java.util.Vector();
	while(!atEnd() && valid_)
	{
	    String id = next();
	    String kind;

	    //
	    // If the terminator is a '.' then the next field is the
	    // kind.
	    //
	    if(terminator() == '.')
	    {
		kind = next();
		//
		// The kind field is not permitted to end with a '.'.
		//
		if(terminator() == '.')
		    valid_ = false;
	    }
	    else
		kind = new String();
	    if(valid_)
	    {
		vec.addElement(id);
		vec.addElement(kind);
	    }
	}

	if(valid_)
	{
	    contents_ = new String[vec.size()];
	    for(int i = 0; i < vec.size(); i++)
		contents_[i] = (String)vec.elementAt(i);
	}
    }
    
    public IIOPNameParser(byte[] path)
    {
	path_ = path;

	parse();
    }

    public IIOPNameParser(String path)
    {
	path_ = new byte[path.length()];
	for(int i = 0; i < path.length(); i++)
	{
	    if(path.charAt(i) > 255)
	    {
		valid_ = false;
		break;
	    }
	    path_[i] = (byte)path.charAt(i);
	}

	parse();
    }

    public boolean isValid()
    {
	return valid_;
    }

    public String[] getContents()
    {
	return contents_;
    }
}
