// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

// This class must be public
public final class InputStream extends org.omg.CORBA.portable.InputStream
{
    ORBSingleton orb_;
    ORB fullORB_;
    byte[] buf_;
    int pos_;
    int count_;
    boolean swap_;

    // ------------------------------------------------------------------
    // Private and protected functions
    // ------------------------------------------------------------------

    // Skip ulong, avoids byte shifts
    private synchronized void
    skipULong()
    {
	if(pos_ % 4 != 0)
	    pos_ += 4 - pos_ % 4;

	pos_ += 4;
    }

    private synchronized org.omg.CORBA.TypeCode
    readTypeCodeRec(java.util.Vector vec)
    {
	//
        // NOTE:
        //
        // No data with natural alignment of greater than four octets
        // is needed for TypeCode. Therefore it is not necessary to do
        // encapsulation in a seperate buffer (12.3.3)
        //

        //
        // The "recursive" function is needed for recursive sequence
        // type codes.  Indirection alone could be handled without the
        // additonal sequence parameter.
        //

	int oldPos = 0;
	int kind;
	do
	{
	    kind = read_ulong();
	    if(kind == -1)
	    {
		int posOffset = read_long();
		if(posOffset >= 4)
		    throw new InternalError();

		if(oldPos == 0)
		    oldPos = pos_;

		pos_ = pos_ - 4 + posOffset;
	    }
	}
	while(kind == -1);
    
	vec.addElement(new Integer(pos_ - 4));

	org.omg.CORBA.TypeCode tc = null;

	switch(kind)
	{
	    case org.omg.CORBA.TCKind._tk_null:
	    case org.omg.CORBA.TCKind._tk_void:
	    case org.omg.CORBA.TCKind._tk_short:
	    case org.omg.CORBA.TCKind._tk_long:
	    case org.omg.CORBA.TCKind._tk_ushort:
	    case org.omg.CORBA.TCKind._tk_ulong:
	    case org.omg.CORBA.TCKind._tk_float:
	    case org.omg.CORBA.TCKind._tk_double:
	    case org.omg.CORBA.TCKind._tk_boolean:
	    case org.omg.CORBA.TCKind._tk_char:
	    case org.omg.CORBA.TCKind._tk_wchar:
	    case org.omg.CORBA.TCKind._tk_octet:
	    case org.omg.CORBA.TCKind._tk_any:
	    case org.omg.CORBA.TCKind._tk_TypeCode:
	    case org.omg.CORBA.TCKind._tk_Principal:
		tc = orb_.get_primitive_tc(
		    org.omg.CORBA.TCKind.from_int(kind));
		break;

	    case org.omg.CORBA.TCKind._tk_objref:
	    {
		skipULong();
		boolean swap = swap_;
		_OB_readEndian();

		String id = read_string();
		String name = read_string();
		tc = orb_.create_interface_tc(id, name);

		swap_ = swap;

		break;
	    }

	    case org.omg.CORBA.TCKind._tk_struct:
	    case org.omg.CORBA.TCKind._tk_except:
	    {
		skipULong();
		boolean swap = swap_;
		_OB_readEndian();

		String id = read_string();
		String name = read_string();
		int num = read_ulong();
		org.omg.CORBA.StructMember[] members =
		    new org.omg.CORBA.StructMember[num];
		for(int i = 0 ; i < num ; i++)
		{
		    members[i] = new org.omg.CORBA.StructMember();
		    members[i].name = read_string();
		    members[i].type = readTypeCodeRec(vec);
		}

		if(kind == org.omg.CORBA.TCKind._tk_except)
		    tc = orb_.create_exception_tc(id, name, members);
		else
		    tc = orb_.create_struct_tc(id, name, members);

		swap_ = swap;

		break;
	    }
	
	    case org.omg.CORBA.TCKind._tk_union:
	    {
		skipULong();
		boolean swap = swap_;
		_OB_readEndian();

		String id = read_string();
		String name = read_string();
		org.omg.CORBA.TypeCode discriminatorType =
		    readTypeCodeRec(vec);
		int defaultIndex = read_long();
		int num = read_ulong();
		org.omg.CORBA.UnionMember[] members =
		    new org.omg.CORBA.UnionMember[num];
		for(int i = 0 ; i < num ; i++)
		{
		    members[i] = new org.omg.CORBA.UnionMember();
		    members[i].label = orb_.create_any();
		    if(i == defaultIndex)
		    {
                        //
                        // Unmarshal a dummy value of the appropriate size
                        // for the discriminator type
                        //
                        TypeCode origDiscType =
                            ((TypeCode)discriminatorType)._OB_getOrigType();
                        switch(origDiscType.kind().value())
                        {
                        case org.omg.CORBA.TCKind._tk_short:
                            read_short();
                            break;
                        case org.omg.CORBA.TCKind._tk_ushort:
                            read_ushort();
                            break;
                        case org.omg.CORBA.TCKind._tk_long:
                            read_long();
                            break;
                        case org.omg.CORBA.TCKind._tk_ulong:
                            read_ulong();
                            break;
                        case org.omg.CORBA.TCKind._tk_boolean:
                            read_boolean();
                            break;
                        case org.omg.CORBA.TCKind._tk_char:
                            read_char();
                            break;
                        case org.omg.CORBA.TCKind._tk_enum:
                            read_ulong();
                            break;
                        default:
                            throw new InternalError();
                        }

			//
			// Default label value is the zero octet
			//
			members[i].label.insert_octet((byte)0);
		    }
		    else
		    {
			members[i].label.read_value(this, discriminatorType);
		    }
		    members[i].name = read_string();
		    members[i].type = readTypeCodeRec(vec);
		}

		tc = orb_.create_union_tc(id, name, discriminatorType,
					  members);

		swap_ = swap;

		break;
	    }

	    case org.omg.CORBA.TCKind._tk_enum:
	    {
		skipULong();
		boolean swap = swap_;
		_OB_readEndian();

		String id = read_string();
		String name = read_string();
		int num = read_ulong();
		String[] members = new String[num];
		for(int i = 0 ; i < num ; i++)
		    members[i] = read_string();
		tc = orb_.create_enum_tc(id, name, members);

		swap_ = swap;

		break;
	    }

	    case org.omg.CORBA.TCKind._tk_string:
	    {
		int bound = read_ulong();
		tc = orb_.create_string_tc(bound);

		break;
	    }

	    case org.omg.CORBA.TCKind._tk_wstring:
	    {
		int bound = read_ulong();
		tc = orb_.create_wstring_tc(bound);

		break;
	    }

	    case org.omg.CORBA.TCKind._tk_sequence:
	    case org.omg.CORBA.TCKind._tk_array:
	    {
		skipULong();
		boolean swap = swap_;
		_OB_readEndian();

		int k = read_ulong();
		if(k == -1)
		{
		    int posOffset = read_long();
		    if(posOffset >= -4)
			throw new InternalError();

		    int offset;
		    int last = vec.size() - 1;
		    for(offset = 1 ; offset <= last ; offset++)
		    {
		      if(posOffset ==
			 ((Integer)vec.elementAt(last - offset))
			 .intValue() - (pos_ - 4))
			    break;
		    }

		    if(offset <= last)
		    {
			// Recursive type code
			int length = read_ulong();
			tc = orb_.create_recursive_sequence_tc(length, offset);
		    }
		    else
		    {
			// Non-recursive, but indirection
			pos_ -= 8;
			org.omg.CORBA.TypeCode contentType =
			    readTypeCodeRec(vec);
			int length = read_ulong();
                        if(kind == org.omg.CORBA.TCKind._tk_sequence)
                            tc = orb_.create_sequence_tc(length, contentType);
                        else
                            tc = orb_.create_array_tc(length, contentType);
		    }
		}
		else
		{
		    // Non-recursive, no indirection
		    pos_ -= 4;
		    org.omg.CORBA.TypeCode contentType = readTypeCodeRec(vec);
		    int length = read_ulong();
		    if(kind == org.omg.CORBA.TCKind._tk_sequence)
			tc = orb_.create_sequence_tc(length, contentType);
		    else
			tc = orb_.create_array_tc(length, contentType);
		}

		swap_ = swap;

		break;
	    }

	    case org.omg.CORBA.TCKind._tk_alias:
	    {
		skipULong();
		boolean swap = swap_;
		_OB_readEndian();

		String id = read_string();
		String name = read_string();
		org.omg.CORBA.TypeCode contentType = readTypeCodeRec(vec);
		tc = orb_.create_alias_tc(id, name, contentType);

		swap_ = swap;

		break;
	    }

	    default:
		throw new InternalError();
	}

	vec.setSize(vec.size() - 1);

	if(oldPos != 0)
	    pos_ = oldPos;

	return tc;
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public synchronized boolean
    read_boolean()
    {
	return buf_[pos_++] != (byte)0;
    }

    public synchronized char
    read_char()
    {
	return (char)(buf_[pos_++] & 0xff);
    }

    public synchronized char
    read_wchar()
    {
	return (char)read_short();
    }

    public synchronized byte
    read_octet()
    {
	return buf_[pos_++];
    }

    public synchronized short
    read_short()
    {
	pos_ += pos_ % 2;

	if(swap_)
	    return (short)((buf_[pos_++] & 0xff) | (buf_[pos_++] << 8));
	else
	    return (short)((buf_[pos_++] << 8) | (buf_[pos_++] & 0xff));
    }

    public synchronized short
    read_ushort()
    {
	return read_short();
    }

    public synchronized int
    read_long()
    {
	if(pos_ % 4 != 0)
	    pos_ += 4 - pos_ % 4;

	if(swap_)
	    return (buf_[pos_++] & 0xff) | ((buf_[pos_++] << 8) & 0xff00) |
		((buf_[pos_++] << 16) & 0xff0000) | (buf_[pos_++] << 24);
	else
	    return (buf_[pos_++] << 24) | ((buf_[pos_++] << 16) & 0xff0000) |
		((buf_[pos_++] << 8) & 0xff00) | (buf_[pos_++] & 0xff);
    }

    public synchronized int
    read_ulong()
    {
	return read_long();
    }

    public synchronized long
    read_longlong()
    {
	if(pos_ % 8 != 0)
	    pos_ += 8 - pos_ % 8;

	if(swap_)
	    return ((long)buf_[pos_++] & 0xffL) |
		(((long)buf_[pos_++] << 8) & 0xff00L) |
		(((long)buf_[pos_++] << 16) & 0xff0000L) |
		(((long)buf_[pos_++] << 24) & 0xff000000L) |
		(((long)buf_[pos_++] << 32) & 0xff00000000L) |
		(((long)buf_[pos_++] << 40) & 0xff0000000000L) |
		(((long)buf_[pos_++] << 48) & 0xff000000000000L) |
		((long)buf_[pos_++] << 56);
	else
	    return ((long)buf_[pos_++] << 56) |
		(((long)buf_[pos_++] << 48) & 0xff000000000000L) |
		(((long)buf_[pos_++] << 40) & 0xff0000000000L) |
		(((long)buf_[pos_++] << 32) & 0xff00000000L) |
		(((long)buf_[pos_++] << 24) & 0xff000000L) |
		(((long)buf_[pos_++] << 16) & 0xff0000L) |
		(((long)buf_[pos_++] << 8) & 0xff00L) |
		((long)buf_[pos_++] & 0xffL);
    }

    public synchronized long
    read_ulonglong()
    {
	return read_longlong();
    }

    public synchronized float
    read_float()
    {
	return Float.intBitsToFloat(read_long());
    }

    public synchronized double
    read_double()
    {
	return Double.longBitsToDouble(read_longlong());
    }

    public synchronized String
    read_string()
    {
	int length = read_ulong();
	if(length == 0)
	    throw new org.omg.CORBA.MARSHAL();

	length--;
        String v = new String(buf_, pos_, length);

	for(int i = 0 ; i < length; i++)
	    if(buf_[pos_++] == 0)
		throw new org.omg.CORBA.MARSHAL();
	    
	if(buf_[pos_++] != 0)
	    throw new org.omg.CORBA.MARSHAL();

	return v;
    }

    public synchronized String
    read_wstring()
    {
	int length = read_ulong();
	if(length == 0)
	    throw new org.omg.CORBA.MARSHAL();

	length--;
	char[] tmp = new char[length];
	read_char_array(tmp, 0, length);
	String v = new String(tmp, 0, length);

	for(int i = 0 ; i < length; i++)
	    if(buf_[pos_++] == 0 || buf_[pos_++] == 0)
		throw new org.omg.CORBA.MARSHAL();
	    
	if(buf_[pos_++] != 0 || buf_[pos_++] != 0)
	    throw new org.omg.CORBA.MARSHAL();

	return v;
    }

    public synchronized void
    read_boolean_array(boolean[] value, int offset, int length)
    {
	for(int i = offset ; i < offset + length ; i++)
	    value[i] = buf_[pos_++] != (byte)0;
    }

    public synchronized void
    read_char_array(char[] value, int offset, int length)
    {
	for(int i = offset ; i < offset + length ; i++)
	    value[i] = (char)buf_[pos_++];
    }

    public synchronized void
    read_wchar_array(char[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(pos_ % 2 != 0)
	    pos_++;

	if(swap_)
	    for(int i = offset ; i < offset + length ; i++)
		value[i] = (char)(((char)buf_[pos_++] & 0xff) |
				   ((char)buf_[pos_++] << 8));
	else
	    for(int i = offset ; i < offset + length ; i++)
		value[i] = (char)(((char)buf_[pos_++] << 8) |
				   ((char)buf_[pos_++] & 0xff));
    }

    public synchronized void
    read_octet_array(byte[] value, int offset, int length)
    {
	System.arraycopy(buf_, pos_, value, offset, length);

	pos_ += length;
    }

    public synchronized void
    read_short_array(short[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(pos_ % 2 != 0)
	    pos_++;

	if(swap_)
	    for(int i = offset ; i < offset + length ; i++)
		value[i] = (short)(((short)buf_[pos_++] & 0xff) |
				   ((short)buf_[pos_++] << 8));
	else
	    for(int i = offset ; i < offset + length ; i++)
		value[i] = (short)(((short)buf_[pos_++] << 8) |
				   ((short)buf_[pos_++] & 0xff));
    }

    public synchronized void
    read_ushort_array(short[] value, int offset, int length)
    {
	read_short_array(value, offset, length);
    }

    public synchronized void
    read_long_array(int[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(pos_ % 4 != 0)
	    pos_ += 4 - pos_ % 4;

	if(swap_)
	    for(int i = offset ; i < offset + length ; i++)
		value[i] = ((int)buf_[pos_++] & 0xff) |
		    (((int)buf_[pos_++] << 8) & 0xff00) |
		    (((int)buf_[pos_++] << 16) & 0xff0000) |
		    ((int)buf_[pos_++] << 24);
	else
	    for(int i = offset ; i < offset + length ; i++)
		value[i] = ((int)buf_[pos_++] << 24) |
		    (((int)buf_[pos_++] << 16) & 0xff0000) |
		    (((int)buf_[pos_++] << 8) & 0xff00) |
		    ((int)buf_[pos_++] & 0xff);
    }

    public synchronized void
    read_ulong_array(int[] value, int offset, int length)
    {
	read_long_array(value, offset, length);
    }

    public synchronized void
    read_longlong_array(long[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(pos_ % 8 != 0)
	    pos_ += 8 - pos_ % 8;

	if(swap_)
	    for(int i = offset ; i < offset + length ; i++)
		value[i] = ((long)buf_[pos_++] & 0xffL) |
		    (((long)buf_[pos_++] << 8) & 0xff00L) |
		    (((long)buf_[pos_++] << 16) & 0xff0000L) |
		    (((long)buf_[pos_++] << 24) & 0xff000000L) |
		    (((long)buf_[pos_++] << 32) & 0xff00000000L) |
		    (((long)buf_[pos_++] << 40) & 0xff0000000000L) |
		    (((long)buf_[pos_++] << 48) & 0xff000000000000L) |
		    ((long)buf_[pos_++] << 56);
	else
	    for(int i = offset ; i < offset + length ; i++)
		value[i] = ((long)buf_[pos_++] << 56) |
		    (((long)buf_[pos_++] << 48) & 0xff000000000000L) |
		    (((long)buf_[pos_++] << 40) & 0xff0000000000L) |
		    (((long)buf_[pos_++] << 32) & 0xff00000000L) |
		    (((long)buf_[pos_++] << 24) & 0xff000000L) |
		    (((long)buf_[pos_++] << 16) & 0xff0000L) |
		    (((long)buf_[pos_++] << 8) & 0xff00L) |
		    ((long)buf_[pos_++] & 0xffL);
    }

    public synchronized void
    read_ulonglong_array(long[] value, int offset, int length)
    {
	read_longlong_array(value, offset, length);
    }

    public synchronized void
    read_float_array(float[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(pos_ % 4 != 0)
	    pos_ += 4 - pos_ % 4;

	if(swap_)
	    for(int i = offset ; i < offset + length ; i++)
	    {
		int v = (buf_[pos_++] & 0xff) |
		    ((buf_[pos_++] << 8) & 0xff00) |
		    ((buf_[pos_++] << 16) & 0xff0000) |
		    (buf_[pos_++] << 24);

		value[i] = Float.intBitsToFloat(v);
	    }
	else
	    for(int i = offset ; i < offset + length ; i++)
	    {
		int v = (buf_[pos_++] << 24) |
		    ((buf_[pos_++] << 16) & 0xff0000) |
		    ((buf_[pos_++] << 8) & 0xff00) |
		    (buf_[pos_++] & 0xff);
		
		value[i] = Float.intBitsToFloat(v);
	    }
    }

    public synchronized void
    read_double_array(double[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(pos_ % 8 != 0)
	    pos_ += 8 - pos_ % 8;

	if(swap_)
	    for(int i = offset ; i < offset + length ; i++)
	    {
		long v = ((long)buf_[pos_++] & 0xffL) |
		    (((long)buf_[pos_++] << 8) & 0xff00L) |
		    (((long)buf_[pos_++] << 16) & 0xff0000L) |
		    (((long)buf_[pos_++] << 24) & 0xff000000L) |
		    (((long)buf_[pos_++] << 32) & 0xff00000000L) |
		    (((long)buf_[pos_++] << 40) & 0xff0000000000L) |
		    (((long)buf_[pos_++] << 48) & 0xff000000000000L) |
		    ((long)buf_[pos_++] << 56);

		value[i] = Double.longBitsToDouble(v);
	    }
	else
	    for(int i = offset ; i < offset + length ; i++)
	    {
		long v = ((long)buf_[pos_++] << 56) |
		    (((long)buf_[pos_++] << 48) & 0xff000000000000L) |
		    (((long)buf_[pos_++] << 40) & 0xff0000000000L) |
		    (((long)buf_[pos_++] << 32) & 0xff00000000L) |
		    (((long)buf_[pos_++] << 24) & 0xff000000L) |
		    (((long)buf_[pos_++] << 16) & 0xff0000L) |
		    (((long)buf_[pos_++] << 8) & 0xff00L) |
		    ((long)buf_[pos_++] & 0xffL);

		value[i] = Double.longBitsToDouble(v);
	    }
    }

    public synchronized org.omg.CORBA.Object
    read_Object()
    {
	org.omg.IOP.IOR ior = org.omg.IOP.IORHelper.read(this);

	if((ior.type_id.length() == 0) && (ior.profiles.length == 0))
	    return null;
	
	if(fullORB_ == null)
	    fullORB_ = ORB._OB_defaultORB();

	if(fullORB_ == null)
	    throw new org.omg.CORBA.INITIALIZE();

	return fullORB_._OB_createObject(ior);
    }

    public synchronized org.omg.CORBA.TypeCode
    read_TypeCode()
    {
	java.util.Vector vec = new java.util.Vector();
	org.omg.CORBA.TypeCode tc = readTypeCodeRec(vec);
	if(vec.size() > 0)
	    throw new InternalError();
	return tc;
    }

    public synchronized org.omg.CORBA.Any
    read_any()
    {
	org.omg.CORBA.TypeCode tc = read_TypeCode();
	org.omg.CORBA.Any any = orb_.create_any();
	any.read_value(this, tc);
	return any;
    }

    public synchronized org.omg.CORBA.Principal
    read_Principal()
    {
	byte[] v = new byte[read_ulong()];
	read_octet_array(v, 0, v.length);
	Principal p = new Principal();
	p.name(v);
	return p;
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    public
    InputStream(byte[] buf, int count, int pos, boolean swap)
    {
	orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();
	buf_ = buf;
	count_ = count;
	pos_ = pos;
	swap_ = swap;
    }

    public
    InputStream(byte[] buf)
    {
	orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();
	buf_ = buf;
	count_  = buf.length;
	pos_ = 0;
	swap_ = false;
    }

    public synchronized void
    _OB_readEndian()
    {
	swap_ = read_boolean() != false; // false means big endian
    }
}
