// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

//
// The message viewer class
//
public class MessageViewer
{
    //
    // The message viewer singleton
    //
    static MessageViewer messageViewer_ = null;

    //
    // The message viewer trace level
    //
    static int traceLevel_ = 0;

    //
    // Get the message viewer singleton
    //
    static public MessageViewer instance()
    {
        if(messageViewer_ == null)
            messageViewer_ = new MessageViewer();
        return messageViewer_;

    }

    //
    // Set and get the viewers trace level
    //
    static public int getTraceLevel()
    {
        return traceLevel_;
    }

    static public void setTraceLevel(int level)
    {
        traceLevel_ = level;
    }

    //
    // Print messages
    //
    public void message(String msg)
    {
        System.err.println(msg);
    }

    public void error(String msg)
    {
        String s = "Error: ";
        s += msg;
        message(s);
    }

    public void warning(String msg)
    {
        String s = "Warning: ";
        s += msg;
        message(s);
    }

    public void trace(int level, String msg)
    {
        if(traceLevel_ >= level)
        {
            String s = "[";
            s += msg;
            s += "]";
            message(s);
        }
    }
};
