// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

//
// Note: If something is changed here, it must also be changed in other
// ORBacus implementations, like ORBacus for C++.
//

// This class must be public
public final class MinorCommFailure
{
    private static MinorCommFailure[] values_ = new MinorCommFailure[22];
    private int value_;

    //
    // Unspecified
    //
    private static final MinorCommFailure dummy =
    new MinorCommFailure(0);

    //
    // recv() failed
    //
    public static final int _MinorRecv = 1;
    public static final MinorCommFailure MinorRecv =
    new MinorCommFailure(_MinorRecv);

    //
    // send() failed
    //
    public static final int _MinorSend = 2;
    public static final MinorCommFailure MinorSend =
    new MinorCommFailure(_MinorSend);

    //
    // recv() returned zero
    //
    public static final int _MinorRecvZero = 3;
    public static final MinorCommFailure MinorRecvZero =
    new MinorCommFailure(_MinorRecvZero);

    //
    // send() returned zero
    //
    public static final int _MinorSendZero = 4;
    public static final MinorCommFailure MinorSendZero =
    new MinorCommFailure(_MinorSendZero);

    //
    // socket() failed
    //
    public static final int _MinorSocket = 5;
    public static final MinorCommFailure MinorSocket =
    new MinorCommFailure(_MinorSocket);

    //
    // setsockopt() failed
    //
    public static final int _MinorSetsockopt = 6;
    public static final MinorCommFailure MinorSetsockopt =
    new MinorCommFailure(_MinorSetsockopt);

    //
    // getsockopt() failed
    //
    public static final int _MinorGetsockopt = 7;
    public static final MinorCommFailure MinorGetsockopt =
    new MinorCommFailure(_MinorGetsockopt);

    //
    // bind() failed
    //
    public static final int _MinorBind = 8;
    public static final MinorCommFailure MinorBind =
    new MinorCommFailure(_MinorBind);
    //
    // listen() failed
    //
    public static final int _MinorListen = 9;
    public static final MinorCommFailure MinorListen =
    new MinorCommFailure(_MinorListen);

    //
    // connect() failed
    //
    public static final int _MinorConnect = 10;
    public static final MinorCommFailure MinorConnect =
    new MinorCommFailure(_MinorConnect);

    //
    // accept() failed
    //
    public static final int _MinorAccept = 11;
    public static final MinorCommFailure MinorAccept =
    new MinorCommFailure(_MinorAccept);

    //
    // select() failed
    //
    public static final int _MinorSelect = 12;
    public static final MinorCommFailure MinorSelect =
    new MinorCommFailure(_MinorSelect);

    //
    // gethostname() failed
    //
    public static final int _MinorGethostname = 13;
    public static final MinorCommFailure MinorGethostname =
    new MinorCommFailure(_MinorGethostname);

    //
    // gethostbyname() failed
    //
    public static final int _MinorGethostbyname = 14;
    public static final MinorCommFailure MinorGethostbyname =
    new MinorCommFailure(_MinorGethostbyname);

    //
    // WSAStartup() failed
    //
    public static final int _MinorWSAStartup = 15;
    public static final MinorCommFailure MinorWSAStartup =
    new MinorCommFailure(_MinorWSAStartup);

    //
    // WSACleanup() failed
    //
    public static final int _MinorWSACleanup = 16;
    public static final MinorCommFailure MinorWSACleanup =
    new MinorCommFailure(_MinorWSACleanup);

    //
    // Not a GIOP message
    //
    public static final int _MinorNoGIOP = 17;
    public static final MinorCommFailure MinorNoGIOP =
    new MinorCommFailure(_MinorNoGIOP);

    //
    // Unknown GIOP message
    //
    public static final int _MinorUnknownMessage = 18;
    public static final MinorCommFailure MinorUnknownMessage =
    new MinorCommFailure(_MinorUnknownMessage);

    //
    // Wrong GIOP message
    //
    public static final int _MinorWrongMessage = 19;
    public static final MinorCommFailure MinorWrongMessage =
    new MinorCommFailure(_MinorWrongMessage);

    //
    // Got a close connection message
    //
    public static final int _MinorCloseConnection = 20;
    public static final MinorCommFailure MinorCloseConnection =
    new MinorCommFailure(_MinorCloseConnection);

    //
    // Got a message error message
    //
    public static final int _MinorMessageError = 21;
    public static final MinorCommFailure MinorMessageError =
    new MinorCommFailure(_MinorMessageError);

    public int value()
    {
	return value_;
    }

    public static MinorCommFailure from_int(int value)
    {
	return values_[value];
    }

    private MinorCommFailure(int value)
    {
	values_[value] = this;
	value_ = value;
    }
}
