// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class NVList extends org.omg.CORBA.NVList
{
    private ORBSingleton orb_;
    private java.util.Vector namedValueVec_ = new java.util.Vector();

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public int
    count()
    {
	return namedValueVec_.size();
    }

    public org.omg.CORBA.NamedValue
    add(int flags)
    {
	NamedValue n = new NamedValue("", orb_.create_any(), flags);
	namedValueVec_.addElement(n);
	return n;
    }

    public org.omg.CORBA.NamedValue
    add_item(String item_name, int flags)
    {
	NamedValue n = new NamedValue(item_name, orb_.create_any(), flags);
	namedValueVec_.addElement(n);
	return n;
    }

    public org.omg.CORBA.NamedValue
    add_value(String item_name, org.omg.CORBA.Any a, int flags)
    {
	NamedValue n = new NamedValue(item_name, a, flags);
	namedValueVec_.addElement(n);
	return n;
    }

    public org.omg.CORBA.NamedValue
    item(int index)
	throws org.omg.CORBA.Bounds
    {
	try
	{
	    return (NamedValue)namedValueVec_.elementAt(index);
	}
	catch(ArrayIndexOutOfBoundsException ex)
	{
	    throw new org.omg.CORBA.Bounds();
	}
    }

    public void
    remove(int index)
	throws org.omg.CORBA.Bounds
    {
	try
	{
	    namedValueVec_.removeElementAt(index);
	}
	catch(ArrayIndexOutOfBoundsException ex)
	{
	    throw new org.omg.CORBA.Bounds();
	}
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    NVList()
    {
	orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();
    }

    NVList(int n)
    {
	orb_ = (ORBSingleton)org.omg.CORBA.ORB.init();

	//
	// The parameter n is only a "hint" for how many elements the
	// user intends to create with operations such as
	// add_item(). Thus the following code is disabled:
	//
//  	for(int i = 0 ; i < n ; i++)
//  	{
//  	    NamedValue nv = new NamedValue("", orb_.create_any(), 0);
//  	    namedValueVec_.addElement(nv);
//  	}
    }
}
