// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

// This class must be public
public final class ORB extends ORBSingleton
{
    //
    // The ORB option filter
    //
    private static OptionFilter optionFilter_;

    //
    // The default ORB
    //
    private static ORB defaultORB_;

    //
    // The BOA
    //
    private BOA boa_;

    //
    // The OCI connection factory registry
    //
    private com.ooc.OCI.ConFactoryRegistry registry_ =
	new com.ooc.OCI.impl.ConFactoryRegistry();

    //
    // All clients
    //
    private java.util.Vector clients_ = new java.util.Vector();

    //
    // All initial services
    //
    static private class InitialService
    {
        String ref;
        org.omg.CORBA.Object obj;
    }
    private java.util.Hashtable services_ = new java.util.Hashtable();

    //
    // The default initial reference "template"
    //
    private String defaultInitRef_ = null;

    //
    // For send_multiple_requests_deferred
    //
    private org.omg.CORBA.Request[] deferredRequests_ =
	new org.omg.CORBA.Request[0];
    private boolean[] deferredRequestCompletions_ = new boolean[0];

    //
    // Set of default policies
    //
    java.util.Vector policies_ = new java.util.Vector();

    //
    // Whether DII operations should raise system exceptions
    //
    private static boolean raiseDIIExceptions_;

    //
    // The concurrency model
    //
    public static final class ConcModel // This class must be public
    {
	private static ConcModel[] values_ = new ConcModel[2];
	private int value_;

	public final static int _ConcModelBlocking = 0;
	public final static ConcModel ConcModelBlocking =
	    new ConcModel(_ConcModelBlocking);
	public final static int _ConcModelThreaded = 1;
	public final static ConcModel ConcModelThreaded =
	    new ConcModel(_ConcModelThreaded);

	private
	ConcModel(int value)
	{
	    values_[value] = this;
	    value_ = value;
	}

	public int
	value()
	{
	    return value_;
	}
    };
    private static ConcModel concModel_ = ConcModel.ConcModelBlocking;

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public String[]
    list_initial_services()
    {
	java.util.Vector vec = new java.util.Vector();

	java.util.Enumeration keys = services_.keys();
	while(keys.hasMoreElements())
	{
	    Object key = keys.nextElement();
	    vec.addElement(key.toString());
	}

	String[] list = new String[vec.size()];
	vec.copyInto((Object[])list);

	return list;
    }

    public org.omg.CORBA.Object
    resolve_initial_references(String object_name)
	throws org.omg.CORBA.ORBPackage.InvalidName
    {
	org.omg.CORBA.Object obj = null;

        //
        // Search the list of initial references
        //
        InitialService svc = (InitialService)services_.get(object_name);
        if(svc != null)
        {
            if(svc.obj == null)
            {
                if(svc.ref == null)
                    throw new InternalError();
                obj = string_to_object(svc.ref);
                svc.obj = obj;
            }
            else
                obj = svc.obj;
        }

        //
        // If no match was found, and there's a default initial
        // reference "template", then try to compose a URL using
        // the identifier as the object-key
        //
        if(obj == null && defaultInitRef_ != null)
        {
            String url = defaultInitRef_ + '/' + object_name;
            obj = string_to_object(url);
        }

	if(obj != null)
	{
	    try
	    {
		//
                // If the object is not locality constrained, or
                // collocated, return a new object with the current
                // set of policies applied.
		//
		// NOTE: This can be changed back to obj._set_policy...
		//       when 2.3/Messaging is adopted.
		//
		com.ooc.CORBA.Delegate d =
		    (com.ooc.CORBA.Delegate)
		     ((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate();

                //
                // If the delegate is local, then return the object itself.
                //
                if(d.is_local())
                    return obj;
                
                //
                // Create the policy array
                //
                int len = policies_.size();
                org.omg.CORBA.Policy[] p = new org.omg.CORBA.Policy[len];
                for(int i = 0; i < len; ++i)
                    p[i] = (org.omg.CORBA.Policy)policies_.elementAt(i);

                //
                // Set the policies on the delegate
                //
		return d.set_policy_overrides(p, org.omg.CORBA.SetOverrideType.
                                              SET_OVERRIDE);
	    }
            catch(java.lang.ClassCastException e)
            {
                //
                // If the object is locality constrained, return the
                // object itself.
                //
                return obj;
            }
	    catch(org.omg.CORBA.PolicyManagerPackage.InvalidPolicies e)
	    {
		throw new InternalError();
	    }
	}

	throw new org.omg.CORBA.ORBPackage.InvalidName();
    }

    public String
    object_to_string(org.omg.CORBA.Object o)
    {
	org.omg.IOP.IOR ior;

	if(o == null)
	{
	    ior = new org.omg.IOP.IOR();
	    ior.type_id = "";
	    ior.profiles = new org.omg.IOP.TaggedProfile[0];
	}
	else
	{
	    try
	    {
		org.omg.CORBA.DynamicImplementation impl =
		    (org.omg.CORBA.DynamicImplementation)o;

		connect(impl);
	    }
	    catch(ClassCastException ex)
	    {
	    }
	    
	    Delegate p = (Delegate)(((org.omg.CORBA.portable.ObjectImpl)o)
				    ._get_delegate());
	    
	    ior = p._OB_ior();
	}

	return _OB_IORToString(ior);
    }

    public org.omg.CORBA.Object
    string_to_object(String s)
    {
	return INS.stringToObject(this, s);
    }

    public org.omg.CORBA.NVList
    create_list(int count)
    {
	return new NVList(count);
    }

    public org.omg.CORBA.NVList
    create_operation_list(org.omg.CORBA.OperationDef oper)
    {
	//
	// Get operation description
	//
	org.omg.CORBA.ContainedPackage.Description d = oper.describe();
	org.omg.CORBA.OperationDescription desc =
	    org.omg.CORBA.OperationDescriptionHelper.extract(d.value);

	//
	// Create list
	//
	NVList list = new NVList();
	for(int i = 0 ; i < desc.parameters.length ; i++)
	{
	    org.omg.CORBA.ParameterDescription par = desc.parameters[i];

	    org.omg.CORBA.Any any = create_any();
	    any.type(par.type);

	    int flags = 0;
	    switch(par.mode.value())
	    {
	    case org.omg.CORBA.ParameterMode._PARAM_IN:
		flags = org.omg.CORBA.ARG_IN.value;
		break;

	    case org.omg.CORBA.ParameterMode._PARAM_OUT:
		flags = org.omg.CORBA.ARG_OUT.value;
		break;

	    case org.omg.CORBA.ParameterMode._PARAM_INOUT:
		flags = org.omg.CORBA.ARG_INOUT.value;
		break;

	    default:
		throw new InternalError();
	    }

	    list.add_value(par.name, any, flags);
	}

	return list;
    }

    public org.omg.CORBA.NamedValue
    create_named_value(String name, org.omg.CORBA.Any value, int flags)
    {
	return new NamedValue(name, value, flags);
    }

    public org.omg.CORBA.ExceptionList
    create_exception_list()
    {
	return new ExceptionList();
    }

    public org.omg.CORBA.ContextList
    create_context_list()
    {
	return new ContextList();
    }

    public org.omg.CORBA.Context
    get_default_context()
    {
	return new Context("");
    }

    public org.omg.CORBA.Environment
    create_environment()
    {
	return new Environment();
    }

    public void
    send_multiple_requests_oneway(org.omg.CORBA.Request[] requests)
    {
	for(int i = 0 ; i < requests.length ; i++)
	    requests[i].send_oneway();
    }

    public void
    send_multiple_requests_deferred(org.omg.CORBA.Request[] requests)
    {
	deferredRequests_ = new org.omg.CORBA.Request[requests.length];
	deferredRequestCompletions_ = new boolean[requests.length];

	for(int i = 0 ; i < deferredRequests_.length ; i++)
	{
	    deferredRequests_[i] = requests[i];
	    deferredRequests_[i].send_deferred();
	    deferredRequestCompletions_[i] = false;	
	}
    }

    public boolean
    poll_next_response()
    {
	for(int i = 0 ; i < deferredRequests_.length ; i++)
	    if(!deferredRequestCompletions_[i])
		if(deferredRequests_[i].poll_response())
		    deferredRequestCompletions_[i] = true;

	for(int i = 0 ; i < deferredRequests_.length ; i++)
	    if(deferredRequestCompletions_[i] && deferredRequests_[i] != null)
		return true;

	return false;
    }

    public org.omg.CORBA.Request
    get_next_response()
    {
	for(int i = 0 ; i < deferredRequests_.length ; i++)
	    if(deferredRequestCompletions_[i] && deferredRequests_[i] != null)
	    {
		org.omg.CORBA.Request request = deferredRequests_[i];
		deferredRequests_[i] = null;
		return request;
	    }

	return null;
    }

    public org.omg.CORBA.portable.OutputStream
    create_output_stream()
    {
	OutputStream out = new OutputStream();
	out.fullORB_ = this;
	return out;
    }

    public void
    connect(org.omg.CORBA.Object obj)
    {
  	if(boa_ == null)
  	    throw new org.omg.CORBA.INITIALIZE("BOA not initialized");
  	boa_.connect(obj);
    }

    public void
    disconnect(org.omg.CORBA.Object obj)
    {
  	if(boa_ == null)
  	    throw new org.omg.CORBA.INITIALIZE("BOA not initialized");

  	boa_.disconnect(obj);
    }

    public org.omg.CORBA.Policy
    create_policy(int policy_type, org.omg.CORBA.Any val)
	 throws org.omg.CORBA.PolicyError
    {
	if(policy_type == com.ooc.OB.CONNECTION_REUSE_POLICY.value)
	{
	    try
	    {
		boolean b = val.extract_boolean();
		return new com.ooc.OB.impl.ConnectionReusePolicy(b);
	    }
	    catch(org.omg.CORBA.BAD_OPERATION e)
	    {
		throw new org.omg.CORBA.PolicyError(
			     org.omg.CORBA.BAD_TYPE.value);
	    }
	}
	if(policy_type == com.ooc.OB.PROTOCOL_POLICY.value)
	{
	    try
	    {
		int tag = val.extract_long();
		return new com.ooc.OB.impl.ProtocolPolicy(tag);
	    }
	    catch(org.omg.CORBA.BAD_OPERATION e)
	    {
		throw new org.omg.CORBA.PolicyError(
			     org.omg.CORBA.BAD_TYPE.value);
	    }
	}
	if(policy_type == com.ooc.OB.RECONNECT_POLICY.value)
	{
	    try
	    {
		boolean b = val.extract_boolean();
		return new com.ooc.OB.impl.ReconnectPolicy(b);
	    }
	    catch(org.omg.CORBA.BAD_OPERATION e)
	    {
		throw new org.omg.CORBA.PolicyError(
			     org.omg.CORBA.BAD_TYPE.value);
	    }
	}
	if(policy_type == com.ooc.OB.TIMEOUT_POLICY.value)
	{
	    try
	    {
		int t = val.extract_long();
		return new com.ooc.OB.impl.TimeoutPolicy(t);
	    }
	    catch(org.omg.CORBA.BAD_OPERATION e)
	    {
		throw new org.omg.CORBA.PolicyError(
			     org.omg.CORBA.BAD_TYPE.value);
	    }
	}
	throw new org.omg.CORBA.PolicyError(org.omg.CORBA.BAD_POLICY.value);
    }

    protected void
    set_parameters(String[] args, java.util.Properties props)
    {
	MessageViewer viewer = MessageViewer.instance();

	//
	// Initialize the properties
	//
	Properties properties = Properties.init(args);

	//
	// The order of precedence (lowest to highest) for properties is:
	//
	//   Configuration file (already read by Properties.init)
	//   User-supplied properties
	//   System properties
	//   Command-line arguments
	//
	if(props != null)
	    properties.merge(props);

	try
	{
	    properties.merge(System.getProperties());
	}
	catch(java.lang.SecurityException ex)
	{
	    // ignore - may be thrown by applet
	}

	//
	// Process each argument. Turn each argument into an appropriate
	// property.
	//
	java.util.Enumeration e = optionFilter_.parse(viewer, args);
	while(e.hasMoreElements())
	{
	    OptionFilter.Option option = (OptionFilter.Option)e.nextElement();
	    String name = option.name;
	    String[] value = option.value;

	    if(name.equals("id"))
	    {
		properties.setProperty("ooc.orb.id", value[0]);
	    }
	    else if(name.equals("service"))
	    {
		properties.setProperty("ooc.service." + value[0], value[1]);
	    }
	    else if(name.equals("InitRef"))
	    {
                String id = null, ref = null;
                int pos = value[0].indexOf('=');
                if(pos > 0)
                {
                    id = value[0].substring(0, pos);
                    if(value[0].length() - 1 > pos)
                        ref = value[0].substring(pos + 1);
                }
                if(id == null || ref == null)
		    viewer.warning("ORB_init: invalid value for " +
				   "-ORBInitRef: " + value[0]);
                else
                    properties.setProperty("ooc.service." + id, ref);
	    }
	    else if(name.equals("DefaultInitRef"))
	    {
                if(value[0].trim().length() == 0)
		    viewer.warning("ORB_init: invalid value for " +
				   "-ORBDefaultInitRef");
                else
                    properties.setProperty("ooc.orb.default_init_ref",
                                           value[0]);
	    }
	    else if(name.equals("repository"))
	    {
		properties.setProperty("ooc.service.InterfaceRepository",
				       value[0]);
	    }
	    else if(name.equals("naming"))
	    {
		properties.setProperty("ooc.service.NameService", value[0]);
	    }
	    else if(name.equals("trace_level"))
	    {
		properties.setProperty("ooc.orb.trace_level", value[0]);
	    }
	    else if(name.equals("blocking"))
	    {
		properties.setProperty("ooc.orb.conc_model", "blocking");
	    }
	    else if(name.equals("threaded"))
	    {
		properties.setProperty("ooc.orb.conc_model", "threaded");
	    }
	    else if(name.equals("version"))
	    {
		viewer.message(com.ooc.CORBA.Version.version);
	    }
	    else if(name.equals("license"))
	    {
		viewer.message(com.ooc.CORBA.License.license);
	    }
	}

	//
	// Process each property
	//

	String id = null;
	ConcModel concModel = conc_model();
	boolean addIIOPConnector = true;

        String version = System.getProperty("java.version");
        if(version.startsWith("1.1"))
            raiseDIIExceptions_ = false;
        else
            raiseDIIExceptions_ = true;

	String[] keys = properties.getKeys("ooc.orb.");
	for(int i = 0 ; i < keys.length ; i++)
	{
	    String key = keys[i];
	    String value = properties.getProperty(key);
	    if(value == null)
		throw new InternalError();

	    if(key.equals("ooc.orb.conc_model"))
	    {
		if(value.equals("blocking"))
		    concModel = ConcModel.ConcModelBlocking;
		else if(value.equals("threaded"))
		    concModel = ConcModel.ConcModelThreaded;
		else
		    viewer.warning("ORB_init: unknown value for " +
				   "ooc.orb.conc_model: " + value);
	    }
	    else if(key.equals("ooc.orb.trace_level"))
	    {
		try
		{
		    MessageViewer.setTraceLevel(Integer.parseInt(value));
		}
		catch(NumberFormatException ex)
		{
		    viewer.warning("ORB_init: invalid value for " +
				   "ooc.orb.trace_level");
		}
	    }
	    else if(key.equals("ooc.orb.id"))
	    {
		id = value;
	    }
	    else if(key.equals("ooc.orb.add_iiop_connector"))
	    {
		if(value.equalsIgnoreCase("true"))
		    addIIOPConnector = true;
		else
		    addIIOPConnector = false;
	    }
            else if(key.equals("ooc.orb.default_init_ref"))
            {
                if(value.trim().length() == 0)
		    viewer.warning("ORB_init: invalid value for " +
				   "ooc.orb.default_init_ref");
                else
                    defaultInitRef_ = value;
            }
            else if(key.equals("ooc.orb.raise_dii_exceptions"))
            {
		if(value.equalsIgnoreCase("true"))
		    raiseDIIExceptions_ = true;
		else
		    raiseDIIExceptions_ = false;
            }
	    else
	    {
		viewer.warning("ORB_init: unknown property `" + key + "'");
	    }
	}

	//
	// Verify the ORB id
	//
	if(id != null && !id.equals("OB_ORB"))
	{
	    viewer.error("ORB_init: unknown ORB `" + id + "'");
	    throw new org.omg.CORBA.INITIALIZE();
	}

	//
	// Set the concurrency model
	//
	conc_model(concModel);

	//
	// Add an IIOP protocol plug-in
	//
	if(addIIOPConnector)
	{
	    if(registry_ == null)
		throw new InternalError();
	    registry_.add_factory(new com.ooc.OCI.IIOP.impl.ConFactory());
	}

	//
	// Add those services configured in the "ooc.service" property.
	//
	String servicePrefix = "ooc.service.";
	String[] serviceKeys = properties.getKeys(servicePrefix);
	for(int i = 0 ; i < serviceKeys.length ; i++)
	{
	    String key = serviceKeys[i];
	    String value = properties.getProperty(key);
	    if(value == null)
		throw new InternalError();
	    String serviceName = key.substring(servicePrefix.length());
	    _OB_addInitialService(serviceName, value);
	}
    }

    protected void
    set_parameters(java.applet.Applet app, java.util.Properties props)
    {
	String[] args = new String[0];

	//
	// Check for parameter list
	//
	String paramList = app.getParameter("ORBparams");
	if(paramList != null)
	{
	    java.util.StringTokenizer p =
		new java.util.StringTokenizer(paramList);

	    args = new String[p.countTokens()];

	    int i = 0;
	    while(p.hasMoreTokens())
		args[i++] = p.nextToken();
	}

	set_parameters(args, props);
    }

    // ------------------------------------------------------------------
    // Additonal ORBacus specific functions
    // ------------------------------------------------------------------

    public org.omg.CORBA.BOA
    BOA_init(String[] args, java.util.Properties props)
    {
 	if(boa_ == null)
 	{
	    boa_ = new BOA(this);
 	    boa_.set_parameters(args, props);
 	}

 	return boa_;
    }

    public org.omg.CORBA.BOA
    BOA_init(java.applet.Applet app, java.util.Properties props)
    {
 	if(boa_ == null)
 	{
 	    boa_ = new BOA(this);
 	    boa_.set_parameters(app, props);
 	}

 	return boa_;
    }

    public com.ooc.OCI.ConFactoryRegistry
    get_con_factory_registry()
    {
	return registry_;
    }

    public void
    service(String service, org.omg.CORBA.Object obj)
    {
	_OB_addInitialService(service, obj);
    }

    public org.omg.CORBA.Object
    get_inet_object(String host, int port, String name)
    {
	return get_inet_object(host, port, name, "");
    }

    public org.omg.CORBA.Object
    get_inet_object(String host, int port, String name, String id)
    {
	return INS.getInetObject(this, host, port, name, id);
    }

    public static ConcModel
    conc_model()
    {
	return concModel_;
    }

    public static void
    conc_model(ConcModel model)
    {
	concModel_ = model;
    }

    public void // This connect is OB specific
    connect(org.omg.CORBA.Object obj, String name)
    {
 	if(boa_ == null)
 	    throw new org.omg.CORBA.INITIALIZE("BOA not initialized");

  	boa_.connect(obj, name);
    }

    public void
    add_initial_reference(String name, org.omg.CORBA.Object obj)
    {
	_OB_addInitialService(name, obj);
    }

    public String[]
    filter_options(String[] args)
    {
	return optionFilter_.filter(args);
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    public
    ORB()
    {
	//
	// The default ORB is the ORB which was created first
	//
	if(defaultORB_ == null)
	{
	    defaultORB_ = this;
	}

	//
	// Add the default policies
	//
	policies_.addElement(
	    new com.ooc.OB.impl.ConnectionReusePolicy(true));
	policies_.addElement(
	    new com.ooc.OB.impl.ReconnectPolicy(false));

	//
	// Create the ORBPolicyManager
	//
	org.omg.CORBA.PolicyManager policyManager =
	    new ORBPolicyManager_impl(policies_);
	_OB_addInitialService("ORBPolicyManager", policyManager);

	//
	// Add the OCI_Current singleton to the list of initial services
	//
	com.ooc.OCI.Current ociCurrent =
	    com.ooc.OCI.impl.Current._OB_instance();
	_OB_addInitialService("OCICurrent", ociCurrent);

	//
	// Create list with options supported by the ORB
	//
	if(optionFilter_ == null)
	{
	    optionFilter_ = new OptionFilter("ORB_init", "-ORB");
	    optionFilter_.add("id", 1);
	    optionFilter_.add("service", 2);
	    optionFilter_.add("repository", 1);
	    optionFilter_.add("naming", 1);
	    optionFilter_.add("config", 1);
	    optionFilter_.add("trace_level", 1);
	    optionFilter_.add("blocking", 0);
	    optionFilter_.add("threaded", 0);
	    optionFilter_.add("version", 0);
	    optionFilter_.add("license", 0);
	    optionFilter_.add("InitRef", 1);
	    optionFilter_.add("DefaultInitRef", 1);
	}
    }

    protected void
    finalize()
	throws Throwable
    {
	//
	// Destroy all clients
	//
	for(int i = 0 ; i < clients_.size() ; i++)
	    ((Client)clients_.elementAt(i))._destroy();

	super.finalize();
    }

    static ORB
    _OB_defaultORB()
    {
	return defaultORB_;
    }

    String
    _OB_IORToString(org.omg.IOP.IOR ior)
    {
	OutputStream out = new OutputStream();
	out._OB_writeEndian();
	org.omg.IOP.IORHelper.write(out, ior);

	return "IOR:" + Util.octetsToAscii(out.buf_, out.count_);
    }

    org.omg.CORBA.Object
    _OB_createObject(org.omg.IOP.IOR ior)
    {
	//
	// Check for nil object reference
	//
	if((ior.type_id.length() == 0) && (ior.profiles.length == 0))
	    return null;

	//
	// If there is a BOA, try to find an implementation object
	//
 	if(boa_ != null)
 	{
 	    org.omg.CORBA.DynamicImplementation impl = boa_._OB_find(ior);

 	    if(impl != null)
 		return impl;
 	}

	//
	// Create new delegate, set policies and change delegate
	//
	Delegate p = new Delegate(this);
	p._OB_policies(policies_);
	_OB_changeDelegate(p, ior);

	//
	// Create new object, set the delegate and return
	//
	StubForObject obj = new StubForObject();
	obj._set_delegate(p);
	return obj;
    }

    void
    _OB_changeDelegate(Delegate p, org.omg.IOP.IOR ior)
    {
	if((ior.type_id.length() == 0) && (ior.profiles.length == 0))
	{
	    // I can't change a delegate to a nil del
	    throw new org.omg.CORBA.INV_OBJREF();
	}

	synchronized(clients_)
	{
	    byte[] key = null;
	    Client clt = null;
	    
	    //
	    // Find reuse policy among policies and convert the policy
	    // vector to a policy array
	    //
	    java.util.Vector policiesVector = p._OB_policies();
	    org.omg.CORBA.Policy[] policies =
		new org.omg.CORBA.Policy[policiesVector.size()];
	    com.ooc.OB.ConnectionReusePolicy reusePolicy = null;
	    for(int i = 0 ; i < policies.length ; i++)
	    {
		org.omg.CORBA.Policy policy =
		    (org.omg.CORBA.Policy)policiesVector.elementAt(i);
		if(policy.policy_type() ==
		   com.ooc.OB.CONNECTION_REUSE_POLICY.value)
		{
		    reusePolicy =
			com.ooc.OB.ConnectionReusePolicyHelper.narrow(policy);
		}
		policies[i] = policy;
	    }
	    
	    if(reusePolicy == null || reusePolicy.value())
	    {
		//
		// Try to reuse clients
		//
		for(int i = 0 ; i < clients_.size() ; i++)
		{
		    //
		    // Check reuse flag
		    //
		    if(((Client)clients_.elementAt(i)).reuseClient())
		    {
			com.ooc.OCI.Connector connector =
			    ((Client)clients_.elementAt(i)).connector();
			key = connector.is_usable_with_policies(ior, policies);
			if(key.length > 0)
			    clt = ((Client)clients_.elementAt(i));
		    }
		}
	    }

	    if(clt == null)
	    {
		//
		// Create a new connector
		//
		com.ooc.OCI.ConFactory factory =
		    registry_.get_factory_with_policies(ior, policies);
		if(factory == null)
		    throw new org.omg.CORBA.NO_RESOURCES();
		com.ooc.OCI.Connector connector =
		    factory.create_with_policies(ior, policies);
		key = connector.is_usable_with_policies(ior, policies);
		if(key.length == 0)
		    throw new InternalError();
		
		//
		// Create a new client
		//
		clt = new com.ooc.CORBA.GIOPClient(this, connector);
		clients_.addElement(clt);
		if(reusePolicy != null && !reusePolicy.value())
		    clt.reuseClient(false);
	    }

	    if(clt == null)
		throw new InternalError();
	    
	    //
	    // Setup the object
	    //
	    p._OB_client(clt);
	    p._OB_ior(ior);
	    p._OB_key(key); // Must be last, as the other operations
	                    // invalidate the key
	}
    }

    void
    _OB_incClientUsage(Client client)
    {
	synchronized(clients_)
	{
	    client.incUsage();
	}
    }

    void
    _OB_decClientUsage(Client client)
    {
	synchronized(clients_)
	{
	    boolean inUse = client.decUsage();

	    if(!inUse)
	    {
		for(int i = 0 ; i < clients_.size() ; i++)
		    if((Client)clients_.elementAt(i) == client)
		    {
			client._destroy();
			clients_.removeElementAt(i);
			return;
		    }
		
		throw new InternalError();
	    }
	}
    }

    boolean
    _OB_equivalent(org.omg.IOP.IOR ior1, org.omg.IOP.IOR ior2)
    {
	return registry_.equivalent(ior1, ior2);
    }

    int
    _OB_hash(org.omg.IOP.IOR ior, int maximum)
    {
	return registry_.hash(ior, maximum);
    }

    public void
    _OB_addInitialService(String name, String iorString)
    {
        InitialService svc = new InitialService();
        svc.ref = iorString;
        svc.obj = null;

	if(services_.put(name, svc) != null)
	    MessageViewer.instance().warning("ORB_init: initial service `" +
					     name + "' was overridden");
    }

    public void
    _OB_addInitialService(String name, org.omg.CORBA.Object obj)
    {
	/*
	Delegate p = (Delegate)(((org.omg.CORBA.portable.ObjectImpl)obj)
				._get_delegate());

	org.omg.IOP.IOR ior = p.ior_;
	*/

        InitialService svc = new InitialService();
        svc.ref = null;
        svc.obj = obj;

	if(services_.put(name, svc) != null)
	    MessageViewer.instance().warning("ORB_init: initial service `" +
					     name + "' was overridden");
    }

    public static boolean
    _OB_raiseDIIExceptions()
    {
        return raiseDIIExceptions_;
    }
}
