// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class ORBPolicyManager_impl extends LocalObject
    implements org.omg.CORBA.PolicyManager
{
    private java.util.Vector policies_; // Set of ORB policies

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------    

    public org.omg.CORBA.Policy
    get_policy_override(int policy_type)
    {
        int policiesLen = policies_.size();
        for(int i = 0 ; i < policiesLen ; ++i)
	    if(((org.omg.CORBA.Policy)policies_.elementAt(i)).policy_type()
	       == policy_type)
		return (org.omg.CORBA.Policy)policies_.elementAt(i);
        return null;
    }

    public org.omg.CORBA.Policy[]
    get_specific_policy_overrides(int[] types)
    {
        int len = policies_.size();
        int typesLen = types.length;
        java.util.Vector policies = new java.util.Vector();
        for(int i = 0; i < typesLen; ++i)
        {
            int currType = types[i];
            for(int j = 0; j < len; ++j)
            {
                org.omg.CORBA.Policy currPolicy =
                    (org.omg.CORBA.Policy)policies_.elementAt(j);
                if(currPolicy.policy_type() == currType)
                {
                    policies.addElement(currPolicy);
                }
            }
        }
        return toArray(policies);
    }

    public org.omg.CORBA.Policy[]
    get_all_policy_overrides()
    {
        return toArray(policies_);
    }

    public void
    add_policy_overrides(org.omg.CORBA.Policy[] np)
         throws org.omg.CORBA.PolicyManagerPackage.InvalidPolicies
    {
        java.util.Vector newPolicies = (java.util.Vector)policies_.clone();

        int npLen = np.length;
        for(int i = 0 ; i < npLen ; ++i)
        {
            int len = newPolicies.size();
            int j;
		
            for(j = 0 ; j < len ; ++j)
                if(((org.omg.CORBA.Policy)newPolicies.elementAt(j)).
                   policy_type() == np[i].policy_type())
                    break;
		
            if(j < len)
                newPolicies.setElementAt(np[i], j);
            else
                newPolicies.addElement(np[i]);
        }
        PolicyValidator.validatePolicies(newPolicies);
        copyFrom(newPolicies);
    }

    public void
    remove_policy_overrides(int[] ts)
    {
        int typesLen = ts.length;
        for(int i = 0 ; i < typesLen ; ++i)
        {
            int currType = ts[i];
            int len = policies_.size();
            for(int j = 0 ; j < len ; ++j)
            {
                if(((org.omg.CORBA.Policy)policies_.elementAt(j)).
                   policy_type() == currType)
                {
                    policies_.removeElementAt(j);
                    return;
                }
            }
        }
    }

    public void
    replace_all_policy_overrides(org.omg.CORBA.Policy[] policies)
         throws org.omg.CORBA.PolicyManagerPackage.InvalidPolicies
    {
        java.util.Vector newPolicies = new java.util.Vector();
        int policiesLen = policies.length;
        for(int i = 0; i < policiesLen; ++i)
        {
            newPolicies.addElement(policies[i]);
        }
        PolicyValidator.validatePolicies(newPolicies);

        copyFrom(newPolicies);
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    ORBPolicyManager_impl(java.util.Vector policies)
    {
        policies_ = policies;
    }

    private org.omg.CORBA.Policy[]
    toArray(java.util.Vector policies)
    {
        int len = policies.size();
        org.omg.CORBA.Policy[] rc = new org.omg.CORBA.Policy[len];
        for(int i = 0; i < len; ++i)
        {
            rc[i] = (org.omg.CORBA.Policy)policies.elementAt(i);
        }
        return rc;
    }

    private void
    copyFrom(java.util.Vector newPolicies)
    {
        policies_.removeAllElements();
        int nlen = newPolicies.size();
        for(int i = 0; i < nlen; ++i)
            policies_.addElement(newPolicies.elementAt(i));
    }
}


