// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

// This class must be public
public class ORBSingleton extends org.omg.CORBA.ORB
{
    // ------------------------------------------------------------------
    // Private and protected functions
    // ------------------------------------------------------------------

    private final boolean
    fillRec(org.omg.CORBA.TypeCodeHolder in, org.omg.CORBA.TypeCode ou,
	    int offset)
    {
	TypeCode inner = (TypeCode)in.value;
	TypeCode outer = (TypeCode)ou;

	//
	// Check for recursive sequence type code with same offset
	//
	if(inner.kind_ == org.omg.CORBA.TCKind.tk_sequence &&
	   inner.offset_ > 0 && inner.offset_ == offset)
	{
	    //
	    // This TypeCode will cause a cyclic object dependency
	    //
	    TypeCode p = new TypeCode();
	    
	    p.kind_ = org.omg.CORBA.TCKind.tk_sequence;
	    p.length_ = inner.length_;
	    p.offset_ = inner.offset_;
	
	    p.contentType_ = outer;

	    in.value = p;

	    return true;
	}

	//
	// Check for sequences, arrays and aliases
	//
	if(inner.kind_ == org.omg.CORBA.TCKind.tk_sequence &&
	   inner.offset_ == 0 ||
	   inner.kind_ == org.omg.CORBA.TCKind.tk_array ||
	   inner.kind_ == org.omg.CORBA.TCKind.tk_alias)
	{
	    org.omg.CORBA.TypeCodeHolder contentType
		= new org.omg.CORBA.TypeCodeHolder(inner.contentType_);
	    
	    if(fillRec(contentType, outer, offset + 1))
	    {
		TypeCode p = new TypeCode();

		p.kind_ = inner.kind_;
		
		if(inner.kind_ == org.omg.CORBA.TCKind.tk_alias)
		{
		    p.id_ = inner.id_;
		    p.name_ = inner.name_;
		}
		else
		{
		    p.length_ = inner.length_;
		    
		    if(inner.kind_ == org.omg.CORBA.TCKind.tk_sequence)
			p.offset_ = inner.offset_;
		}
		
		p.contentType_ = (TypeCode)contentType.value;
		
		in.value = p;
		
		return true;
	    }
	}
	
	//
	// Check for structs, unions and exceptions
	//
	if(inner.kind_ == org.omg.CORBA.TCKind.tk_struct ||
	   inner.kind_ == org.omg.CORBA.TCKind.tk_union ||
	   inner.kind_ == org.omg.CORBA.TCKind.tk_except)
	{
	    int len = inner.memberTypes_.length;
	    org.omg.CORBA.TypeCodeHolder[] memberTypes = 
		new org.omg.CORBA.TypeCodeHolder[len];
	    
	    boolean changed = false;
	    for(int i = 0 ; i < len ; i++)
	    {
		memberTypes[i] =
		    new org.omg.CORBA.TypeCodeHolder(inner.memberTypes_[i]);
		if(fillRec(memberTypes[i], outer, offset + 1))
		    changed = true;
	    }
	    
	    if(changed)
	    {
		TypeCode p = new TypeCode();
		
		p.kind_ = inner.kind_;
		p.id_ = inner.id_;
		p.name_ = inner.name_;
		p.memberNames_ = inner.memberNames_;
		
		if(inner.kind_ == org.omg.CORBA.TCKind.tk_union)
		    p.labels_ = inner.labels_;
		
		p.memberTypes_ = new TypeCode[len];
		for(int i = 0 ; i < len ; i++)
		    p.memberTypes_[i] = (TypeCode)memberTypes[i].value;

		inner = p;
		
		return true;
	    }
	}
	
	return false;
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public String[]
    list_initial_services()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.Object
    resolve_initial_references(String name)
	throws org.omg.CORBA.ORBPackage.InvalidName
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    //
    // Should only be available for the full ORB.
    //
    public String
    object_to_string(org.omg.CORBA.Object o)
    {
	org.omg.IOP.IOR ior;

	if(o == null)
	{
	    ior = new org.omg.IOP.IOR();
	    ior.type_id = "";
	    ior.profiles = new org.omg.IOP.TaggedProfile[0];
	}
	else
	{
	    try
	    {
		org.omg.CORBA.DynamicImplementation impl =
		    (org.omg.CORBA.DynamicImplementation)o;

//		connect(impl);
	    }
	    catch(ClassCastException ex)
	    {
	    }
	    
	    Delegate p = (Delegate)(((org.omg.CORBA.portable.ObjectImpl)o)
				    ._get_delegate());
	    
	    ior = p._OB_ior();
	}

	return _OB_IORToString(ior);
    }

    //
    // Should only be available for the full ORB.
    //
    String
    _OB_IORToString(org.omg.IOP.IOR ior)
    {
	OutputStream out = new OutputStream();
	out._OB_writeEndian();
	org.omg.IOP.IORHelper.write(out, ior);

	return "IOR:" + Util.octetsToAscii(out.buf_, out.count_);
    }

    public org.omg.CORBA.Object
    string_to_object(String str)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.NVList
    create_list(int count)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.NVList
    create_operation_list(org.omg.CORBA.OperationDef oper)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.NamedValue
    create_named_value(String name, org.omg.CORBA.Any value, int flags)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.ExceptionList
    create_exception_list()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.ContextList
    create_context_list()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.Context
    get_default_context()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.Environment
    create_environment()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public void
    send_multiple_requests_oneway(org.omg.CORBA.Request[] requests)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public void
    send_multiple_requests_deferred(org.omg.CORBA.Request[] requests)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public boolean
    poll_next_response()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.Request
    get_next_response()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    final public org.omg.CORBA.TypeCode
    create_struct_tc(String id,	String name,
		     org.omg.CORBA.StructMember[] members)
    {
	TypeCode tc = new TypeCode();
	tc.kind_ = org.omg.CORBA.TCKind.tk_struct;
	tc.id_ = id;
	tc.name_ = name;
	tc.memberNames_ = new String[members.length];
	tc.memberTypes_ = new TypeCode[members.length];
	for(int i = 0; i < members.length; i++)
	{
	    tc.memberNames_[i] = members[i].name;
	    org.omg.CORBA.TypeCodeHolder h =
		new org.omg.CORBA.TypeCodeHolder(members[i].type);
	    fillRec(h, tc, 1);
	    tc.memberTypes_[i] = (TypeCode)h.value;
	}

	return tc;
    }

    final public org.omg.CORBA.TypeCode
    create_union_tc(String id, String name,
		    org.omg.CORBA.TypeCode discriminatorType,
		    org.omg.CORBA.UnionMember[] members)
    {
	TypeCode tc = new TypeCode();
	tc.kind_ = org.omg.CORBA.TCKind.tk_union;
	tc.id_ = id;
	tc.name_ = name;
	tc.discriminatorType_ = (TypeCode)discriminatorType;
	tc.labels_ = new Any[members.length];
	tc.memberNames_ = new String[members.length];
	tc.memberTypes_ = new TypeCode[members.length];
	for(int i = 0; i < members.length; i++)
	{
	    tc.labels_[i] = members[i].label;
	    tc.memberNames_[i] = members[i].name;
	    org.omg.CORBA.TypeCodeHolder h =
		new org.omg.CORBA.TypeCodeHolder(members[i].type);
	    fillRec(h, tc, 1);
	    tc.memberTypes_[i] = (TypeCode)h.value;
	}

	return tc;
    }

    final public org.omg.CORBA.TypeCode
    create_enum_tc(String id, String name, String[] members)
    {
	TypeCode tc = new TypeCode();
	tc.kind_ = org.omg.CORBA.TCKind.tk_enum;
	tc.id_ = id;
	tc.name_ = name;
	tc.memberNames_ = new String[members.length];
	for(int i = 0; i < members.length; i++)
	    tc.memberNames_[i] = members[i];

	return tc;
    }

    final public org.omg.CORBA.TypeCode
    create_alias_tc(String id, String name,
		    org.omg.CORBA.TypeCode originalType)
    {
	TypeCode tc = new TypeCode();
	tc.kind_ = org.omg.CORBA.TCKind.tk_alias;
	tc.id_ = id;
	tc.name_ = name;
	tc.contentType_ = (TypeCode)originalType;
	
	return tc;
    }

    final public org.omg.CORBA.TypeCode
    create_exception_tc(String id, String name,
			org.omg.CORBA.StructMember[] members)
    {
	TypeCode tc = new TypeCode();
	tc.kind_ = org.omg.CORBA.TCKind.tk_except;
	tc.id_ = id;
	tc.name_ = name;
	tc.memberNames_ = new String[members.length];
	tc.memberTypes_ = new TypeCode[members.length];
	for(int i = 0; i < members.length; i++)
	{
	    tc.memberNames_[i] = members[i].name;
	    org.omg.CORBA.TypeCodeHolder h =
		new org.omg.CORBA.TypeCodeHolder(members[i].type);
	    fillRec(h, tc, 1);
	    tc.memberTypes_[i] = (TypeCode)h.value;
	}

	return tc;
    }

    final public org.omg.CORBA.TypeCode
    create_interface_tc(String id, String name)
    {
	TypeCode tc = new TypeCode();
	tc.kind_ = org.omg.CORBA.TCKind.tk_objref;
	tc.id_ = id;
	tc.name_ = name;

	return tc;
    }

    final public org.omg.CORBA.TypeCode
    create_string_tc(int bound)
    {
	TypeCode tc = new TypeCode();
	tc.kind_ = org.omg.CORBA.TCKind.tk_string;
	tc.length_ = bound;

	return tc;
    }

    final public org.omg.CORBA.TypeCode
    create_wstring_tc(int bound)
    {
	TypeCode tc = new TypeCode();
	tc.kind_ = org.omg.CORBA.TCKind.tk_wstring;
	tc.length_ = bound;

	return tc;
    }

    final public org.omg.CORBA.TypeCode
    create_sequence_tc(int bound, org.omg.CORBA.TypeCode elementType)
    {
	TypeCode tc = new TypeCode();
	tc.kind_ = org.omg.CORBA.TCKind.tk_sequence;
	tc.length_ = bound;
	tc.contentType_ = (TypeCode)elementType;
	tc.offset_ = 0;

	return tc;
    }

    final public org.omg.CORBA.TypeCode
    create_recursive_sequence_tc(int bound, int offset)
    {
	TypeCode tc = new TypeCode();
	tc.kind_ = org.omg.CORBA.TCKind.tk_sequence;
	tc.length_ = bound;
	tc.contentType_ = null;
	tc.offset_ = offset;

	return tc;
    }

    final public org.omg.CORBA.TypeCode
    create_array_tc(int length, org.omg.CORBA.TypeCode elementType)
    {
	TypeCode tc = new TypeCode();
	tc.kind_ = org.omg.CORBA.TCKind.tk_array;
	tc.length_ = length;
	tc.contentType_ = (TypeCode)elementType;

	return tc;
    }

    final public org.omg.CORBA.TypeCode
    get_primitive_tc(org.omg.CORBA.TCKind kind)
    {
	if(kind == org.omg.CORBA.TCKind.tk_null ||
	   kind == org.omg.CORBA.TCKind.tk_void ||
	   kind == org.omg.CORBA.TCKind.tk_short ||
	   kind == org.omg.CORBA.TCKind.tk_long ||
	   kind == org.omg.CORBA.TCKind.tk_ushort ||
	   kind == org.omg.CORBA.TCKind.tk_ulong ||
	   kind == org.omg.CORBA.TCKind.tk_float ||
	   kind == org.omg.CORBA.TCKind.tk_double ||
	   kind == org.omg.CORBA.TCKind.tk_boolean ||
	   kind == org.omg.CORBA.TCKind.tk_char ||
	   kind == org.omg.CORBA.TCKind.tk_octet ||
	   kind == org.omg.CORBA.TCKind.tk_any ||
	   kind == org.omg.CORBA.TCKind.tk_TypeCode ||
	   kind == org.omg.CORBA.TCKind.tk_Principal ||
	   kind == org.omg.CORBA.TCKind.tk_string)
	{
	    TypeCode tc = new TypeCode();
	    tc.kind_ = kind;
	    tc.length_ = 0; // For strings

	    return tc;
	}
	else if(kind == org.omg.CORBA.TCKind.tk_objref)
	{
	    return create_interface_tc("IDL:omg.org/CORBA/Object:1.0",
				       "Object");
	}
	else
	    throw new InternalError();
    }

    public org.omg.CORBA.Any
    create_any()
    {
	return new Any();
    }

    public org.omg.CORBA.portable.OutputStream
    create_output_stream()
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public void
    connect(org.omg.CORBA.Object obj)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public void
    disconnect(org.omg.CORBA.Object obj)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.DynAny
    create_dyn_any(org.omg.CORBA.Any value)
    {
        org.omg.CORBA.DynAny result = null;

        try
        {
            result = _OB_createDynAny(value.type());
            result.from_any(value);
        }
        catch(org.omg.CORBA.DynAnyPackage.Invalid e)
        {
            result = null;
        }

        return result;
    }

    public org.omg.CORBA.DynAny
    create_basic_dyn_any(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    {
        org.omg.CORBA.DynAny result = null;

        org.omg.CORBA.TypeCode tc = ((TypeCode)type)._OB_getOrigType();

        switch(tc.kind().value())
        {
            case org.omg.CORBA.TCKind._tk_null:
            case org.omg.CORBA.TCKind._tk_void:
            case org.omg.CORBA.TCKind._tk_short:
            case org.omg.CORBA.TCKind._tk_long:
            case org.omg.CORBA.TCKind._tk_ushort:
            case org.omg.CORBA.TCKind._tk_ulong:
            case org.omg.CORBA.TCKind._tk_float:
            case org.omg.CORBA.TCKind._tk_double:
            case org.omg.CORBA.TCKind._tk_boolean:
            case org.omg.CORBA.TCKind._tk_char:
            case org.omg.CORBA.TCKind._tk_octet:
            case org.omg.CORBA.TCKind._tk_any:
            case org.omg.CORBA.TCKind._tk_TypeCode:
            case org.omg.CORBA.TCKind._tk_Principal:
            case org.omg.CORBA.TCKind._tk_objref:
            case org.omg.CORBA.TCKind._tk_string:
                result = new DynBasic(type);
                break;

            case org.omg.CORBA.TCKind._tk_struct:
            case org.omg.CORBA.TCKind._tk_except:
            case org.omg.CORBA.TCKind._tk_union:
            case org.omg.CORBA.TCKind._tk_enum:
            case org.omg.CORBA.TCKind._tk_sequence:
            case org.omg.CORBA.TCKind._tk_array:
                throw new org.omg.CORBA.ORBPackage.InconsistentTypeCode();

            case org.omg.CORBA.TCKind._tk_alias:
            default:
                throw new InternalError();
        }

        return result;
    }

    public org.omg.CORBA.DynStruct
    create_dyn_struct(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    {
        org.omg.CORBA.DynStruct result = null;

        org.omg.CORBA.TypeCode tc = ((TypeCode)type)._OB_getOrigType();

        if(tc.kind() == org.omg.CORBA.TCKind.tk_struct)
            result = new DynStruct(type, true);
        else if(tc.kind() == org.omg.CORBA.TCKind.tk_except)
            result = new DynException(type, true);
        else
            throw new org.omg.CORBA.ORBPackage.InconsistentTypeCode();

        return result;
    }

    public org.omg.CORBA.DynSequence
    create_dyn_sequence(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    {
        org.omg.CORBA.TypeCode tc = ((TypeCode)type)._OB_getOrigType();

        if(tc.kind() != org.omg.CORBA.TCKind.tk_sequence)
            throw new org.omg.CORBA.ORBPackage.InconsistentTypeCode();

        return new DynSequence(type);
    }

    public org.omg.CORBA.DynArray
    create_dyn_array(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    {
        org.omg.CORBA.TypeCode tc = ((TypeCode)type)._OB_getOrigType();

        if(tc.kind() != org.omg.CORBA.TCKind.tk_array)
            throw new org.omg.CORBA.ORBPackage.InconsistentTypeCode();

        return new DynArray(type, true);
    }

    public org.omg.CORBA.DynUnion
    create_dyn_union(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    {
        org.omg.CORBA.TypeCode tc = ((TypeCode)type)._OB_getOrigType();

        if(tc.kind() != org.omg.CORBA.TCKind.tk_union)
            throw new org.omg.CORBA.ORBPackage.InconsistentTypeCode();

        return new DynUnion(type);
    }

    public org.omg.CORBA.DynEnum
    create_dyn_enum(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    {
        org.omg.CORBA.TypeCode tc = ((TypeCode)type)._OB_getOrigType();

        if(tc.kind() != org.omg.CORBA.TCKind.tk_enum)
            throw new org.omg.CORBA.ORBPackage.InconsistentTypeCode();

        return new DynEnum(type);
    }

    public org.omg.CORBA.DynFixed
    create_dyn_fixed(org.omg.CORBA.TypeCode type)
        throws org.omg.CORBA.ORBPackage.InconsistentTypeCode
    {
        throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.Policy
    create_policy(int policy_type, org.omg.CORBA.Any val)
         throws org.omg.CORBA.PolicyError
    {
        throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    protected void
    set_parameters(String[] args, java.util.Properties props)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    protected void
    set_parameters(java.applet.Applet app, java.util.Properties props)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    // ------------------------------------------------------------------
    // Additonal ORBacus specific functions
    // ------------------------------------------------------------------

    public org.omg.CORBA.Object
    get_inet_object(String host, int port, String name)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }
    
    public org.omg.CORBA.Object
    get_inet_object(String host, int port, String name, String id)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }
    
    public org.omg.CORBA.BOA
    BOA_init(String[] args, java.util.Properties props)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    public org.omg.CORBA.BOA
    BOA_init(java.applet.Applet app, java.util.Properties props)
    {
	throw new org.omg.CORBA.NO_IMPLEMENT();
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    org.omg.CORBA.DynAny
    _OB_createDynAny(org.omg.CORBA.TypeCode type)
    {
        org.omg.CORBA.DynAny result = null;

        org.omg.CORBA.TypeCode tc = ((TypeCode)type)._OB_getOrigType();

        switch(tc.kind().value())
        {
            case org.omg.CORBA.TCKind._tk_null:
            case org.omg.CORBA.TCKind._tk_void:
            case org.omg.CORBA.TCKind._tk_short:
            case org.omg.CORBA.TCKind._tk_long:
            case org.omg.CORBA.TCKind._tk_ushort:
            case org.omg.CORBA.TCKind._tk_ulong:
            case org.omg.CORBA.TCKind._tk_float:
            case org.omg.CORBA.TCKind._tk_double:
            case org.omg.CORBA.TCKind._tk_boolean:
            case org.omg.CORBA.TCKind._tk_char:
            case org.omg.CORBA.TCKind._tk_octet:
            case org.omg.CORBA.TCKind._tk_any:
            case org.omg.CORBA.TCKind._tk_TypeCode:
            case org.omg.CORBA.TCKind._tk_Principal:
            case org.omg.CORBA.TCKind._tk_objref:
            case org.omg.CORBA.TCKind._tk_string:
                result = new DynBasic(type);
                break;

            case org.omg.CORBA.TCKind._tk_struct:
                result = new DynStruct(type, true);
                break;

            case org.omg.CORBA.TCKind._tk_except:
                result = new DynException(type, true);
                break;

            case org.omg.CORBA.TCKind._tk_union:
                result = new DynUnion(type);
                break;

            case org.omg.CORBA.TCKind._tk_enum:
                result = new DynEnum(type);
                break;

            case org.omg.CORBA.TCKind._tk_sequence:
                result = new DynSequence(type);
                break;

            case org.omg.CORBA.TCKind._tk_array:
                result = new DynArray(type, true);
                break;

            case org.omg.CORBA.TCKind._tk_alias:
            default:
                throw new InternalError();
        }

        return result;
    }

    public ORBSingleton()
    {
    }
}
