// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

//
// This class maintains a list of options starting with a particular prefix.
//

final public class OptionFilter
{
    //
    // Option list
    //
    private java.util.Vector options_ = new java.util.Vector();

    //
    // Prefix for error messages
    //
    private String errorPrefix_;

    //
    // Prefix for the options handled by this filter
    //
    private String optionPrefix_;

    //
    // List with options and their number of arguments
    //
    private java.util.Hashtable argTable_ = new java.util.Hashtable();

    //
    // An option
    //
    public class Option
    {
	public String name;
	public String[] value;

	Option(String n, String[] v)
	{
	    name = n;
	    value = v;
	}
    }

    //
    // Constructor
    //
    public OptionFilter(String errorPrefix, String optionPrefix)
    {
	errorPrefix_ = errorPrefix;
	optionPrefix_ = optionPrefix;
    }

    //
    // Add option string and the number of arguments for this option
    //
    public void
    add(String option, int nrOfArgs)
    {
	argTable_.put(option, new Integer(nrOfArgs));
    }

    //
    // Parse option list by extracting known options.
    // Check if the number of arguments is sufficient for each option.
    //
    public java.util.Enumeration
    parse(MessageViewer viewer, String[] args)
    {
	for(int i = 0 ; i < args.length ; i++)
	{
	    if(args[i].startsWith(optionPrefix_))
	    {
		String option = args[i].substring(optionPrefix_.length());
		Integer nrOfArgs = (Integer)argTable_.get(option);
		if(nrOfArgs != null)
		{
		    int n = nrOfArgs.intValue();
		    String[] value = new String[n];

		    try
		    {
			for(int j = 0 ; j < n ; j++)
			    value[j] = args[++i];

			options_.addElement(new Option(option, value));
		    }
		    catch(ArrayIndexOutOfBoundsException ex)
		    {
			viewer.error(errorPrefix_ +
				     ": argument expected for `" +
				     optionPrefix_ + option + "'");

			throw new org.omg.CORBA.INITIALIZE();
		    }

		    continue;
		}
		else
		    viewer.warning(errorPrefix_ +": unknown option: `" +
				   optionPrefix_ + option + "'");
	    }
	}

	return options_.elements();
    }

    //
    // Filter known options and their arguments
    //
    public String[]
    filter(String[] args)
    {
	java.util.Vector unknown = new java.util.Vector(args.length);

	for(int i = 0 ; i < args.length ; i++)
	{
	    if(args[i].startsWith(optionPrefix_))
	    {
		Integer nrOfArgs = (Integer)argTable_.get(
		    args[i].substring(optionPrefix_.length()));
		if(nrOfArgs != null)
		    i += nrOfArgs.intValue();

		continue;
	    }

	    unknown.addElement(args[i]);
	}

	String[] rem = new String[unknown.size()];
	unknown.copyInto(rem);

	return rem;
    }
}
