// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

// This class must be public
public final class OutputStream extends org.omg.CORBA.portable.OutputStream
{
    ORB fullORB_;
    byte[] buf_;
    int count_;

    // ------------------------------------------------------------------
    // Private and protected functions
    // ------------------------------------------------------------------

    // Write a gap of four bytes (ulong aligned), avoids byte shifts
    private synchronized int
    writeGap()
    {
	if(count_ % 4 != 0)
	{
	    _OB_capacity(count_ + 8 - count_ % 4);
	    count_ += 4 - count_ % 4;
	}
	else
	    _OB_capacity(count_ + 4);

	count_ += 4;

	return count_ - 4;
    }

    private synchronized void
    writeLength(int start)
    {
	int length = count_ - (start + 4);

	buf_[start++] = (byte)(length >>> 24);
	buf_[start++] = (byte)(length >>> 16);
	buf_[start++] = (byte)(length >>> 8);
	buf_[start] = (byte)length;
    }

    private synchronized void
    writeTypeCodeRec(org.omg.CORBA.TypeCode tc, java.util.Vector vec)
    {
	//
        // NOTE:
        //
        // No data with natural alignment of greater than four octets
        // is needed for TypeCode. Therefore it is not necessary to do
        // encapsulation in a separate buffer (12.3.3)
        //

        //
        // The "recursive" function is needed for recursive sequence
        // type codes.  Indirection alone could be handled without the
        // additonal sequence parameter.
        //

	if(tc == null)
	    throw new org.omg.CORBA.BAD_TYPECODE();

	write_ulong(tc.kind().value());

	vec.addElement(new Integer(count_ - 4));

	try
	{
	    switch(tc.kind().value())
	    {
	    case org.omg.CORBA.TCKind._tk_null:
	    case org.omg.CORBA.TCKind._tk_void:
	    case org.omg.CORBA.TCKind._tk_short:
	    case org.omg.CORBA.TCKind._tk_long:
	    case org.omg.CORBA.TCKind._tk_ushort:
	    case org.omg.CORBA.TCKind._tk_ulong:
	    case org.omg.CORBA.TCKind._tk_float:
	    case org.omg.CORBA.TCKind._tk_double:
	    case org.omg.CORBA.TCKind._tk_boolean:
	    case org.omg.CORBA.TCKind._tk_char:
	    case org.omg.CORBA.TCKind._tk_wchar:
	    case org.omg.CORBA.TCKind._tk_octet:
	    case org.omg.CORBA.TCKind._tk_any:
	    case org.omg.CORBA.TCKind._tk_TypeCode:
	    case org.omg.CORBA.TCKind._tk_Principal:
		break;

	    case org.omg.CORBA.TCKind._tk_objref:
	    {
		int start = writeGap();
		_OB_writeEndian();

		write_string(tc.id());
		write_string(tc.name());

		writeLength(start);

		break;
	    }

	    case org.omg.CORBA.TCKind._tk_struct:
	    case org.omg.CORBA.TCKind._tk_except:
	    {
		int start = writeGap();
		_OB_writeEndian();

		write_string(tc.id());
		write_string(tc.name());
		write_ulong(tc.member_count());
		for(int i = 0 ; i < tc.member_count() ; i++)
		{
		    write_string(tc.member_name(i));
		    writeTypeCodeRec(tc.member_type(i), vec);
		}

		writeLength(start);

		break;
	    }
	
	    case org.omg.CORBA.TCKind._tk_union:
	    {
		int start = writeGap();
		_OB_writeEndian();

		write_string(tc.id());
		write_string(tc.name());
                org.omg.CORBA.TypeCode discType = tc.discriminator_type();
		writeTypeCodeRec(discType, vec);
                int defaultIndex = tc.default_index();
		write_long(defaultIndex);
		write_ulong(tc.member_count());
		for(int i = 0 ; i < tc.member_count() ; i++)
		{
                    //
                    // Check for default label value
                    //
                    if(i == defaultIndex)
                    {
			//
			// Marshal a dummy value of the appropriate size
			// for the discriminator type
			//
			TypeCode origDiscType =
			    ((TypeCode)discType)._OB_getOrigType();
			switch(origDiscType.kind().value())
			{
			case org.omg.CORBA.TCKind._tk_short:
			    write_short((short)0);
			    break;
			case org.omg.CORBA.TCKind._tk_ushort:
			    write_ushort((short)0);
			    break;
			case org.omg.CORBA.TCKind._tk_long:
			    write_long(0);
			    break;
			case org.omg.CORBA.TCKind._tk_ulong:
			    write_ulong(0);
			    break;
			case org.omg.CORBA.TCKind._tk_boolean:
			    write_boolean(false);
			    break;
			case org.omg.CORBA.TCKind._tk_char:
			    write_char((char)0);
			    break;
			case org.omg.CORBA.TCKind._tk_enum:
			    write_ulong(0);
			    break;
			default:
			    throw new InternalError();
			}
                    }
                    else
                    {
			tc.member_label(i).write_value(this);
                    }

		    write_string(tc.member_name(i));
		    writeTypeCodeRec(tc.member_type(i), vec);
		}

		writeLength(start);

		break;
	    }

	    case org.omg.CORBA.TCKind._tk_enum:
	    {
		int start = writeGap();
		_OB_writeEndian();

		write_string(tc.id());
		write_string(tc.name());
		write_ulong(tc.member_count());
		for(int i = 0 ; i < tc.member_count() ; i++)
		    write_string(tc.member_name(i));

		writeLength(start);

		break;
	    }

	    case org.omg.CORBA.TCKind._tk_string:
		write_ulong(tc.length());
		break;

	    case org.omg.CORBA.TCKind._tk_sequence:
	    case org.omg.CORBA.TCKind._tk_array:
	    {
		int last = vec.size() - 1;
		if(tc.kind().value() == org.omg.CORBA.TCKind._tk_sequence &&
		   ((TypeCode)tc).offset() > 0 &&
		   last >= ((TypeCode)tc).offset())
		{
		    int kind = -1;

		    int start = writeGap();
		    _OB_writeEndian();
    
		    write_ulong(kind);

		    int posOffset =
		      ((Integer)vec.elementAt(last - ((TypeCode)tc).offset()))
		      .intValue() - count_;
		    if(posOffset >= -4)
			throw new InternalError();

		    write_long(posOffset);
		    write_ulong(tc.length());
		    
		    writeLength(start);
		}
		else
		{
		    int start = writeGap();
		    _OB_writeEndian();
		    
		    writeTypeCodeRec(tc.content_type(), vec);
		    write_ulong(tc.length());
		    
		    writeLength(start);
		}
		    
		break;
	    }

	    case org.omg.CORBA.TCKind._tk_alias:
	    {
		int start = writeGap();
		_OB_writeEndian();

		write_string(tc.id());
		write_string(tc.name());
		writeTypeCodeRec(tc.content_type(), vec);

		writeLength(start);

		break;
	    }

	    default:
		throw new InternalError();
	    }
	}
	catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
	{
	    throw new InternalError();
	}
	catch(org.omg.CORBA.TypeCodePackage.Bounds ex)
	{
	    throw new InternalError();
	}

	vec.setSize(vec.size() - 1);
    }

    // ------------------------------------------------------------------
    // Standard IDL to Java Mapping
    // ------------------------------------------------------------------

    public synchronized org.omg.CORBA.portable.InputStream
    create_input_stream()
    {
 	InputStream in = new InputStream(buf_, count_, 0, false);
	in.fullORB_ = fullORB_;
	return in;
    }

    public synchronized void
    write_boolean(boolean value)
    {
	_OB_capacity(count_ + 1);

	buf_[count_++] = value ? (byte)1 : (byte)0;
    }

    public synchronized void
    write_char(char value)
    {
	if(value > 255)
	    throw new org.omg.CORBA.DATA_CONVERSION();

	_OB_capacity(count_ + 1);

	buf_[count_++] = (byte)value;
    }

    public synchronized void
    write_wchar(char value)
    {
	write_short((short)value);
    }

    public synchronized void
    write_octet(byte value)
    {
	_OB_capacity(count_ + 1);

	buf_[count_++] = value;
    }

    public synchronized void
    write_short(short value)
    {
	if(count_ % 2 != 0)
	{
	    _OB_capacity(count_ + 2 + count_ % 2);
	    count_ += count_ % 2;
	}
	else
	    _OB_capacity(count_ + 2);

	buf_[count_++] = (byte)(value >>> 8);
	buf_[count_++] = (byte)value;
    }

    public synchronized void
    write_ushort(short value)
    {
	write_short(value);
    }

    public synchronized void
    write_long(int value)
    {
	if(count_ % 4 != 0)
	{
	    _OB_capacity(count_ + 8 - count_ % 4);
	    count_ += 4 - count_ % 4;
	}
	else
	    _OB_capacity(count_ + 4);

	buf_[count_++] = (byte)(value >>> 24);
	buf_[count_++] = (byte)(value >>> 16);
	buf_[count_++] = (byte)(value >>> 8);
	buf_[count_++] = (byte)value;
    }

    public synchronized void
    write_ulong(int value)
    {
	write_long(value);
    }

    public synchronized void
    write_longlong(long value)
    {
	if(count_ % 8 != 0)
	{
	    _OB_capacity(count_ + 16 - count_ % 8);
	    count_ += 8 - count_ % 8;
	}
	else
	    _OB_capacity(count_ + 8);

	buf_[count_++] = (byte)(value >>> 56);
	buf_[count_++] = (byte)(value >>> 48);
	buf_[count_++] = (byte)(value >>> 40);
	buf_[count_++] = (byte)(value >>> 32);
	buf_[count_++] = (byte)(value >>> 24);
	buf_[count_++] = (byte)(value >>> 16);
	buf_[count_++] = (byte)(value >>> 8);
	buf_[count_++] = (byte)value;
    }

    public synchronized void
    write_ulonglong(long value)
    {
	write_longlong(value);
    }

    public synchronized void
    write_float(float value)
    {
	write_long(Float.floatToIntBits(value));
    }

    public synchronized void
    write_double(double value)
    {
	write_longlong(Double.doubleToLongBits(value));
    }

    public synchronized void
    write_string(String value)
    {
	for(int i = 0 ; i < value.length() ; i++)
	{
	    if(value.charAt(i) > 255)
		throw new org.omg.CORBA.DATA_CONVERSION();
	}

	write_ulong(value.length() + 1);

	_OB_capacity(count_ + value.length() + 1);

        byte[] buf = value.getBytes();
        System.arraycopy(buf, 0, buf_, count_, value.length());

	count_ += value.length();

	buf_[count_++] = 0;
    }

    public synchronized void
    write_wstring(String value)
    {
	write_ulong(value.length() * 2 + 1);

	_OB_capacity(count_ + value.length() * 2 + 1);

	char[] tmp = new char[value.length()];
	value.getChars(0, value.length(), tmp, 0);

	for(int i = 0 ; i < value.length() ; i++)
	{
	    buf_[count_++] = (byte)(tmp[i] >>> 8);
	    buf_[count_++] = (byte)tmp[i];
	}

	buf_[count_++] = 0;
	buf_[count_++] = 0;
    }

    public synchronized void
    write_boolean_array(boolean[] value, int offset, int length)
    {
	_OB_capacity(count_ + length);

	for(int i = offset ; i < offset + length ; i++)
	    buf_[count_++] = value[i] ? (byte)1 : (byte)0;
    }

    public synchronized void
    write_char_array(char[] value, int offset, int length)
    {
	_OB_capacity(count_ + length);

	for(int i = offset ; i < offset + length ; i++)
	{
	    if(value[i] > 255)
		throw new org.omg.CORBA.DATA_CONVERSION();
	    buf_[count_++] = (byte)value[i];
	}
    }

    public synchronized void
    write_wchar_array(char[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(count_ % 2 != 0)
	{
	    _OB_capacity(count_ + 2 * length + count_ % 2);
	    count_ += count_ % 2;
	}
	else
	    _OB_capacity(count_ + 2 * length);

	for(int i = offset ; i < offset + length ; i++)
	{
	    buf_[count_++] = (byte)(value[i] >>> 8);
	    buf_[count_++] = (byte)value[i];
	}
    }

    public synchronized void
    write_octet_array(byte[] value, int offset, int length)
    {
	_OB_capacity(count_ + length);

	System.arraycopy(value, offset, buf_, count_, length);

	count_ += length;
    }

    public synchronized void
    write_short_array(short[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(count_ % 2 != 0)
	{
	    _OB_capacity(count_ + 2 * length + count_ % 2);
	    count_ += count_ % 2;
	}
	else
	    _OB_capacity(count_ + 2 * length);

	for(int i = offset ; i < offset + length ; i++)
	{
	    buf_[count_++] = (byte)(value[i] >>> 8);
	    buf_[count_++] = (byte)value[i];
	}
    }

    public synchronized void
    write_ushort_array(short[] value, int offset, int length)
    {
	write_short_array(value, offset, length);
    }

    public synchronized void
    write_long_array(int[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(count_ % 4 != 0)
	{
	    _OB_capacity(count_ + 4 + 4 * length - count_ % 4);
	    count_ += 4 - count_ % 4;
	}
	else
	    _OB_capacity(count_ + 4 * length);

	for(int i = offset ; i < offset + length ; i++)
	{
	    buf_[count_++] = (byte)(value[i] >>> 24);
	    buf_[count_++] = (byte)(value[i] >>> 16);
	    buf_[count_++] = (byte)(value[i] >>> 8);
	    buf_[count_++] = (byte)value[i];
	}
    }

    public synchronized void
    write_ulong_array(int[] value, int offset, int length)
    {
	write_long_array(value, offset, length);
    }

    public synchronized void
    write_longlong_array(long[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(count_ % 8 != 0)
	{
	    _OB_capacity(count_ + 8 + 8 * length - count_ % 8);
	    count_ += 8 - count_ % 8;
	}
	else
	    _OB_capacity(count_ + 8 * length);

	for(int i = offset ; i < offset + length ; i++)
	{
	    buf_[count_++] = (byte)(value[i] >>> 56);
	    buf_[count_++] = (byte)(value[i] >>> 48);
	    buf_[count_++] = (byte)(value[i] >>> 40);
	    buf_[count_++] = (byte)(value[i] >>> 32);
	    buf_[count_++] = (byte)(value[i] >>> 24);
	    buf_[count_++] = (byte)(value[i] >>> 16);
	    buf_[count_++] = (byte)(value[i] >>> 8);
	    buf_[count_++] = (byte)value[i];
	}
    }

    public synchronized void
    write_ulonglong_array(long[] value, int offset, int length)
    {
	write_longlong_array(value, offset, length);
    }

    public synchronized void
    write_float_array(float[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(count_ % 4 != 0)
	{
	    _OB_capacity(count_ + 4 + 4 * length - count_ % 4);
	    count_ += 4 - count_ % 4;
	}
	else
	    _OB_capacity(count_ + 4 * length);

	for(int i = offset ; i < offset + length ; i++)
	{
	    int v = Float.floatToIntBits(value[i]);

	    buf_[count_++] = (byte)(v >>> 24);
	    buf_[count_++] = (byte)(v >>> 16);
	    buf_[count_++] = (byte)(v >>> 8);
	    buf_[count_++] = (byte)v;
	}
    }

    public synchronized void
    write_double_array(double[] value, int offset, int length)
    {
	if(length <= 0)
	    return;

	if(count_ % 8 != 0)
	{
	    _OB_capacity(count_ + 8 + 8 * length + - count_ % 8);
	    count_ += 8 - count_ % 8;
	}
	else
	    _OB_capacity(count_ + 8 * length);

	for(int i = offset ; i < offset + length ; i++)
	{
	    long v = Double.doubleToLongBits(value[i]);

	    buf_[count_++] = (byte)(v >>> 56);
	    buf_[count_++] = (byte)(v >>> 48);
	    buf_[count_++] = (byte)(v >>> 40);
	    buf_[count_++] = (byte)(v >>> 32);
	    buf_[count_++] = (byte)(v >>> 24);
	    buf_[count_++] = (byte)(v >>> 16);
	    buf_[count_++] = (byte)(v >>> 8);
	    buf_[count_++] = (byte)v;
	}
    }

    public synchronized void
    write_Object(org.omg.CORBA.Object value)
    {
	if(value == null)
	{
	    org.omg.IOP.IOR ior = new org.omg.IOP.IOR();
	    ior.type_id = "";
	    ior.profiles = new org.omg.IOP.TaggedProfile[0];
	    org.omg.IOP.IORHelper.write(this, ior);
	}
	else
	{
	    Delegate p;

	    try
	    {
		p = (Delegate)
		    ((org.omg.CORBA.portable.ObjectImpl)value)._get_delegate();

		if(fullORB_ == null)
		    fullORB_ = p._OB_orb();
		
		if(fullORB_ == null)
		    throw new org.omg.CORBA.INITIALIZE();
	    }
	    catch(org.omg.CORBA.BAD_OPERATION ex)
	    {
		if(fullORB_ == null)
		    fullORB_ = ORB._OB_defaultORB();
		
		if(fullORB_ == null)
		    throw new org.omg.CORBA.INITIALIZE();

                fullORB_.connect(value);

		p = (Delegate)
		    ((org.omg.CORBA.portable.ObjectImpl)value)
		    ._get_delegate();
	    }

	    org.omg.IOP.IORHelper.write(this, p._OB_ior());
	}
    }

    public synchronized void
    write_TypeCode(org.omg.CORBA.TypeCode tc)
    {
	java.util.Vector vec = new java.util.Vector();
	writeTypeCodeRec(tc, vec);
	if(vec.size() > 0)
	    throw new InternalError();
    }

    public synchronized void
    write_any(org.omg.CORBA.Any value)
    {
	write_TypeCode(value.type());
	value.write_value(this);
    }

    public synchronized void
    write_Principal(org.omg.CORBA.Principal value)
    {
	byte[] v = value.name();
	write_ulong(v.length);
	write_octet_array(v, 0, v.length);
    }

    // ------------------------------------------------------------------
    // Additonal ORBacus specific functions
    // ------------------------------------------------------------------

    public synchronized void
    write_InputStream(org.omg.CORBA.portable.InputStream input,
		      org.omg.CORBA.TypeCode tc)
    {
	InputStream in = (InputStream)input;

	if(in.buf_ != null && in.buf_ == buf_)
	    throw new InternalError();

	_OB_capacity(count_ + in.count_ - in.pos_ + 8);

	try
        {
	    switch(tc.kind().value())
	    {
	    case org.omg.CORBA.TCKind._tk_null:
	    case org.omg.CORBA.TCKind._tk_void:
		break;

	    case org.omg.CORBA.TCKind._tk_short:
	    case org.omg.CORBA.TCKind._tk_ushort:
	    case org.omg.CORBA.TCKind._tk_wchar:
		write_short(in.read_short());
		break;

	    case org.omg.CORBA.TCKind._tk_long:
	    case org.omg.CORBA.TCKind._tk_ulong:
	    case org.omg.CORBA.TCKind._tk_float:
	    case org.omg.CORBA.TCKind._tk_enum:
		write_long(in.read_long());
		break;

	    case org.omg.CORBA.TCKind._tk_double:
	    case org.omg.CORBA.TCKind._tk_longlong:
	    case org.omg.CORBA.TCKind._tk_ulonglong:
		write_longlong(in.read_longlong());
		break;

	    case org.omg.CORBA.TCKind._tk_boolean:
	    case org.omg.CORBA.TCKind._tk_char:
	    case org.omg.CORBA.TCKind._tk_octet:
		write_octet(in.read_octet());
		break;

	    case org.omg.CORBA.TCKind._tk_any:
	    {
		// Don't do this: write_any(in.read_any())
		// This is faster:
		org.omg.CORBA.TypeCode t = in.read_TypeCode();
		write_TypeCode(t);
		write_InputStream(in, t);
		break;
	    }

	    case org.omg.CORBA.TCKind._tk_TypeCode:
	    {
		// Don't do this: write_TypeCode(in.read_TypeCode())
		// This is faster:

		int kind = in.read_ulong();
		write_ulong(kind);
		
		if(kind == -1)
		{
		    int posOffset = in.read_long();
		    write_long(posOffset);
		}
		else
		{
		    switch(kind)
		    {
		    case org.omg.CORBA.TCKind._tk_null:
		    case org.omg.CORBA.TCKind._tk_void:
		    case org.omg.CORBA.TCKind._tk_short:
		    case org.omg.CORBA.TCKind._tk_long:
		    case org.omg.CORBA.TCKind._tk_ushort:
		    case org.omg.CORBA.TCKind._tk_ulong:
		    case org.omg.CORBA.TCKind._tk_float:
		    case org.omg.CORBA.TCKind._tk_double:
		    case org.omg.CORBA.TCKind._tk_boolean:
		    case org.omg.CORBA.TCKind._tk_char:
		    case org.omg.CORBA.TCKind._tk_wchar:
		    case org.omg.CORBA.TCKind._tk_octet:
		    case org.omg.CORBA.TCKind._tk_any:
		    case org.omg.CORBA.TCKind._tk_TypeCode:
		    case org.omg.CORBA.TCKind._tk_Principal:
			break;
			
		    case org.omg.CORBA.TCKind._tk_objref:
		    case org.omg.CORBA.TCKind._tk_struct:
		    case org.omg.CORBA.TCKind._tk_except:
		    case org.omg.CORBA.TCKind._tk_union:
		    case org.omg.CORBA.TCKind._tk_enum:
		    case org.omg.CORBA.TCKind._tk_sequence:
		    case org.omg.CORBA.TCKind._tk_array:
		    case org.omg.CORBA.TCKind._tk_alias:
		    {
			int len = in.read_ulong();
			write_ulong(len);
			System.arraycopy(in.buf_, in.pos_, buf_, count_, len);
			in.pos_ = in.pos_ + len;
			count_ += len;
			break;
		    }
		    
		    case org.omg.CORBA.TCKind._tk_string:
		    case org.omg.CORBA.TCKind._tk_wstring:
			write_ulong(in.read_ulong());
			break;
			
		    default:
			throw new InternalError();
		    }
		    
		    break;
		}
	    }
		
	    case org.omg.CORBA.TCKind._tk_Principal:
		write_Principal(in.read_Principal());
		break;
		
	    case org.omg.CORBA.TCKind._tk_objref:
	    {
		// Don't do this: write_Object(in.read_Object())
		// This is faster:
		org.omg.IOP.IOR ior = org.omg.IOP.IORHelper.read(in);
		org.omg.IOP.IORHelper.write(this, ior);

		if((ior.type_id.length() != 0) || (ior.profiles.length != 0))
		{
		    if(fullORB_ == null)
			fullORB_ = ORB._OB_defaultORB();
		    
		    if(fullORB_ == null)
			throw new org.omg.CORBA.INITIALIZE();
		}

		break;
	    }

	    case org.omg.CORBA.TCKind._tk_struct:
		for(int i = 0 ; i < tc.member_count() ; i++)
		    write_InputStream(in, tc.member_type(i));
		break;

	    case org.omg.CORBA.TCKind._tk_union:
	    {
		int defaultIndex = tc.default_index();
		int memberIndex = -1;

		TypeCode origDiscType =
		    ((TypeCode)tc.discriminator_type())._OB_getOrigType();

		switch(origDiscType.kind().value())
		{
		case org.omg.CORBA.TCKind._tk_short:
		{
		    short val = in.read_short();
		    write_short(val);
		
		    for(int i = 0 ; i < tc.member_count() ; i++)
			if(i != defaultIndex)
			{
			    if(val == tc.member_label(i).extract_short())
			    {
				memberIndex = i;
				break;
			    }
			}
		
		    break;
		}

		case org.omg.CORBA.TCKind._tk_ushort:
		{
		    short val = in.read_ushort();
		    write_ushort(val);

		    for(int i = 0 ; i < tc.member_count() ; i++)
			if(i != defaultIndex)
			{
			    if(val == tc.member_label(i).extract_ushort())
			    {
				memberIndex = i;
				break;
			    }
			}
		
		    break;
		}

		case org.omg.CORBA.TCKind._tk_long:
		{
		    int val = in.read_long();
		    write_long(val);
		
		    for(int i = 0 ; i < tc.member_count() ; i++)
			if(i != defaultIndex)
			{
			    if(val == tc.member_label(i).extract_long())
			    {
				memberIndex = i;
				break;
			    }
			}
		
		    break;
		}

		case org.omg.CORBA.TCKind._tk_ulong:
		{
		    int val = in.read_ulong();
		    write_ulong(val);
		
		    for(int i = 0 ; i < tc.member_count() ; i++)
			if(i != defaultIndex)
			{
			    if(val == tc.member_label(i).extract_ulong())
			    {
				memberIndex = i;
				break;
			    }
			}
		
		    break;
		}

		case org.omg.CORBA.TCKind._tk_char:
		{
		    char val = in.read_char();
		    write_char(val);
		
		    for(int i = 0 ; i < tc.member_count() ; i++)
			if(i != defaultIndex)
			{
			    if(val == tc.member_label(i).extract_char())
			    {
				memberIndex = i;
				break;
			    }
			}
		
		    break;
		}
	    
		case org.omg.CORBA.TCKind._tk_wchar:
		{
		    char val = in.read_wchar();
		    write_wchar(val);
		
		    for(int i = 0 ; i < tc.member_count() ; i++)
			if(i != defaultIndex)
			{
			    if(val == tc.member_label(i).extract_wchar())
			    {
				memberIndex = i;
				break;
			    }
			}
		
		    break;
		}
	    
		case org.omg.CORBA.TCKind._tk_boolean:
		{
		    boolean val = in.read_boolean();
		    write_boolean(val);
		
		    for(int i = 0 ; i < tc.member_count() ; i++)
			if(i != defaultIndex)
			{
			    if(val == tc.member_label(i).extract_boolean())
			    {
				memberIndex = i;
				break;
			    }
			}
		
		    break;
		}
	    
		case org.omg.CORBA.TCKind._tk_octet:
		{
		    byte val = in.read_octet();
		    write_octet(val);
		
		    for(int i = 0 ; i < tc.member_count() ; i++)
			if(i != defaultIndex)
			{
			    if(val == tc.member_label(i).extract_octet())
			    {
				memberIndex = i;
				break;
			    }
			}
		
		    break;
		}
	    
		case org.omg.CORBA.TCKind._tk_enum:
		{
		    int val = in.read_long();
		    write_long(val);
		    
		    for(int i = 0 ; i < tc.member_count() ; i++)
			if(i != defaultIndex)
			{
			    if(val == tc.member_label(i).
			       create_input_stream().read_long())
			    {
				memberIndex = i;
				break;
			    }
			}
		
		    break;
		}

		default:
		    throw new InternalError();
		}

		if(memberIndex >= 0)
		    write_InputStream(in, tc.member_type(memberIndex));
		else if(defaultIndex >= 0)
		    write_InputStream(in, tc.member_type(defaultIndex));
	    
		break;
	    }
	
	    case org.omg.CORBA.TCKind._tk_string:
		write_string(in.read_string());
		break;

	    case org.omg.CORBA.TCKind._tk_wstring:
		write_wstring(in.read_wstring());
		break;

	    case org.omg.CORBA.TCKind._tk_sequence:
	    case org.omg.CORBA.TCKind._tk_array:
	    {
		int len;

		if(tc.kind().value() == org.omg.CORBA.TCKind._tk_sequence)
		{
		    len = in.read_ulong();
		    write_ulong(len);
		}
		else
		    len = tc.length();

		if(len > 0)
		{
		    TypeCode origContentType =
			((TypeCode)tc.content_type())._OB_getOrigType();
		    
		    switch(origContentType.kind().value())
		    {
		    case org.omg.CORBA.TCKind._tk_null:
		    case org.omg.CORBA.TCKind._tk_void:
			break;
			
		    case org.omg.CORBA.TCKind._tk_short:
		    case org.omg.CORBA.TCKind._tk_ushort:
		    case org.omg.CORBA.TCKind._tk_wchar:
		    {
			if(in.swap_)
			{
			    short[] s = new short[len];
			    in.read_short_array(s, 0, len);
			    write_short_array(s, 0, len);
			}
			else
			{
			    // Read one value for the alignment
			    write_short(in.read_short());
			    int n = 2 * (len - 1);

			    if(n > 0)
			    {
				// Copy the rest
				System.arraycopy(in.buf_, in.pos_, buf_,
						 count_, n);
				in.pos_ = in.pos_ + n;
				count_ += n;
			    }
			}
			break;
		    }
		    
		    case org.omg.CORBA.TCKind._tk_long:
		    case org.omg.CORBA.TCKind._tk_ulong:
		    case org.omg.CORBA.TCKind._tk_float:
		    {
			if(in.swap_)
			{
			    int[] i = new int[len];
			    in.read_long_array(i, 0, len);
			    write_long_array(i, 0, len);
			}
			else
			{
			    // Read one value for the alignment
			    write_long(in.read_long());
			    int n = 4 * (len - 1);
			    
			    if(n > 0)
			    {
				// Copy the rest
				System.arraycopy(in.buf_, in.pos_, buf_,
						 count_, n);
				in.pos_ = in.pos_ + n;
				count_ += n;
			    }
			}
			break;
		    }
		    
		    case org.omg.CORBA.TCKind._tk_double:
		    case org.omg.CORBA.TCKind._tk_longlong:
		    case org.omg.CORBA.TCKind._tk_ulonglong:
		    {
			if(in.swap_)
			{
			    long[] l = new long[len];
			    in.read_longlong_array(l, 0, len);
			    write_longlong_array(l, 0, len);
			}
			else
			{
			    // Read one value for the alignment
			    write_longlong(in.read_longlong());
			    int n = 8 * (len - 1);
			    if(n > 0)
			    {
				// Copy the rest
				System.arraycopy(in.buf_, in.pos_, buf_,
						 count_, n);
				in.pos_ = in.pos_ + n;
				count_ += n;
			    }
			}
			break;
		    }
		    
		    case org.omg.CORBA.TCKind._tk_boolean:
		    case org.omg.CORBA.TCKind._tk_char:
		    case org.omg.CORBA.TCKind._tk_octet:
		    {
			System.arraycopy(in.buf_, in.pos_, buf_, count_, len);
			in.pos_ = in.pos_ + len;
			count_ += len;
			break;
		    }
		    
		    case org.omg.CORBA.TCKind._tk_alias:
			throw new InternalError();
			
		    default:
			for(int i = 0 ; i < len ; i++)
			    write_InputStream(in, tc.content_type());
			break;
		    }
		}
		
		break;
	    }
	    
	    case org.omg.CORBA.TCKind._tk_alias:
		write_InputStream(in, tc.content_type());
		break;
		    
	    case org.omg.CORBA.TCKind._tk_except:
		write_string(in.read_string());
		for(int i = 0 ; i < tc.member_count() ; i++)
		    write_InputStream(in, tc.member_type(i));
		break;

	    default:
		throw new InternalError();
	    }
	}
	catch(org.omg.CORBA.TypeCodePackage.BadKind ex)
	{
	    throw new InternalError();
	}
	catch(org.omg.CORBA.TypeCodePackage.Bounds ex)
	{
	    throw new InternalError();
	}
    }

    // ------------------------------------------------------------------
    // ORBacus internal functions
    // Application programs must not use these functions directly
    // ------------------------------------------------------------------

    public
    OutputStream()
    {
        buf_ = new byte[0];
	count_ = 0;
    }

    public
    OutputStream(int max)
    {
	buf_ = new byte[max];
	count_ = 0;
    }

    public synchronized void
    _OB_capacity(int len)
    {
	if(buf_ == null)
	{
	    buf_ = new byte[len];
	}
	if(len > buf_.length)
	{
	    int newLen = len > 2 * count_ ? len : 2 * count_;
	    byte[] newBuf = new byte[newLen];
	    System.arraycopy(buf_, 0, newBuf, 0, count_);
	    buf_ = newBuf;
	}
    }

    public synchronized void
    _OB_writeEndian()
    {
	write_boolean(false); // false means big endian
    }

    // Needed for classes in other packages
    public synchronized byte[]
    _OB_buffer()
    {
	return buf_;
    }

    // Needed for classes in other packages
    public synchronized int
    _OB_count()
    {
	return count_;
    }
}
