// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

package com.ooc.CORBA;

final class PolicyValidator
{
    static void validatePolicies(java.util.Vector l)
         throws org.omg.CORBA.PolicyManagerPackage.InvalidPolicies
    {
        //
        // We need to verify that the set of policies is valid.  Currently
        // this means that we may not have ProtocolPolicy and
        // ConnectionPolicy set at the same time.
        //
        short hasConnectionPolicy = 0;
        short hasProtocolPolicy = 0;
        java.util.Vector indices = new java.util.Vector();

        for(short i = 0; i < l.size(); ++i)
        {
            org.omg.CORBA.Policy policy = (org.omg.CORBA.Policy)l.elementAt(i);
            int policyType = policy.policy_type();
            if(policyType == com.ooc.SSL.CONNECT_POLICY.value)
            {
                ++hasConnectionPolicy;
                indices.addElement(new Integer(i));
            }
            else if(policyType == com.ooc.OB.PROTOCOL_POLICY.value)
            {
                ++hasProtocolPolicy;
                indices.addElement(new Integer(i));
            }
        }

        if(hasConnectionPolicy != 0 && hasProtocolPolicy != 0)
        {
            short[] in = new short[indices.size()];
            for(int i = 0; i < indices.size(); ++i)
                in[i] = ((Short)indices.elementAt(i)).shortValue();
            throw new org.omg.CORBA.PolicyManagerPackage.InvalidPolicies(in);
        }
    }
}
